/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.util;

import java.util.ArrayList;
import java.util.Collection;

public final class ComparableTestHelper {
    private ComparableTestHelper() {
    }

    public static <T extends C, C extends Comparable<C>> void checkCompareToContract(Collection<T> collection) {
        ArrayList<T> list = new ArrayList<T>(collection);
        for (int i = 0; i < list.size(); ++i) {
            for (int j = i; j < list.size(); ++j) {
                Comparable x = (Comparable)list.get(i);
                Comparable y = (Comparable)list.get(j);
                int xCompareToY = x.compareTo(y);
                int yCompareToX = y.compareTo(x);
                assert (Math.signum(xCompareToY) == -Math.signum(yCompareToX));
                for (Comparable z : list) {
                    assert (xCompareToY <= 0 || y.compareTo(z) <= 0 || x.compareTo(z) > 0);
                    assert (xCompareToY != 0 || Math.signum(x.compareTo(z)) == Math.signum(y.compareTo(z)));
                }
            }
        }
    }

    public static <T extends C, C extends Comparable<C>> boolean isConsistentWithEquals(Collection<T> collection) {
        ArrayList<T> list = new ArrayList<T>(collection);
        for (int i = 0; i < list.size(); ++i) {
            for (int j = i; j < list.size(); ++j) {
                Comparable y;
                Comparable x = (Comparable)list.get(i);
                if (x.compareTo(y = (Comparable)list.get(j)) == 0 == x.equals(y)) continue;
                return false;
            }
        }
        return true;
    }
}

