/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.addr;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import rocks.xmpp.addr.AbstractJid;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.precis.PrecisProfiles;
import rocks.xmpp.util.cache.LruCache;

final class FullJid
extends AbstractJid {
    private static final Pattern ESCAPE_PATTERN = Pattern.compile("[ \"&'/:<>@]|\\\\(?=20|22|26|27|2f|3a|3c|3e|40|5c)");
    private static final Pattern UNESCAPE_PATTERN = Pattern.compile("\\\\(20|22|26|27|2f|3a|3c|3e|40|5c)");
    private static final Pattern JID = Pattern.compile("^((.*?)@)?([^/@]+)(/(.*))?$");
    private static final String DOTS = "[.\u3002\uff0e\uff61]";
    private static final Pattern LABEL_SEPARATOR = Pattern.compile("[.\u3002\uff0e\uff61]");
    private static final Pattern LABEL_SEPARATOR_FINAL = Pattern.compile("[.\u3002\uff0e\uff61]$");
    private static final Map<String, Jid> ESCAPED_CACHE = new LruCache<String, Jid>(5000);
    private static final Map<String, Jid> UNESCAPED_CACHE = new LruCache<String, Jid>(5000);
    private static final long serialVersionUID = -3824234106101731424L;
    private final String escapedLocal;
    private final String local;
    private final String domain;
    private final String resource;
    private final Jid bareJid;

    FullJid(CharSequence local, CharSequence domain, CharSequence resource) {
        this(local, domain, resource, false, null);
    }

    private FullJid(CharSequence local, CharSequence domain, CharSequence resource, boolean doUnescape, Jid bareJid) {
        String unescapedLocalPart = doUnescape ? FullJid.unescape(local) : (local != null ? local.toString() : null);
        String escapedLocalPart = FullJid.escape(unescapedLocalPart);
        String enforcedDomainPart = PrecisProfiles.IDN.enforce((CharSequence)LABEL_SEPARATOR_FINAL.matcher(Objects.requireNonNull(domain)).replaceAll(""));
        String enforcedLocalPart = escapedLocalPart != null ? PrecisProfiles.USERNAME_CASE_MAPPED.enforce((CharSequence)escapedLocalPart) : null;
        String enforcedResource = resource != null ? PrecisProfiles.OPAQUE_STRING.enforce(resource) : null;
        FullJid.validateLength(enforcedLocalPart, "local");
        FullJid.validateLength(enforcedResource, "resource");
        FullJid.validateDomain(enforcedDomainPart);
        this.local = FullJid.unescape(enforcedLocalPart);
        this.escapedLocal = enforcedLocalPart;
        this.domain = enforcedDomainPart;
        this.resource = enforcedResource;
        this.bareJid = bareJid != null ? bareJid : (this.isBareJid() ? this : new AbstractJid(){

            @Override
            public Jid asBareJid() {
                return this;
            }

            @Override
            public Jid withLocal(CharSequence local) {
                if (local == null && this.getLocal() == null || local != null && this.getLocal() != null && local.toString().contentEquals(this.getLocal())) {
                    return this;
                }
                return new FullJid(local, this.getDomain(), this.getResource(), false, null);
            }

            @Override
            public Jid withResource(CharSequence resource) {
                if (resource == null) {
                    return this;
                }
                return new FullJid(this.getLocal(), this.getDomain(), resource, false, this.asBareJid());
            }

            @Override
            public Jid atSubdomain(CharSequence subdomain) {
                return new FullJid(this.getLocal(), Objects.requireNonNull(subdomain) + "." + this.getDomain(), this.getResource(), false, null);
            }

            @Override
            public String getLocal() {
                return FullJid.this.getLocal();
            }

            @Override
            public String getEscapedLocal() {
                return FullJid.this.getEscapedLocal();
            }

            @Override
            public String getDomain() {
                return FullJid.this.getDomain();
            }

            @Override
            public String getResource() {
                return null;
            }
        });
    }

    static Jid of(String jid, boolean doUnescape) {
        Objects.requireNonNull(jid, "jid must not be null.");
        jid = jid.trim();
        if (jid.isEmpty()) {
            throw new IllegalArgumentException("jid must not be empty.");
        }
        Jid result = doUnescape ? UNESCAPED_CACHE.get(jid) : ESCAPED_CACHE.get(jid);
        if (result != null) {
            return result;
        }
        Matcher matcher = JID.matcher(jid);
        if (matcher.matches()) {
            FullJid jidValue = new FullJid(matcher.group(2), matcher.group(3), matcher.group(5), doUnescape, null);
            if (doUnescape) {
                UNESCAPED_CACHE.put(jid, jidValue);
            } else {
                ESCAPED_CACHE.put(jid, jidValue);
            }
            return jidValue;
        }
        throw new IllegalArgumentException("Could not parse JID: " + jid);
    }

    private static String escape(CharSequence localPart) {
        if (localPart != null) {
            Matcher matcher = ESCAPE_PATTERN.matcher(localPart);
            StringBuilder sb = new StringBuilder();
            while (matcher.find()) {
                matcher.appendReplacement(sb, "\\\\" + Integer.toHexString(matcher.group().charAt(0)));
            }
            matcher.appendTail(sb);
            return sb.toString();
        }
        return null;
    }

    private static String unescape(CharSequence localPart) {
        if (localPart != null) {
            Matcher matcher = UNESCAPE_PATTERN.matcher(localPart);
            StringBuilder sb = new StringBuilder();
            while (matcher.find()) {
                char c = (char)Integer.parseInt(matcher.group(1), 16);
                if (c == '\\') {
                    matcher.appendReplacement(sb, "\\\\");
                    continue;
                }
                matcher.appendReplacement(sb, String.valueOf(c));
            }
            matcher.appendTail(sb);
            return sb.toString();
        }
        return null;
    }

    private static void validateDomain(String domain) {
        Objects.requireNonNull(domain, "domain must not be null.");
        if (domain.contains("@")) {
            throw new IllegalArgumentException("domain must not contain a '@' sign");
        }
        FullJid.validateLength(domain, "domain");
    }

    private static void validateLength(CharSequence value, CharSequence part) {
        if (value != null) {
            if (value.length() == 0) {
                throw new IllegalArgumentException(part + " must not be empty.");
            }
            if (value.toString().getBytes(StandardCharsets.UTF_8).length > 1023) {
                throw new IllegalArgumentException(part + " must not be greater than 1023 bytes.");
            }
        }
    }

    @Override
    public final Jid asBareJid() {
        return this.bareJid;
    }

    @Override
    public final String getLocal() {
        return this.local;
    }

    @Override
    public final String getEscapedLocal() {
        return this.escapedLocal;
    }

    @Override
    public final String getDomain() {
        return this.domain;
    }

    @Override
    public final String getResource() {
        return this.resource;
    }

    @Override
    public final Jid withLocal(CharSequence local) {
        if (local == null && this.getLocal() == null || local != null && this.getLocal() != null && local.toString().contentEquals(this.getLocal())) {
            return this;
        }
        return new FullJid(local, this.getDomain(), this.getResource(), false, null);
    }

    @Override
    public final Jid withResource(CharSequence resource) {
        if (resource == null && this.getResource() == null || resource != null && this.getResource() != null && resource.toString().contentEquals(this.getResource())) {
            return this;
        }
        return new FullJid(this.getLocal(), this.getDomain(), resource, false, this.asBareJid());
    }

    @Override
    public final Jid atSubdomain(CharSequence subdomain) {
        return new FullJid(this.getLocal(), Objects.requireNonNull(subdomain) + "." + this.getDomain(), this.getResource(), false, null);
    }
}

