/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.util.cache;

import java.util.Collection;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class LruCache<K, V>
implements Map<K, V> {
    final Queue<K> queue;
    private final int maxEntries;
    private final Map<K, V> map;

    public LruCache(int maxEntries) {
        this.maxEntries = maxEntries;
        this.map = new ConcurrentHashMap(maxEntries);
        this.queue = new ConcurrentLinkedDeque<K>();
    }

    @Override
    public final int size() {
        return this.map.size();
    }

    @Override
    public final boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public final boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public final boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public final V get(Object key) {
        V v = this.map.get(key);
        if (v != null) {
            this.keyUsed(key);
        }
        return v;
    }

    private void keyUsed(K key) {
        this.queue.remove(key);
        this.queue.offer(key);
    }

    @Override
    public final V remove(Object key) {
        this.queue.remove(key);
        return this.map.remove(key);
    }

    @Override
    public final boolean remove(Object key, Object value) {
        boolean removed = this.map.remove(key, value);
        if (removed) {
            this.queue.remove(key);
        }
        return removed;
    }

    @Override
    public final void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public final V put(K key, V value) {
        V v = this.map.put(key, value);
        this.keyUsed(key);
        this.limit();
        return v;
    }

    private void limit() {
        while (this.queue.size() > this.maxEntries) {
            K oldestKey = this.queue.poll();
            if (oldestKey == null) continue;
            this.map.remove(oldestKey);
        }
    }

    @Override
    public final void clear() {
        this.queue.clear();
        this.map.clear();
    }

    @Override
    public final Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public final Collection<V> values() {
        return this.map.values();
    }

    @Override
    public final Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public final V putIfAbsent(K key, V value) {
        V v = this.map.putIfAbsent(key, value);
        if (v == null) {
            this.keyUsed(key);
        }
        this.limit();
        return v;
    }

    @Override
    public final boolean replace(K key, V oldValue, V newValue) {
        boolean replaced = this.map.replace(key, oldValue, newValue);
        if (replaced) {
            this.keyUsed(key);
        }
        return replaced;
    }

    @Override
    public final V replace(K key, V value) {
        V v = this.map.replace(key, value);
        if (v != null) {
            this.keyUsed(key);
        }
        return v;
    }

    @Override
    public final V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return (V)this.map.computeIfAbsent((K)key, mappingFunction.andThen(v -> {
            this.keyUsed(key);
            this.limit();
            return v;
        }));
    }

    @Override
    public final V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return (V)this.map.computeIfPresent((K)key, (BiFunction<? super K, Object, Object>)remappingFunction.andThen(v -> {
            this.keyUsed(key);
            this.limit();
            return v;
        }));
    }

    @Override
    public final V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return (V)this.map.compute((K)key, (BiFunction<? super K, Object, Object>)remappingFunction.andThen(v -> {
            this.keyUsed(key);
            this.limit();
            return v;
        }));
    }

    @Override
    public final V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return (V)this.map.merge(key, value, remappingFunction.andThen(v -> {
            this.keyUsed(key);
            this.limit();
            return v;
        }));
    }
}

