/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.util.cache;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class DirectoryCache
implements Map<String, byte[]> {
    private final Path cacheDirectory;

    public DirectoryCache(Path cacheDirectory) {
        this.cacheDirectory = cacheDirectory;
    }

    @Override
    public final int size() {
        try (Stream<Path> files = this.cacheContent();){
            int n = (int)Math.min(files.count(), Integer.MAX_VALUE);
            return n;
        }
    }

    @Override
    public final boolean isEmpty() {
        try (Stream<Path> files = this.cacheContent();){
            boolean bl = files.findAny().map(file -> Boolean.FALSE).orElse(Boolean.TRUE);
            return bl;
        }
    }

    @Override
    public final boolean containsKey(Object key) {
        return Files.exists(this.cacheDirectory.resolve(key.toString()), new LinkOption[0]);
    }

    @Override
    public final boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final byte[] get(Object key) {
        return Optional.ofNullable(key).map(Object::toString).filter(((Predicate<String>)String::isEmpty).negate()).map(this.cacheDirectory::resolve).filter(Files::isReadable).map(file -> {
            try {
                return Files.readAllBytes(file);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }).orElse(null);
    }

    @Override
    public final byte[] put(String key, byte[] value) {
        byte[] data = this.get(key);
        if (!Arrays.equals(data, value)) {
            try {
                if (Files.notExists(this.cacheDirectory, new LinkOption[0])) {
                    Files.createDirectories(this.cacheDirectory, new FileAttribute[0]);
                }
                Path file = this.cacheDirectory.resolve(key);
                Files.write(file, value, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return data;
    }

    @Override
    public final byte[] remove(Object key) {
        byte[] data = this.get(key);
        try {
            Files.deleteIfExists(this.cacheDirectory.resolve(key.toString()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return data;
    }

    @Override
    public final void putAll(Map<? extends String, ? extends byte[]> m) {
        m.forEach(this::put);
    }

    @Override
    public final void clear() {
        try {
            Files.walkFileTree(this.cacheDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.deleteIfExists(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    if (!Files.isSameFile(dir, DirectoryCache.this.cacheDirectory)) {
                        Files.deleteIfExists(dir);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public final Set<String> keySet() {
        Set<String> set;
        block8: {
            Stream<Path> files = Files.list(this.cacheDirectory);
            try {
                set = Collections.unmodifiableSet(files.map(Path::getFileName).map(Path::toString).collect(Collectors.toSet()));
                if (files == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            files.close();
        }
        return set;
    }

    @Override
    public final Collection<byte[]> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Set<Map.Entry<String, byte[]>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void forEach(BiConsumer<? super String, ? super byte[]> action) {
        if (Files.exists(this.cacheDirectory, new LinkOption[0])) {
            try (Stream<Path> files = this.cacheContent().filter(Files::isReadable);){
                files.forEach((? super T file) -> {
                    try {
                        action.accept(file.getFileName().toString(), Files.readAllBytes(file));
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                });
            }
        }
    }

    private final Stream<Path> cacheContent() {
        try {
            return Files.walk(this.cacheDirectory, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

