/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.roster;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.testng.Assert;
import org.testng.annotations.Test;
import rocks.xmpp.core.BaseTest;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.roster.RosterEvent;
import rocks.xmpp.core.roster.RosterListener;
import rocks.xmpp.core.roster.RosterManager;
import rocks.xmpp.core.roster.model.Contact;
import rocks.xmpp.core.roster.model.ContactGroup;
import rocks.xmpp.core.roster.model.Roster;
import rocks.xmpp.core.session.TestXmppSession;
import rocks.xmpp.core.session.XmppSession;

public class RosterManagerTest
extends BaseTest {
    @Test
    public void testRosterListener() throws XMLStreamException, JAXBException {
        final int[] rosterPushCount = new int[1];
        RosterManager rosterManager = new RosterManager((XmppSession)new TestXmppSession());
        rosterManager.addRosterListener(new RosterListener(){

            public void rosterChanged(RosterEvent e) {
                if (rosterPushCount[0] == 0) {
                    Assert.assertEquals((int)e.getAddedContacts().size(), (int)3);
                    Assert.assertEquals((int)e.getUpdatedContacts().size(), (int)0);
                    Assert.assertEquals((int)e.getRemovedContacts().size(), (int)0);
                } else if (rosterPushCount[0] == 1) {
                    Assert.assertEquals((int)e.getAddedContacts().size(), (int)1);
                    Assert.assertEquals((int)e.getUpdatedContacts().size(), (int)0);
                    Assert.assertEquals((int)e.getRemovedContacts().size(), (int)0);
                } else if (rosterPushCount[0] == 2) {
                    Assert.assertEquals((int)e.getAddedContacts().size(), (int)0);
                    Assert.assertEquals((int)e.getUpdatedContacts().size(), (int)0);
                    Assert.assertEquals((int)e.getRemovedContacts().size(), (int)1);
                    Assert.assertEquals((Object)((Contact)e.getRemovedContacts().get(0)).getJid(), (Object)Jid.valueOf((String)"contact2@domain"));
                } else if (rosterPushCount[0] == 3) {
                    Assert.assertEquals((int)e.getAddedContacts().size(), (int)0);
                    Assert.assertEquals((int)e.getUpdatedContacts().size(), (int)1);
                    Assert.assertEquals((int)e.getRemovedContacts().size(), (int)0);
                    Assert.assertEquals((Object)((Contact)e.getUpdatedContacts().get(0)).getJid(), (Object)Jid.valueOf((String)"contact1@domain"));
                    Assert.assertEquals((String)((Contact)e.getUpdatedContacts().get(0)).getName(), (String)"Name");
                }
            }
        });
        Roster roster1 = new Roster();
        roster1.getContacts().add(new Contact(Jid.valueOf((String)"contact1@domain")));
        roster1.getContacts().add(new Contact(Jid.valueOf((String)"contact2@domain")));
        roster1.getContacts().add(new Contact(Jid.valueOf((String)"contact3@domain")));
        rosterManager.updateRoster(roster1, false);
        rosterPushCount[0] = rosterPushCount[0] + 1;
        Roster roster2 = new Roster();
        roster2.getContacts().add(new Contact(Jid.valueOf((String)"contact4@domain")));
        rosterManager.updateRoster(roster2, true);
        rosterPushCount[0] = rosterPushCount[0] + 1;
        Roster roster3 = new Roster();
        Contact contact = new Contact(Jid.valueOf((String)"contact2@domain"));
        contact.setSubscription(Contact.Subscription.REMOVE);
        roster3.getContacts().add(contact);
        rosterManager.updateRoster(roster3, true);
        rosterPushCount[0] = rosterPushCount[0] + 1;
        Roster roster4 = new Roster();
        Contact contact2 = new Contact(Jid.valueOf((String)"contact1@domain"));
        contact2.setName("Name");
        roster4.getContacts().add(contact2);
        rosterManager.updateRoster(roster4, true);
    }

    @Test
    public void testRosterGroups() {
        RosterManager rosterManager = new RosterManager((XmppSession)new TestXmppSession());
        Roster roster1 = new Roster();
        roster1.getContacts().add(new Contact(Jid.valueOf((String)"contact1@domain"), "contact1", new String[]{"Group1"}));
        roster1.getContacts().add(new Contact(Jid.valueOf((String)"contact2@domain"), "contact2", new String[]{"Group2"}));
        roster1.getContacts().add(new Contact(Jid.valueOf((String)"contact4@domain"), "contact4", new String[]{"Group3"}));
        roster1.getContacts().add(new Contact(Jid.valueOf((String)"contact3@domain"), "contact3", new String[]{"Group3"}));
        roster1.getContacts().add(new Contact(Jid.valueOf((String)"contact5@domain"), "contact5", new String[]{"Group3"}));
        rosterManager.updateRoster(roster1, false);
        ArrayList list = new ArrayList(rosterManager.getContactGroups());
        Assert.assertEquals((int)list.size(), (int)3);
        Assert.assertEquals((String)((ContactGroup)list.get(0)).getName(), (String)"Group1");
        Assert.assertEquals((int)((ContactGroup)list.get(0)).getContacts().size(), (int)1);
        Assert.assertEquals((Object)((Contact)((ContactGroup)list.get(0)).getContacts().iterator().next()).getJid(), (Object)Jid.valueOf((String)"contact1@domain"));
        Assert.assertEquals((String)((ContactGroup)list.get(1)).getName(), (String)"Group2");
        Assert.assertEquals((Object)((Contact)((ContactGroup)list.get(1)).getContacts().iterator().next()).getJid(), (Object)Jid.valueOf((String)"contact2@domain"));
        Assert.assertEquals((String)((ContactGroup)list.get(2)).getName(), (String)"Group3");
        Iterator iterator = ((ContactGroup)list.get(2)).getContacts().iterator();
        Assert.assertEquals((Object)((Contact)iterator.next()).getJid(), (Object)Jid.valueOf((String)"contact3@domain"));
        Assert.assertEquals((Object)((Contact)iterator.next()).getJid(), (Object)Jid.valueOf((String)"contact4@domain"));
        Assert.assertEquals((Object)((Contact)iterator.next()).getJid(), (Object)Jid.valueOf((String)"contact5@domain"));
    }

    @Test
    public void testNestedRosterGroups() {
        RosterManager rosterManager = new RosterManager((XmppSession)new TestXmppSession());
        rosterManager.setGroupDelimiter("::");
        Roster roster1 = new Roster();
        roster1.getContacts().add(new Contact(Jid.valueOf((String)"contact3@domain"), "contact3", new String[]{"Group3::SubGroup"}));
        roster1.getContacts().add(new Contact(Jid.valueOf((String)"contact4@domain"), "contact4", new String[]{"Group3::SubGroup::3rdLevel"}));
        roster1.getContacts().add(new Contact(Jid.valueOf((String)"contact5@domain"), "contact5", new String[]{"Group3"}));
        rosterManager.updateRoster(roster1, false);
        ArrayList list = new ArrayList(rosterManager.getContactGroups());
        Assert.assertEquals((int)list.size(), (int)1);
        Assert.assertEquals((Object)((Contact)((ContactGroup)list.get(0)).getContacts().iterator().next()).getJid(), (Object)Jid.valueOf((String)"contact5@domain"));
        Assert.assertEquals((String)((ContactGroup)list.get(0)).getName(), (String)"Group3");
        Assert.assertEquals((int)((ContactGroup)list.get(0)).getContacts().size(), (int)1);
        Assert.assertEquals((int)((ContactGroup)list.get(0)).getGroups().size(), (int)1);
        ContactGroup contactGroup = (ContactGroup)((ContactGroup)list.get(0)).getGroups().iterator().next();
        Assert.assertEquals((String)contactGroup.getName(), (String)"SubGroup");
        Assert.assertEquals((int)contactGroup.getGroups().size(), (int)1);
        Assert.assertEquals((int)contactGroup.getContacts().size(), (int)1);
        Assert.assertEquals((Object)((Contact)contactGroup.getContacts().iterator().next()).getJid(), (Object)Jid.valueOf((String)"contact3@domain"));
        ContactGroup nestedGroup = (ContactGroup)contactGroup.getGroups().iterator().next();
        Assert.assertEquals((String)nestedGroup.getName(), (String)"3rdLevel");
        Assert.assertEquals((int)nestedGroup.getContacts().size(), (int)1);
        Assert.assertEquals((Object)((Contact)nestedGroup.getContacts().iterator().next()).getJid(), (Object)Jid.valueOf((String)"contact4@domain"));
    }

    @Test
    public void testRosterIntegrity() {
        RosterManager rosterManager = new RosterManager((XmppSession)new TestXmppSession());
        Roster roster1 = new Roster();
        roster1.getContacts().add(new Contact(Jid.valueOf((String)"contact1@domain"), "contact1", new String[]{"group1"}));
        roster1.getContacts().add(new Contact(Jid.valueOf((String)"contact2@domain"), "contact2", new String[]{"group2"}));
        roster1.getContacts().add(new Contact(Jid.valueOf((String)"contact3@domain"), "contact3", true, Contact.Subscription.FROM, new String[0]));
        roster1.getContacts().add(new Contact(Jid.valueOf((String)"contact4@domain"), "contact4", true, Contact.Subscription.FROM, new String[]{"group2"}));
        rosterManager.updateRoster(roster1, false);
        Assert.assertEquals((int)rosterManager.getUnaffiliatedContacts().size(), (int)1);
        Assert.assertEquals((Object)((Contact)rosterManager.getUnaffiliatedContacts().iterator().next()).getSubscription(), (Object)Contact.Subscription.FROM);
        ArrayList groups = new ArrayList(rosterManager.getContactGroups());
        Assert.assertEquals((int)((ContactGroup)groups.get(0)).getContacts().size(), (int)1);
        Assert.assertEquals((int)((ContactGroup)groups.get(1)).getContacts().size(), (int)2);
        Roster roster2 = new Roster();
        roster2.getContacts().add(new Contact(Jid.valueOf((String)"contact3@domain"), "contact3", true, Contact.Subscription.BOTH, new String[0]));
        rosterManager.updateRoster(roster2, true);
        Assert.assertEquals((int)rosterManager.getUnaffiliatedContacts().size(), (int)1);
        Assert.assertEquals((Object)((Contact)rosterManager.getUnaffiliatedContacts().iterator().next()).getSubscription(), (Object)Contact.Subscription.BOTH);
        Assert.assertEquals((int)rosterManager.getContactGroups().size(), (int)2);
        Roster roster3 = new Roster();
        roster3.getContacts().add(new Contact(Jid.valueOf((String)"contact2@domain"), "contact2", true, Contact.Subscription.TO, new String[]{"group1"}));
        rosterManager.updateRoster(roster3, true);
        groups = new ArrayList(rosterManager.getContactGroups());
        ArrayList contacts = new ArrayList(((ContactGroup)groups.get(0)).getContacts());
        Assert.assertEquals((int)((ContactGroup)groups.get(0)).getContacts().size(), (int)2);
        Assert.assertEquals((Object)((Contact)contacts.get(1)).getSubscription(), (Object)Contact.Subscription.TO);
        Assert.assertTrue((boolean)((Contact)contacts.get(1)).isPending());
        Assert.assertEquals((int)((ContactGroup)groups.get(1)).getContacts().size(), (int)1);
        Roster roster4 = new Roster();
        Contact contact2 = new Contact(Jid.valueOf((String)"contact3@domain"), "", false, Contact.Subscription.REMOVE, new String[0]);
        roster4.getContacts().add(contact2);
        rosterManager.updateRoster(roster4, true);
        Assert.assertTrue((boolean)rosterManager.getUnaffiliatedContacts().isEmpty());
    }
}

