/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.stanza.client;

import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.testng.Assert;
import org.testng.annotations.Test;
import rocks.xmpp.core.UnmarshalTest;
import rocks.xmpp.core.stanza.model.AbstractMessage;
import rocks.xmpp.core.stanza.model.client.Message;

public class MessageTest
extends UnmarshalTest {
    protected MessageTest() throws JAXBException, XMLStreamException {
        super(Message.class);
    }

    @Test
    public void unmarshalSingleBody() throws XMLStreamException, JAXBException {
        String xml = "<message\n    from='juliet@example.com/balcony'\n    id='b4vs9km4'\n    to='romeo@example.net'\n    type='chat'\n    xml:lang='en'>\n  <body>Wherefore art thou, Romeo?</body>\n</message>";
        Message message = this.unmarshal(xml, Message.class);
        Assert.assertEquals((String)message.getFrom().toString(), (String)"juliet@example.com/balcony");
        Assert.assertEquals((String)message.getTo().toString(), (String)"romeo@example.net");
        Assert.assertEquals((Object)message.getType(), (Object)AbstractMessage.Type.CHAT);
        Assert.assertEquals((String)message.getId(), (String)"b4vs9km4");
        Assert.assertEquals((String)message.getLanguage(), (String)"en");
        Assert.assertEquals((String)message.getBody(), (String)"Wherefore art thou, Romeo?");
    }

    @Test
    public void unmarshalMultipleBodies() throws XMLStreamException, JAXBException {
        String xml = "<message\n    from='juliet@example.com/balcony'\n    id='z94nb37h'\n    to='romeo@example.net'\n    type='chat'\n    xml:lang='en'>\n  <body>Wherefore art thou, Romeo?</body>\n  <body xml:lang='de'>Wo bist du, Romeo?</body>\n</message>";
        Message message = this.unmarshal(xml, Message.class);
        Assert.assertEquals((String)message.getFrom().toString(), (String)"juliet@example.com/balcony");
        Assert.assertEquals((String)message.getTo().toString(), (String)"romeo@example.net");
        Assert.assertEquals((Object)message.getType(), (Object)AbstractMessage.Type.CHAT);
        Assert.assertEquals((String)message.getId(), (String)"z94nb37h");
        Assert.assertEquals((String)message.getLanguage(), (String)"en");
        Assert.assertEquals((String)message.getBody(), (String)"Wherefore art thou, Romeo?");
        Assert.assertEquals((String)((AbstractMessage.Body)message.getBodies().get(1)).getText(), (String)"Wo bist du, Romeo?");
    }

    @Test
    public void unmarshalSingleSubject() throws XMLStreamException, JAXBException {
        String xml = "<message\n    from='juliet@example.com/balcony'\n    id='c8xg3nf8'\n    to='romeo@example.net'\n    type='chat'\n    xml:lang='en'>\n  <subject>I implore you!</subject>\n  <body>Wherefore art thou, Romeo?</body>\n</message>";
        Message message = this.unmarshal(xml, Message.class);
        Assert.assertEquals((String)message.getFrom().toString(), (String)"juliet@example.com/balcony");
        Assert.assertEquals((String)message.getTo().toString(), (String)"romeo@example.net");
        Assert.assertEquals((Object)message.getType(), (Object)AbstractMessage.Type.CHAT);
        Assert.assertEquals((String)message.getId(), (String)"c8xg3nf8");
        Assert.assertEquals((String)message.getLanguage(), (String)"en");
        Assert.assertEquals((String)message.getSubject(), (String)"I implore you!");
        Assert.assertEquals((String)message.getBody(), (String)"Wherefore art thou, Romeo?");
    }

    @Test
    public void unmarshalMultipleSubjects() throws XMLStreamException, JAXBException {
        String xml = "<message\n    from='juliet@example.com/balcony'\n    id='jk3v47gw'\n    to='romeo@example.net'\n    type='chat'\n    xml:lang='en'>\n  <subject>I implore you!</subject>\n  <subject xml:lang='de'>Ich flehe dich an!</subject>\n  <body>Wherefore art thou, Romeo?</body>\n  <body xml:lang='cs'>Wo bist du, Romeo?</body>\n</message>";
        Message message = this.unmarshal(xml, Message.class);
        Assert.assertEquals((String)message.getFrom().toString(), (String)"juliet@example.com/balcony");
        Assert.assertEquals((String)message.getTo().toString(), (String)"romeo@example.net");
        Assert.assertEquals((Object)message.getType(), (Object)AbstractMessage.Type.CHAT);
        Assert.assertEquals((String)message.getId(), (String)"jk3v47gw");
        Assert.assertEquals((String)message.getLanguage(), (String)"en");
        Assert.assertEquals((String)message.getSubject(), (String)"I implore you!");
        Assert.assertEquals((String)((AbstractMessage.Subject)message.getSubjects().get(1)).getText(), (String)"Ich flehe dich an!");
        Assert.assertEquals((String)message.getBody(), (String)"Wherefore art thou, Romeo?");
        Assert.assertEquals((String)((AbstractMessage.Body)message.getBodies().get(1)).getText(), (String)"Wo bist du, Romeo?");
    }

    @Test
    public void unmarshalThread() throws XMLStreamException, JAXBException {
        String xml = "<message\n    from='juliet@example.com/balcony'\n    to='romeo@example.net'\n    type='chat'\n    xml:lang='en'>\n  <thread parent='e0ffe42b28561960c6b12b944a092794b9683a38'>0e3141cd80894871a68e6fe6b1ec56fa</thread>\n</message>";
        Message message = this.unmarshal(xml, Message.class);
        Assert.assertEquals((String)message.getFrom().toString(), (String)"juliet@example.com/balcony");
        Assert.assertEquals((String)message.getTo().toString(), (String)"romeo@example.net");
        Assert.assertEquals((Object)message.getType(), (Object)AbstractMessage.Type.CHAT);
        Assert.assertNull((Object)message.getId());
        Assert.assertEquals((String)message.getLanguage(), (String)"en");
        Assert.assertEquals((String)message.getThread(), (String)"0e3141cd80894871a68e6fe6b1ec56fa");
        Assert.assertEquals((String)message.getParentThread(), (String)"e0ffe42b28561960c6b12b944a092794b9683a38");
    }
}

