/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.roster;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.roster.RosterEvent;
import rocks.xmpp.core.roster.RosterListener;
import rocks.xmpp.core.roster.model.Contact;
import rocks.xmpp.core.roster.model.ContactGroup;
import rocks.xmpp.core.roster.model.Roster;
import rocks.xmpp.core.session.SessionStatusEvent;
import rocks.xmpp.core.session.SessionStatusListener;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.IQEvent;
import rocks.xmpp.core.stanza.IQListener;
import rocks.xmpp.core.stanza.model.AbstractIQ;
import rocks.xmpp.core.stanza.model.StanzaError;
import rocks.xmpp.core.stanza.model.client.IQ;
import rocks.xmpp.core.stanza.model.errors.Condition;
import rocks.xmpp.core.stanza.model.errors.ServiceUnavailable;
import rocks.xmpp.core.stream.model.ClientStreamElement;

public final class RosterManager {
    private static final Logger logger = Logger.getLogger(RosterManager.class.getName());
    private final Map<Jid, Contact> contactMap = new ConcurrentHashMap<Jid, Contact>();
    private final Set<RosterListener> rosterListeners = new CopyOnWriteArraySet<RosterListener>();
    private final XmppSession xmppSession;
    private final Set<ContactGroup> groups = new TreeSet<ContactGroup>();
    private final Set<Contact> unaffiliatedContacts = new TreeSet<Contact>();
    private final Map<String, ContactGroup> rosterGroupMap = new HashMap<String, ContactGroup>();
    private boolean retrieveRosterOnLogin = true;
    private String groupDelimiter = null;

    public RosterManager(final XmppSession xmppSession) {
        this.xmppSession = xmppSession;
        xmppSession.addIQListener(new IQListener(){

            @Override
            public void handle(IQEvent e) {
                IQ iq;
                Roster roster;
                if (e.isIncoming() && !e.isConsumed() && (roster = (Roster)(iq = e.getIQ()).getExtension(Roster.class)) != null) {
                    if (iq.getType() == AbstractIQ.Type.SET) {
                        if (iq.getFrom() == null || iq.getFrom().equals((Object)xmppSession.getConnectedResource().asBareJid())) {
                            xmppSession.send((ClientStreamElement)iq.createResult());
                            RosterManager.this.updateRoster(roster, true);
                        } else {
                            xmppSession.send((ClientStreamElement)iq.createError(new StanzaError((Condition)new ServiceUnavailable())));
                        }
                    } else if (iq.getType() == AbstractIQ.Type.RESULT) {
                        RosterManager.this.updateRoster(roster, false);
                    }
                    e.consume();
                }
            }
        });
        xmppSession.addSessionStatusListener(new SessionStatusListener(){

            @Override
            public void sessionStatusChanged(SessionStatusEvent e) {
                if (e.getStatus() == XmppSession.Status.CLOSED) {
                    RosterManager.this.rosterListeners.clear();
                }
            }
        });
    }

    private static Collection<Contact> collectAllContactsInGroup(ContactGroup contactGroup) {
        ArrayList<Contact> contacts = new ArrayList<Contact>();
        for (Contact contact : contactGroup.getContacts()) {
            RosterManager.addContactIfNotExists(contact, contacts);
        }
        ArrayList<Contact> contactsInSubGroups = new ArrayList<Contact>();
        for (ContactGroup subGroup : contactGroup.getGroups()) {
            contactsInSubGroups.addAll(RosterManager.collectAllContactsInGroup(subGroup));
        }
        for (Contact contact : contactsInSubGroups) {
            RosterManager.addContactIfNotExists(contact, contacts);
        }
        return contacts;
    }

    private static void addContactIfNotExists(Contact contact, Collection<Contact> contacts) {
        boolean contactExists = false;
        for (Contact c : contacts) {
            if (!c.getJid().equals((Object)contact.getJid())) continue;
            contactExists = true;
        }
        if (!contactExists) {
            contacts.add(contact);
        }
    }

    public Collection<Contact> getContacts() {
        return Collections.unmodifiableCollection(this.contactMap.values());
    }

    public Contact getContact(Jid jid) {
        if (jid == null) {
            throw new IllegalArgumentException("jid must not be null");
        }
        return this.contactMap.get(jid.asBareJid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateRoster(Roster roster, boolean isRosterPush) {
        ArrayList<Contact> addedContacts = new ArrayList<Contact>();
        ArrayList<Contact> updatedContacts = new ArrayList<Contact>();
        ArrayList<Contact> removedContacts = new ArrayList<Contact>();
        Collections.sort(roster.getContacts());
        RosterManager rosterManager = this;
        synchronized (rosterManager) {
            if (!isRosterPush) {
                this.rosterGroupMap.clear();
                this.contactMap.clear();
            }
            for (Contact contact : roster.getContacts()) {
                Contact oldContact = this.contactMap.get(contact.getJid());
                if (contact.getSubscription() == Contact.Subscription.REMOVE) {
                    this.contactMap.remove(contact.getJid());
                    removedContacts.add(contact);
                } else if (oldContact != null && !oldContact.equals((Object)contact)) {
                    this.contactMap.put(contact.getJid(), contact);
                    updatedContacts.add(contact);
                } else if (oldContact == null) {
                    this.contactMap.put(contact.getJid(), contact);
                    addedContacts.add(contact);
                }
                if (contact.getSubscription() != Contact.Subscription.REMOVE) {
                    for (String group : contact.getGroups()) {
                        String[] nestedGroups = this.groupDelimiter != null ? group.split(this.groupDelimiter) : new String[]{group};
                        String currentGroupName = "";
                        ContactGroup currentGroup = null;
                        for (int i = 0; i < nestedGroups.length; ++i) {
                            String nestedGroupName = nestedGroups[i];
                            ContactGroup nestedGroup = this.rosterGroupMap.get(currentGroupName = currentGroupName + nestedGroupName);
                            if (nestedGroup == null) {
                                nestedGroup = new ContactGroup(nestedGroupName, currentGroupName, currentGroup);
                                this.rosterGroupMap.put(currentGroupName, nestedGroup);
                                if (i == 0) {
                                    this.groups.add(nestedGroup);
                                }
                                if (currentGroup != null) {
                                    currentGroup.getGroups().add(nestedGroup);
                                }
                            }
                            currentGroup = nestedGroup;
                            if (i >= nestedGroups.length - 1) continue;
                            currentGroupName = currentGroupName + this.groupDelimiter;
                        }
                        if (currentGroup == null) continue;
                        this.removeContactByJid(contact, currentGroup.getContacts());
                        currentGroup.getContacts().add(contact);
                    }
                }
                this.removeContactByJid(contact, this.unaffiliatedContacts);
                if (contact.getGroups().isEmpty() && contact.getSubscription() != Contact.Subscription.REMOVE) {
                    this.unaffiliatedContacts.add(contact);
                }
                this.removeContactsFromGroups(contact, this.groups);
            }
        }
        this.notifyRosterListeners(new RosterEvent(this, addedContacts, updatedContacts, removedContacts));
    }

    private void removeContactByJid(Contact contact, Collection<Contact> contacts) {
        for (Contact c : contacts) {
            if (!c.getJid().equals((Object)contact.getJid())) continue;
            contacts.remove(c);
            break;
        }
    }

    private void removeContactsFromGroups(Contact contact, Collection<ContactGroup> contactGroups) {
        ArrayList<ContactGroup> emptyGroups = new ArrayList<ContactGroup>();
        for (ContactGroup group : contactGroups) {
            if (!this.removeRecursively(contact, group)) continue;
            emptyGroups.add(group);
            this.rosterGroupMap.remove(group.getFullName());
        }
        contactGroups.removeAll(emptyGroups);
    }

    private boolean removeRecursively(Contact contact, ContactGroup contactGroup) {
        this.removeContactsFromGroups(contact, contactGroup.getGroups());
        boolean contactExistsInGroup = false;
        block0: for (Contact c : contactGroup.getContacts()) {
            if (!c.getJid().equals((Object)contact.getJid())) continue;
            for (String groupName : contact.getGroups()) {
                if (!groupName.equals(contactGroup.getFullName())) continue;
                contactExistsInGroup = true;
                break block0;
            }
        }
        if (!contactExistsInGroup || contact.getSubscription() == Contact.Subscription.REMOVE) {
            this.removeContactByJid(contact, contactGroup.getContacts());
        }
        return contactGroup.getContacts().isEmpty() && contactGroup.getGroups().isEmpty();
    }

    public synchronized Collection<ContactGroup> getContactGroups() {
        return Collections.unmodifiableCollection(this.groups);
    }

    public synchronized Collection<Contact> getUnaffiliatedContacts() {
        return Collections.unmodifiableCollection(this.unaffiliatedContacts);
    }

    public void addRosterListener(RosterListener rosterListener) {
        this.rosterListeners.add(rosterListener);
    }

    public void removeRosterListener(RosterListener rosterListener) {
        this.rosterListeners.remove(rosterListener);
    }

    private void notifyRosterListeners(RosterEvent rosterEvent) {
        for (RosterListener rosterListener : this.rosterListeners) {
            try {
                rosterListener.rosterChanged(rosterEvent);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    public boolean isRetrieveRosterOnLogin() {
        return this.retrieveRosterOnLogin;
    }

    public void setRetrieveRosterOnLogin(boolean retrieveRosterOnLogin) {
        this.retrieveRosterOnLogin = retrieveRosterOnLogin;
    }

    public void requestRoster() {
        IQ iq = new IQ(AbstractIQ.Type.GET);
        iq.setExtension((Object)new Roster());
        this.xmppSession.send((ClientStreamElement)iq);
    }

    public void addContact(Contact contact, boolean requestSubscription, String status) throws XmppException {
        if (contact == null) {
            throw new IllegalArgumentException("contact must not be null.");
        }
        Roster roster = new Roster();
        roster.getContacts().add(contact);
        this.xmppSession.query(new IQ(AbstractIQ.Type.SET, (Object)roster));
        if (requestSubscription) {
            this.xmppSession.getPresenceManager().requestSubscription(contact.getJid(), status);
        }
    }

    public void updateContact(Contact contact) throws XmppException {
        this.addContact(contact, false, null);
    }

    public void removeContact(Jid jid) throws XmppException {
        Roster roster = new Roster();
        Contact contact = new Contact(jid);
        contact.setSubscription(Contact.Subscription.REMOVE);
        roster.getContacts().add(contact);
        this.xmppSession.query(new IQ(AbstractIQ.Type.SET, (Object)roster));
    }

    public synchronized void renameContactGroup(ContactGroup contactGroup, String name) throws XmppException {
        int depth = -1;
        ContactGroup parentGroup = contactGroup;
        do {
            parentGroup = parentGroup.getParentGroup();
            ++depth;
        } while (parentGroup != null);
        this.replaceGroupName(contactGroup, name, depth);
    }

    private void replaceGroupName(ContactGroup contactGroup, String name, int index) throws XmppException {
        String newName = name;
        if (this.groupDelimiter != null) {
            String[] groups = contactGroup.getFullName().split(this.groupDelimiter);
            if (index < groups.length) {
                groups[index] = name;
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < groups.length - 1; ++i) {
                sb.append(groups[i]);
                sb.append(this.groupDelimiter);
            }
            sb.append(groups[groups.length - 1]);
            newName = sb.toString();
        }
        for (Contact contact : contactGroup.getContacts()) {
            ArrayList<String> newGroups = new ArrayList<String>(contact.getGroups());
            newGroups.remove(contactGroup.getFullName());
            newGroups.add(newName);
            if (contact.getGroups().equals(newGroups)) continue;
            this.updateContact(new Contact(contact.getJid(), contact.getName(), newGroups));
        }
        for (ContactGroup subGroup : contactGroup.getGroups()) {
            this.replaceGroupName(subGroup, name, index);
        }
    }

    public synchronized void removeContactGroup(ContactGroup contactGroup) throws XmppException {
        Collection<Contact> allContacts = RosterManager.collectAllContactsInGroup(contactGroup);
        if (contactGroup.getParentGroup() != null) {
            for (Contact contact : allContacts) {
                this.updateContact(new Contact(contact.getJid(), contact.getName(), new String[]{contactGroup.getParentGroup().getFullName()}));
            }
        } else {
            for (Contact contact : allContacts) {
                this.updateContact(new Contact(contact.getJid(), contact.getName()));
            }
        }
    }

    public synchronized String getGroupDelimiter() {
        return this.groupDelimiter;
    }

    public synchronized void setGroupDelimiter(String groupDelimiter) {
        this.groupDelimiter = groupDelimiter;
    }
}

