/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.sasl;

import java.io.IOException;
import java.security.Security;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AccountLockedException;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import rocks.xmpp.core.sasl.SaslProvider;
import rocks.xmpp.core.sasl.model.Auth;
import rocks.xmpp.core.sasl.model.Challenge;
import rocks.xmpp.core.sasl.model.Failure;
import rocks.xmpp.core.sasl.model.Mechanisms;
import rocks.xmpp.core.sasl.model.Response;
import rocks.xmpp.core.sasl.model.Success;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stream.FeatureNegotiator;
import rocks.xmpp.core.stream.model.ClientStreamElement;

public final class AuthenticationManager
extends FeatureNegotiator {
    private final XmppSession xmppSession;
    private final Condition authenticationComplete;
    private final LinkedHashSet<String> supportedMechanisms;
    private final Lock lock;
    private LinkedHashSet<String> preferredMechanisms;
    private SaslClient saslClient;
    private volatile Failure authenticationFailure = null;
    private volatile boolean authenticated;
    private String lastPassword;
    private String lastUsername;
    private String lastAuthorizationId;
    private String[] lastMechanisms;
    private CallbackHandler lastCallbackHandler;

    public AuthenticationManager(XmppSession xmppSession, Lock lock) {
        super(Mechanisms.class);
        if (xmppSession == null) {
            throw new IllegalArgumentException("connection must not be null.");
        }
        this.xmppSession = xmppSession;
        this.lock = lock;
        this.authenticationComplete = lock.newCondition();
        this.supportedMechanisms = new LinkedHashSet();
        this.preferredMechanisms = new LinkedHashSet();
        this.preferredMechanisms.add("SCRAM-SHA-1");
        this.preferredMechanisms.add("DIGEST-MD5");
        this.preferredMechanisms.add("GSSAPI");
        this.preferredMechanisms.add("CRAM-MD5");
        this.preferredMechanisms.add("PLAIN");
        this.preferredMechanisms.add("ANONYMOUS");
    }

    public LinkedHashSet<String> getPreferredMechanisms() {
        return this.preferredMechanisms;
    }

    public void setPreferredMechanisms(LinkedHashSet<String> preferredMechanisms) {
        this.preferredMechanisms = preferredMechanisms;
    }

    public void authenticate(String authorizationId, String user, String password, CallbackHandler callbackHandler) throws LoginException, SaslException {
        this.authenticate(this.getCommonMechanisms(), authorizationId, user, password, callbackHandler);
    }

    public void authenticateAnonymously() throws LoginException {
        try {
            this.authenticate(new String[]{"ANONYMOUS"}, null, null, null, null);
        }
        catch (SaslException e) {
            throw new LoginException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void authenticate(String[] mechanisms, String authorizationId, String user, String password, CallbackHandler callbackHandler) throws SaslException, LoginException {
        this.authenticationFailure = null;
        this.authenticated = false;
        this.lastMechanisms = mechanisms;
        this.lastAuthorizationId = authorizationId;
        this.lastUsername = user;
        this.lastPassword = password;
        this.lastCallbackHandler = callbackHandler;
        this.saslClient = this.createSaslClient(mechanisms, authorizationId, user, password, callbackHandler);
        if (this.saslClient == null) {
            throw new SaslException("No SASL client found.");
        }
        byte[] initialResponse = new byte[]{};
        if (this.saslClient.hasInitialResponse()) {
            initialResponse = this.saslClient.evaluateChallenge(new byte[0]);
        }
        this.xmppSession.send((ClientStreamElement)new Auth(this.saslClient.getMechanismName(), initialResponse));
        this.lock.lock();
        try {
            this.authenticationComplete.await(20L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.lock.unlock();
        }
        if (!this.authenticated) {
            if (this.authenticationFailure != null) {
                String failureText = this.authenticationFailure.getText() != null ? this.saslClient.getMechanismName() + " authentication failed: " + this.authenticationFailure.getText() : this.saslClient.getMechanismName() + " authentication failed.";
                if (this.authenticationFailure.getCondition() instanceof Failure.NotAuthorized) {
                    throw new FailedLoginException(failureText);
                }
                if (this.authenticationFailure.getCondition() instanceof Failure.AccountDisabled) {
                    throw new AccountLockedException(failureText);
                }
                if (this.authenticationFailure.getCondition() instanceof Failure.CredentialsExpired) {
                    throw new CredentialExpiredException(failureText);
                }
                throw new LoginException(this.saslClient.getMechanismName() + " authentication failed with condition: " + (this.authenticationFailure.getCondition() != null ? this.authenticationFailure.getCondition().getClass().getSimpleName() : "unknown"));
            }
            throw new LoginException(this.saslClient.getMechanismName() + " authentication failed for an unknown reason, but probably due to timeout.");
        }
    }

    public void reAuthenticate() throws SaslException, LoginException {
        this.authenticate(this.lastMechanisms, this.lastAuthorizationId, this.lastUsername, this.lastPassword, this.lastCallbackHandler);
    }

    private String[] getCommonMechanisms() {
        LinkedHashSet<String> mechanisms = new LinkedHashSet<String>();
        for (String preferredMechanism : this.preferredMechanisms) {
            if (!this.supportedMechanisms.contains(preferredMechanism)) continue;
            mechanisms.add(preferredMechanism);
        }
        return mechanisms.toArray(new String[mechanisms.size()]);
    }

    @Override
    public FeatureNegotiator.Status processNegotiation(Object element) throws Exception {
        FeatureNegotiator.Status status = FeatureNegotiator.Status.INCOMPLETE;
        try {
            if (element instanceof Mechanisms) {
                this.supportedMechanisms.clear();
                this.supportedMechanisms.addAll(((Mechanisms)element).getMechanisms());
            } else if (element instanceof Challenge) {
                this.sendResponse((Challenge)element);
            } else if (element instanceof Failure) {
                this.authenticationFailure = (Failure)element;
                this.authenticated = false;
                this.releaseLock();
                status = FeatureNegotiator.Status.FAILURE;
            } else if (element instanceof Success) {
                this.authenticated = true;
                this.releaseLock();
                status = FeatureNegotiator.Status.SUCCESS;
            }
        }
        catch (Exception e) {
            this.releaseLock();
            throw e;
        }
        finally {
            this.notifyFeatureNegotiated(status, element);
        }
        return status;
    }

    private void releaseLock() {
        this.lock.lock();
        try {
            this.authenticationComplete.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean needsRestart() {
        return true;
    }

    @Override
    public boolean canProcess(Object element) {
        return element instanceof Challenge || element instanceof Failure || element instanceof Success;
    }

    private SaslClient createSaslClient(String[] mechanisms, String authorizationId, final String user, final String password, CallbackHandler callbackHandler) throws SaslException {
        if (callbackHandler == null) {
            callbackHandler = new CallbackHandler(){

                @Override
                public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                    for (Callback callback : callbacks) {
                        if (callback instanceof NameCallback) {
                            ((NameCallback)callback).setName(user);
                        }
                        if (callback instanceof PasswordCallback) {
                            ((PasswordCallback)callback).setPassword(password.toCharArray());
                        }
                        if (!(callback instanceof RealmCallback)) continue;
                        ((RealmCallback)callback).setText(((RealmCallback)callback).getDefaultText());
                    }
                }
            };
        }
        return Sasl.createSaslClient(mechanisms, authorizationId, "xmpp", this.xmppSession.getDomain(), new HashMap(), callbackHandler);
    }

    private void sendResponse(Challenge challenge) throws SaslException {
        byte[] responseArray = this.saslClient.evaluateChallenge(challenge.getValue());
        Response response = new Response(responseArray);
        this.xmppSession.send((ClientStreamElement)response);
    }

    static {
        Security.addProvider(new SaslProvider());
    }
}

