/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.stream;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import rocks.xmpp.core.session.SessionStatusEvent;
import rocks.xmpp.core.session.SessionStatusListener;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stream.FeatureNegotiator;
import rocks.xmpp.core.stream.model.StreamFeature;
import rocks.xmpp.core.stream.model.StreamFeatures;
import rocks.xmpp.core.tls.model.StartTls;

public final class FeaturesManager {
    private final Map<Class<? extends StreamFeature>, StreamFeature> features = new HashMap<Class<? extends StreamFeature>, StreamFeature>();
    private final List<StreamFeature> featuresToNegotiate = new ArrayList<StreamFeature>();
    private final Set<Class<? extends StreamFeature>> negotiatedFeatures = new HashSet<Class<? extends StreamFeature>>();
    private final List<FeatureNegotiator> featureNegotiators = new ArrayList<FeatureNegotiator>();

    public FeaturesManager(XmppSession xmppSession) {
        xmppSession.addSessionStatusListener(new SessionStatusListener(){

            @Override
            public void sessionStatusChanged(SessionStatusEvent e) {
                switch (e.getStatus()) {
                    case CONNECTING: {
                        FeaturesManager.this.features.clear();
                        FeaturesManager.this.featuresToNegotiate.clear();
                        FeaturesManager.this.negotiatedFeatures.clear();
                        break;
                    }
                    case CLOSED: {
                        FeaturesManager.this.featureNegotiators.clear();
                        FeaturesManager.this.featuresToNegotiate.clear();
                        FeaturesManager.this.negotiatedFeatures.clear();
                        FeaturesManager.this.features.clear();
                    }
                }
            }
        });
    }

    public Map<Class<? extends StreamFeature>, StreamFeature> getFeatures() {
        return this.features;
    }

    public void addFeatureNegotiator(FeatureNegotiator featureNegotiator) {
        this.featureNegotiators.add(featureNegotiator);
    }

    public void processFeatures(StreamFeatures featuresElement) throws Exception {
        List featureList = featuresElement.getFeatures();
        ArrayList<StreamFeature> sortedFeatureList = new ArrayList<StreamFeature>();
        this.featuresToNegotiate.clear();
        for (Object feature : featureList) {
            if (!(feature instanceof StreamFeature)) continue;
            StreamFeature f = (StreamFeature)feature;
            this.features.put(f.getClass(), f);
            sortedFeatureList.add(f);
        }
        if (featureList.size() == 1 && featureList.get(0) instanceof StartTls) {
            ((StartTls)featureList.get(0)).setMandatory(true);
        }
        Collections.sort(sortedFeatureList);
        this.featuresToNegotiate.addAll(sortedFeatureList);
        this.negotiateNextFeature();
    }

    public boolean processElement(Object element) throws Exception {
        for (FeatureNegotiator featureNegotiator : this.featureNegotiators) {
            if (featureNegotiator.getFeatureClass() != element && !featureNegotiator.canProcess(element)) continue;
            FeatureNegotiator.Status status = featureNegotiator.processNegotiation(element);
            this.negotiatedFeatures.add(featureNegotiator.getFeatureClass());
            if (status != FeatureNegotiator.Status.SUCCESS && status != FeatureNegotiator.Status.IGNORE) continue;
            if (featureNegotiator.needsRestart()) {
                return true;
            }
            this.negotiateNextFeature();
        }
        return false;
    }

    public void negotiateNextFeature() throws Exception {
        if (this.featuresToNegotiate.size() > 0) {
            StreamFeature advertisedFeature = this.featuresToNegotiate.remove(0);
            if (!this.negotiatedFeatures.contains(advertisedFeature.getClass())) {
                for (FeatureNegotiator featureNegotiator : this.featureNegotiators) {
                    if (featureNegotiator.getFeatureClass() != advertisedFeature.getClass() || featureNegotiator.processNegotiation(advertisedFeature) != FeatureNegotiator.Status.INCOMPLETE) continue;
                    return;
                }
            }
            this.negotiateNextFeature();
        }
    }
}

