/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.subscription;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.roster.model.Contact;
import rocks.xmpp.core.session.SessionStatusEvent;
import rocks.xmpp.core.session.SessionStatusListener;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.PresenceEvent;
import rocks.xmpp.core.stanza.PresenceListener;
import rocks.xmpp.core.stanza.model.AbstractPresence;
import rocks.xmpp.core.stanza.model.client.Presence;
import rocks.xmpp.core.stream.model.ClientStreamElement;

public final class PresenceManager {
    private static final Logger logger = Logger.getLogger(PresenceManager.class.getName());
    private final XmppSession xmppSession;
    private final Map<Jid, Map<String, Presence>> presenceMap = new ConcurrentHashMap<Jid, Map<String, Presence>>();
    private final Map<String, Presence> lastSentPresences = new ConcurrentHashMap<String, Presence>();

    public PresenceManager(final XmppSession xmppSession) {
        this.xmppSession = xmppSession;
        xmppSession.addPresenceListener(new PresenceListener(){

            @Override
            public void handle(PresenceEvent e) {
                Presence presence = e.getPresence();
                if (e.isIncoming()) {
                    if (!PresenceManager.this.presenceMap.containsKey(presence.getFrom().asBareJid())) {
                        PresenceManager.this.presenceMap.put(presence.getFrom().asBareJid(), new ConcurrentHashMap());
                    }
                    Map presencesPerResource = (Map)PresenceManager.this.presenceMap.get(presence.getFrom().asBareJid());
                    presencesPerResource.put(presence.getFrom().getResource() != null ? presence.getFrom().getResource() : "", presence);
                } else if (presence.getType() == null || presence.getType() == AbstractPresence.Type.UNAVAILABLE) {
                    if (presence.getTo() == null) {
                        PresenceManager.this.lastSentPresences.put("", presence);
                    } else {
                        PresenceManager.this.lastSentPresences.put(presence.getTo().toString(), presence);
                    }
                }
            }
        });
        xmppSession.addSessionStatusListener(new SessionStatusListener(){

            @Override
            public void sessionStatusChanged(SessionStatusEvent e) {
                if (e.getStatus() == XmppSession.Status.AUTHENTICATED) {
                    for (Presence presence : PresenceManager.this.lastSentPresences.values()) {
                        xmppSession.send((ClientStreamElement)presence);
                    }
                }
                if (e.getStatus() == XmppSession.Status.DISCONNECTED) {
                    for (Contact contact : xmppSession.getRosterManager().getContacts()) {
                        try {
                            Presence presence = new Presence(AbstractPresence.Type.UNAVAILABLE);
                            presence.setFrom(contact.getJid());
                            xmppSession.handleElement(presence);
                        }
                        catch (Exception e1) {
                            logger.log(Level.WARNING, e1.getMessage(), e1);
                        }
                    }
                }
            }
        });
    }

    public Presence getPresence(Jid jid) {
        Map<String, Presence> presencesPerResource;
        if (jid == null) {
            throw new IllegalArgumentException("jid must not be null.");
        }
        if (jid.isBareJid()) {
            ArrayList<Presence> presences;
            presencesPerResource = this.presenceMap.get(jid);
            if (presencesPerResource != null && !(presences = new ArrayList<Presence>(presencesPerResource.values())).isEmpty()) {
                Collections.sort(presences);
                return (Presence)presences.get(0);
            }
        } else {
            Presence presence;
            presencesPerResource = this.presenceMap.get(jid.asBareJid());
            if (presencesPerResource != null && (presence = presencesPerResource.get(jid.getResource())) != null) {
                return presence;
            }
        }
        Presence presence = new Presence(AbstractPresence.Type.UNAVAILABLE);
        presence.setFrom(jid);
        return presence;
    }

    public String requestSubscription(Jid jid, String status) {
        Presence presence = new Presence(AbstractPresence.Type.SUBSCRIBE);
        presence.setTo(jid.asBareJid());
        presence.setId(UUID.randomUUID().toString());
        presence.setStatus(status);
        this.xmppSession.send((ClientStreamElement)presence);
        return presence.getId();
    }

    public String approveSubscription(Jid jid) {
        Presence presence = new Presence(AbstractPresence.Type.SUBSCRIBED);
        presence.setId(UUID.randomUUID().toString());
        presence.setTo(jid);
        this.xmppSession.send((ClientStreamElement)presence);
        return presence.getId();
    }

    public String denySubscription(Jid jid) {
        Presence presence = new Presence(AbstractPresence.Type.UNSUBSCRIBED);
        presence.setId(UUID.randomUUID().toString());
        presence.setTo(jid);
        this.xmppSession.send((ClientStreamElement)presence);
        return presence.getId();
    }

    public String unsubscribe(Jid jid) {
        Presence presence = new Presence(AbstractPresence.Type.UNSUBSCRIBE);
        presence.setId(UUID.randomUUID().toString());
        presence.setTo(jid);
        this.xmppSession.send((ClientStreamElement)presence);
        return presence.getId();
    }

    public Presence getLastSentPresence() {
        return this.lastSentPresences.get("");
    }
}

