/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.compress;

import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stream.FeatureListener;
import rocks.xmpp.core.stream.FeatureNegotiator;
import rocks.xmpp.core.stream.model.ClientStreamElement;
import rocks.xmpp.extensions.compress.model.Compress;
import rocks.xmpp.extensions.compress.model.Compressed;
import rocks.xmpp.extensions.compress.model.CompressionMethod;
import rocks.xmpp.extensions.compress.model.Failure;
import rocks.xmpp.extensions.compress.model.feature.Compression;

public final class CompressionManager
extends FeatureNegotiator {
    private final XmppSession xmppSession;
    private final CompressionMethod method;

    public CompressionManager(XmppSession xmppSession, FeatureListener featureListener, CompressionMethod compressionMethod) {
        super(Compression.class);
        this.addFeatureListener(featureListener);
        this.xmppSession = xmppSession;
        this.method = compressionMethod;
    }

    @Override
    public FeatureNegotiator.Status processNegotiation(Object element) throws Exception {
        FeatureNegotiator.Status status = FeatureNegotiator.Status.INCOMPLETE;
        try {
            if (element instanceof Compression) {
                if (this.method != null) {
                    this.xmppSession.send((ClientStreamElement)new Compress(this.method));
                    status = FeatureNegotiator.Status.INCOMPLETE;
                } else {
                    status = FeatureNegotiator.Status.IGNORE;
                }
            } else if (element instanceof Compressed) {
                status = FeatureNegotiator.Status.SUCCESS;
            } else if (element instanceof Failure) {
                status = FeatureNegotiator.Status.FAILURE;
                throw new Exception("Failure during compression negotiation: " + ((Failure)element).getCondition());
            }
        }
        finally {
            this.notifyFeatureNegotiated(status, element);
        }
        return status;
    }

    @Override
    public boolean needsRestart() {
        return true;
    }

    @Override
    public boolean canProcess(Object element) {
        return element instanceof Compressed || element instanceof Failure;
    }
}

