/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.httpbind;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.net.ssl.HttpsURLConnection;
import javax.xml.bind.JAXBElement;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.XMLEvent;
import rocks.xmpp.core.XmppUtils;
import rocks.xmpp.core.session.Connection;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.session.debug.XmppDebugger;
import rocks.xmpp.core.stream.model.ClientStreamElement;
import rocks.xmpp.extensions.httpbind.BoshConnectionConfiguration;
import rocks.xmpp.extensions.httpbind.BoshException;
import rocks.xmpp.extensions.httpbind.model.Body;

public final class BoshConnection
extends Connection {
    final Map<Long, Body> unacknowledgedRequests = new ConcurrentSkipListMap<Long, Body>();
    private final AtomicLong rid = new AtomicLong();
    private final Queue<Object> queue = new ConcurrentLinkedQueue<Object>();
    private final ExecutorService httpBindExecutor;
    private final XMLOutputFactory xmlOutputFactory;
    private final XMLInputFactory xmlInputFactory;
    private final BoshConnectionConfiguration boshConnectionConfiguration;
    private final XmppDebugger debugger;
    private volatile long highestReceivedRid;
    private volatile String sessionId;
    private volatile byte requestCount;
    private volatile boolean usingAcknowledgments;
    private URL url;

    BoshConnection(XmppSession xmppSession, BoshConnectionConfiguration configuration) {
        super(xmppSession, configuration);
        this.boshConnectionConfiguration = configuration;
        this.debugger = this.getXmppSession().getConfiguration().getDebugger();
        this.httpBindExecutor = Executors.newFixedThreadPool(2, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, "XMPP BOSH request thread");
                thread.setDaemon(true);
                return thread;
            }
        });
        this.xmlOutputFactory = XMLOutputFactory.newFactory();
        this.xmlInputFactory = XMLInputFactory.newFactory();
    }

    private static void handleCode(int httpCode) throws BoshException {
        if (httpCode != 200) {
            switch (httpCode) {
                case 400: {
                    throw new BoshException(Body.Condition.BAD_REQUEST);
                }
                case 403: {
                    throw new BoshException(Body.Condition.POLICY_VIOLATION);
                }
                case 404: {
                    throw new BoshException(Body.Condition.ITEM_NOT_FOUND);
                }
            }
            throw new BoshException(Body.Condition.UNDEFINED_CONDITION, httpCode);
        }
    }

    private static String findBoshUrl(String xmppServiceDomain) {
        try {
            String query = "_xmppconnect." + xmppServiceDomain;
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            InitialDirContext ctx = new InitialDirContext(env);
            Attributes attributes = ctx.getAttributes(query, new String[]{"TXT"});
            Attribute srvAttribute = attributes.get("TXT");
            if (srvAttribute != null) {
                NamingEnumeration<?> enumeration = srvAttribute.getAll();
                while (enumeration.hasMore()) {
                    String txtRecord = (String)enumeration.next();
                    String[] txtRecordParts = txtRecord.split("=");
                    String key = txtRecordParts[0];
                    String value = txtRecordParts[1];
                    if (!"_xmpp-client-xbosh".equals(key)) continue;
                    return value;
                }
            }
        }
        catch (NamingException e) {
            return null;
        }
        return null;
    }

    @Override
    public synchronized void connect() throws IOException {
        if (this.getXmppSession() == null) {
            throw new IllegalStateException("Can't connect without XmppSession. Use XmppSession to connect.");
        }
        if (this.url == null) {
            String protocol;
            String string = protocol = this.boshConnectionConfiguration.isSecure() ? "https" : "http";
            if (this.getHostname() != null) {
                this.url = new URL(protocol, this.getHostname(), this.getPort(), this.boshConnectionConfiguration.getFile());
            } else if (this.getXmppSession().getDomain() != null) {
                String resolvedUrl = BoshConnection.findBoshUrl(this.getXmppSession().getDomain());
                this.url = resolvedUrl != null ? new URL(resolvedUrl) : new URL(protocol, this.getXmppSession().getDomain(), this.getPort(), this.boshConnectionConfiguration.getFile());
            } else {
                throw new IllegalStateException("Neither an URL nor a domain given for a BOSH connection.");
            }
        }
        this.sessionId = null;
        this.requestCount = 0;
        this.rid.set(new BigInteger(52, new Random()).longValue());
        Body body = new Body();
        if (this.getXmppSession().getDomain() != null && !this.getXmppSession().getDomain().isEmpty()) {
            body.setTo(this.getXmppSession().getDomain());
        }
        body.setLanguage(Locale.getDefault().getLanguage());
        body.setVersion("1.11");
        body.setWait(Integer.valueOf(this.boshConnectionConfiguration.getWait()));
        body.setHold(Byte.valueOf((byte)1));
        body.setRoute(this.boshConnectionConfiguration.getRoute());
        body.setAck(Long.valueOf(1L));
        body.setXmppVersion("1.0");
        this.sendNewRequest(body, false);
    }

    private void unpackBody(Body body, long rid) throws Exception {
        if (body.getSid() != null) {
            this.sessionId = body.getSid();
            if (body.getAck() != null) {
                this.usingAcknowledgments = true;
            }
            if (body.getFrom() != null) {
                this.getXmppSession().setXmppServiceDomain(body.getFrom().getDomain());
            }
        }
        this.highestReceivedRid = body.getRid() != null ? body.getRid() : rid;
        this.unacknowledgedRequests.remove(this.highestReceivedRid);
        if (body.getType() == Body.Type.TERMINATE && body.getCondition() != null && body.getCondition() != Body.Condition.REMOTE_STREAM_ERROR) {
            throw new BoshException(body.getCondition(), body.getUri());
        }
        if (body.getType() == Body.Type.ERROR) {
            for (Body unacknowledgedRequest : this.unacknowledgedRequests.values()) {
                this.sendNewRequest(unacknowledgedRequest, false);
            }
        }
        if (body.getWrappedObjects() != null) {
            for (Object wrappedObject : body.getWrappedObjects()) {
                this.getXmppSession().handleElement(wrappedObject);
            }
        }
    }

    @Override
    protected void restartStream() {
        Body body = new Body();
        body.setRestart(Boolean.valueOf(true));
        body.setTo(this.getXmppSession().getDomain());
        body.setLanguage(Locale.getDefault().getLanguage());
        body.setSid(this.getSessionId());
        this.sendNewRequest(body, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        ExecutorService executorService = this.httpBindExecutor;
        synchronized (executorService) {
            if (!this.httpBindExecutor.isShutdown() && this.sessionId != null) {
                Body body = new Body();
                body.setType(Body.Type.TERMINATE);
                this.sendNewRequest(body, true);
                this.httpBindExecutor.shutdown();
                try {
                    this.httpBindExecutor.awaitTermination(500L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long detach() {
        ExecutorService executorService = this.httpBindExecutor;
        synchronized (executorService) {
            if (!this.httpBindExecutor.isShutdown()) {
                this.httpBindExecutor.shutdown();
            }
        }
        return this.rid.get();
    }

    @Override
    public void send(ClientStreamElement element) {
        this.queue.add(element);
        this.sendNewRequest(new Body(), true);
    }

    public String getSessionId() {
        return this.sessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendNewRequest(final Body body, final boolean addElements) {
        ExecutorService executorService = this.httpBindExecutor;
        synchronized (executorService) {
            if (!this.httpBindExecutor.isShutdown()) {
                this.httpBindExecutor.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        HttpURLConnection httpConnection = null;
                        try {
                            AutoCloseable byteArrayOutputStream;
                            ExecutorService executorService = BoshConnection.this.httpBindExecutor;
                            synchronized (executorService) {
                                Proxy proxy;
                                block40: {
                                    if (addElements) {
                                        body.getWrappedObjects().addAll(BoshConnection.this.queue);
                                        BoshConnection.this.queue.clear();
                                    }
                                    if (body.getType() == Body.Type.TERMINATE || !BoshConnection.this.httpBindExecutor.isShutdown() && (BoshConnection.this.requestCount != 1 || !body.getWrappedObjects().isEmpty() || body.getPause() != null)) break block40;
                                    return;
                                }
                                BoshConnection.access$208(BoshConnection.this);
                                body.setRid(Long.valueOf(BoshConnection.this.rid.getAndIncrement()));
                                body.setSid(BoshConnection.this.getSessionId());
                                if (!BoshConnection.this.unacknowledgedRequests.isEmpty()) {
                                    body.setAck(Long.valueOf(BoshConnection.this.highestReceivedRid));
                                }
                                if (BoshConnection.this.usingAcknowledgments) {
                                    BoshConnection.this.unacknowledgedRequests.put(body.getRid(), body);
                                }
                                if ((httpConnection = (proxy = BoshConnection.this.getProxy()) != null ? (HttpURLConnection)BoshConnection.this.url.openConnection(BoshConnection.this.getProxy()) : (HttpURLConnection)BoshConnection.this.url.openConnection()) instanceof HttpsURLConnection) {
                                    if (BoshConnection.this.boshConnectionConfiguration.getSSLContext() != null) {
                                        ((HttpsURLConnection)httpConnection).setSSLSocketFactory(BoshConnection.this.boshConnectionConfiguration.getSSLContext().getSocketFactory());
                                    }
                                    if (BoshConnection.this.boshConnectionConfiguration.getHostnameVerifier() != null) {
                                        ((HttpsURLConnection)httpConnection).setHostnameVerifier(BoshConnection.this.boshConnectionConfiguration.getHostnameVerifier());
                                    }
                                }
                                httpConnection.setRequestProperty("Content-Type", "text/xml; charset=utf-8");
                                httpConnection.setDoOutput(true);
                                httpConnection.setRequestMethod("POST");
                                if (BoshConnection.this.getXmppSession().getStatus() == XmppSession.Status.CONNECTING) {
                                    httpConnection.setReadTimeout(10000);
                                } else {
                                    httpConnection.setReadTimeout((BoshConnection.this.boshConnectionConfiguration.getWait() + 5) * 1000);
                                }
                                ByteArrayOutputStream byteArrayOutputStreamRequest = new ByteArrayOutputStream();
                                try (XMLStreamWriter xmlStreamWriter = null;){
                                    OutputStream branchedOutputStream = XmppUtils.createBranchedOutputStream((OutputStream)httpConnection.getOutputStream(), (OutputStream)byteArrayOutputStreamRequest);
                                    OutputStream xmppOutputStream = BoshConnection.this.debugger != null ? BoshConnection.this.debugger.createOutputStream(branchedOutputStream) : branchedOutputStream;
                                    xmlStreamWriter = XmppUtils.createXmppStreamWriter((XMLStreamWriter)BoshConnection.this.xmlOutputFactory.createXMLStreamWriter(xmppOutputStream, "UTF-8"), (boolean)true);
                                    BoshConnection.this.getXmppSession().getMarshaller().marshal((Object)body, xmlStreamWriter);
                                    if (BoshConnection.this.debugger != null) {
                                        BoshConnection.this.debugger.writeStanza(byteArrayOutputStreamRequest.toString(), body);
                                    }
                                }
                            }
                            if (httpConnection.getResponseCode() == 200) {
                                byteArrayOutputStream = new ByteArrayOutputStream();
                                XMLEventReader xmlEventReader = null;
                                InputStream inputStream = XmppUtils.createBranchedInputStream((InputStream)httpConnection.getInputStream(), (OutputStream)byteArrayOutputStream);
                                InputStream xmppInputStream = BoshConnection.this.debugger != null ? BoshConnection.this.debugger.createInputStream(inputStream) : inputStream;
                                try {
                                    xmlEventReader = BoshConnection.this.xmlInputFactory.createXMLEventReader(xmppInputStream, "UTF-8");
                                    while (xmlEventReader.hasNext()) {
                                        XMLEvent xmlEvent = xmlEventReader.peek();
                                        if (xmlEvent.isStartElement()) {
                                            ExecutorService executorService2 = BoshConnection.this.httpBindExecutor;
                                            synchronized (executorService2) {
                                                JAXBElement element = BoshConnection.this.getXmppSession().getUnmarshaller().unmarshal(xmlEventReader, Body.class);
                                                if (BoshConnection.this.debugger != null) {
                                                    BoshConnection.this.debugger.readStanza(((ByteArrayOutputStream)byteArrayOutputStream).toString(), element.getValue());
                                                }
                                                BoshConnection.this.unpackBody((Body)element.getValue(), body.getRid());
                                                continue;
                                            }
                                        }
                                        xmlEventReader.next();
                                    }
                                }
                                finally {
                                    if (xmlEventReader != null) {
                                        xmlEventReader.close();
                                    }
                                }
                            } else {
                                BoshConnection.handleCode(httpConnection.getResponseCode());
                            }
                            byteArrayOutputStream = BoshConnection.this.httpBindExecutor;
                            synchronized (byteArrayOutputStream) {
                                if ((BoshConnection.this.requestCount = (byte)(BoshConnection.this.requestCount - 1)) == 0) {
                                    BoshConnection.this.sendNewRequest(new Body(), true);
                                }
                            }
                        }
                        catch (Exception e) {
                            BoshConnection.this.getXmppSession().notifyException(e);
                        }
                        finally {
                            if (httpConnection != null) {
                                httpConnection.disconnect();
                            }
                        }
                    }
                });
            }
        }
    }

    public String getRoute() {
        return this.boshConnectionConfiguration.getRoute();
    }

    static /* synthetic */ byte access$208(BoshConnection x0) {
        byte by = x0.requestCount;
        x0.requestCount = (byte)(by + 1);
        return by;
    }
}

