/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.session;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.session.ChatSession;
import rocks.xmpp.core.session.ChatSessionEvent;
import rocks.xmpp.core.session.ChatSessionListener;
import rocks.xmpp.core.session.SessionStatusEvent;
import rocks.xmpp.core.session.SessionStatusListener;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.MessageEvent;
import rocks.xmpp.core.stanza.MessageListener;
import rocks.xmpp.core.stanza.PresenceEvent;
import rocks.xmpp.core.stanza.PresenceListener;
import rocks.xmpp.core.stanza.model.AbstractMessage;
import rocks.xmpp.core.stanza.model.client.Message;
import rocks.xmpp.core.stanza.model.client.Presence;

public final class ChatManager {
    private static final Logger logger = Logger.getLogger(ChatManager.class.getName());
    private final XmppSession xmppSession;
    private final Map<Jid, Map<String, ChatSession>> chatSessions = new ConcurrentHashMap<Jid, Map<String, ChatSession>>();
    private final Set<ChatSessionListener> chatSessionListeners = new CopyOnWriteArraySet<ChatSessionListener>();

    public ChatManager(final XmppSession xmppSession) {
        this.xmppSession = xmppSession;
        xmppSession.addMessageListener(new MessageListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handle(MessageEvent e) {
                Message message = e.getMessage();
                if (message.getType() == AbstractMessage.Type.CHAT && message.getBody() != null && !message.getBody().isEmpty()) {
                    String threadId;
                    Jid chatPartner = e.isIncoming() ? message.getFrom() : message.getTo();
                    String string = threadId = message.getThread() != null ? message.getThread() : UUID.randomUUID().toString();
                    if (chatPartner != null) {
                        Jid contact = chatPartner.asBareJid();
                        Map map = ChatManager.this.chatSessions;
                        synchronized (map) {
                            ChatSession chatSession;
                            Map chatSessionMap;
                            if (!ChatManager.this.chatSessions.containsKey(contact)) {
                                ChatManager.this.chatSessions.put(contact, new HashMap());
                            }
                            if (!(chatSessionMap = (Map)ChatManager.this.chatSessions.get(contact)).containsKey(threadId)) {
                                chatSession = new ChatSession(chatPartner, threadId, xmppSession);
                                chatSessionMap.put(threadId, chatSession);
                                ChatManager.this.notifyChatSessionCreated(chatSession, e.isIncoming());
                            }
                            chatSession = (ChatSession)chatSessionMap.get(threadId);
                            if (e.isIncoming()) {
                                chatSession.chatPartner = message.getFrom();
                            }
                            chatSession.notifyMessageListeners(message, e.isIncoming());
                        }
                    }
                }
            }
        });
        xmppSession.addPresenceListener(new PresenceListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handle(PresenceEvent e) {
                if (e.isIncoming()) {
                    Presence presence = e.getPresence();
                    Map map = ChatManager.this.chatSessions;
                    synchronized (map) {
                        Jid contact = presence.getFrom().asBareJid();
                        if (ChatManager.this.chatSessions.containsKey(contact)) {
                            for (ChatSession chatSession : ((Map)ChatManager.this.chatSessions.get(contact)).values()) {
                                chatSession.chatPartner = contact;
                            }
                        }
                    }
                }
            }
        });
        xmppSession.addSessionStatusListener(new SessionStatusListener(){

            @Override
            public void sessionStatusChanged(SessionStatusEvent e) {
                if (e.getStatus() == XmppSession.Status.CLOSED) {
                    ChatManager.this.chatSessionListeners.clear();
                    ChatManager.this.chatSessions.clear();
                }
            }
        });
    }

    public void addChatSessionListener(ChatSessionListener chatSessionListener) {
        this.chatSessionListeners.add(chatSessionListener);
    }

    public void removeChatSessionListener(ChatSessionListener chatSessionListener) {
        this.chatSessionListeners.remove(chatSessionListener);
    }

    private void notifyChatSessionCreated(ChatSession chatSession, boolean createdByIncomingMessage) {
        for (ChatSessionListener chatSessionListener : this.chatSessionListeners) {
            try {
                chatSessionListener.chatSessionCreated(new ChatSessionEvent(this, chatSession, createdByIncomingMessage));
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    public ChatSession createChatSession(Jid chatPartner) {
        if (chatPartner == null) {
            throw new IllegalArgumentException("chatPartner must not be null.");
        }
        ChatSession chatSession = new ChatSession(chatPartner, UUID.randomUUID().toString(), this.xmppSession);
        this.notifyChatSessionCreated(chatSession, false);
        return chatSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyChatSession(ChatSession chatSession) {
        if (chatSession == null) {
            throw new IllegalArgumentException("chatSession must not be null.");
        }
        Jid user = chatSession.getChatPartner().asBareJid();
        Map<Jid, Map<String, ChatSession>> map = this.chatSessions;
        synchronized (map) {
            if (this.chatSessions.containsKey(user)) {
                Map<String, ChatSession> chatSessionMap = this.chatSessions.get(user);
                chatSessionMap.remove(chatSession.getThread());
                if (chatSessionMap.isEmpty()) {
                    this.chatSessions.remove(user);
                }
            }
        }
    }
}

