/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.session;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.MessageEvent;
import rocks.xmpp.core.stanza.MessageListener;
import rocks.xmpp.core.stanza.model.AbstractMessage;
import rocks.xmpp.core.stanza.model.client.Message;
import rocks.xmpp.core.stream.model.ClientStreamElement;

public final class ChatSession {
    private static final Logger logger = Logger.getLogger(ChatSession.class.getName());
    private final String thread;
    private final XmppSession xmppSession;
    private final Set<MessageListener> messageListeners = new CopyOnWriteArraySet<MessageListener>();
    volatile Jid chatPartner;

    ChatSession(Jid chatPartner, String thread, XmppSession xmppSession) {
        if (chatPartner == null) {
            throw new IllegalArgumentException("chatPartner must not be null.");
        }
        if (xmppSession == null) {
            throw new IllegalArgumentException("connection must not be null.");
        }
        this.chatPartner = chatPartner.asBareJid();
        this.thread = thread;
        this.xmppSession = xmppSession;
    }

    public void addMessageListener(MessageListener stanzaListener) {
        this.messageListeners.add(stanzaListener);
    }

    public void removeMessageListener(MessageListener stanzaListener) {
        this.messageListeners.remove(stanzaListener);
    }

    void notifyMessageListeners(Message message, boolean incoming) {
        for (MessageListener messageListener : this.messageListeners) {
            try {
                messageListener.handle(new MessageEvent((Object)this, message, incoming));
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    public void send(Message message) {
        message.setType(AbstractMessage.Type.CHAT);
        message.setThread(this.thread);
        message.setTo(this.chatPartner);
        this.xmppSession.send((ClientStreamElement)message);
    }

    public Jid getChatPartner() {
        return this.chatPartner;
    }

    public String getThread() {
        return this.thread;
    }
}

