/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.session;

import java.io.IOException;
import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.security.auth.login.LoginException;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.ReconnectionStrategy;
import rocks.xmpp.core.session.SessionStatusEvent;
import rocks.xmpp.core.session.SessionStatusListener;
import rocks.xmpp.core.session.TruncatedBinaryExponentialBackOffStrategy;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stream.model.StreamException;
import rocks.xmpp.core.stream.model.errors.Conflict;

public final class ReconnectionManager
extends Manager {
    private final ScheduledExecutorService scheduledExecutorService;
    private final XmppSession xmppSession;
    private ReconnectionStrategy reconnectionStrategy;
    private volatile ScheduledFuture<?> scheduledFuture;
    private volatile Date nextReconnectionAttempt;

    ReconnectionManager(XmppSession xmppSession) {
        this.xmppSession = xmppSession;
        this.reconnectionStrategy = new TruncatedBinaryExponentialBackOffStrategy(60, 5);
        this.setEnabled(true);
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, "XMPP Reconnection Thread");
                thread.setDaemon(true);
                return thread;
            }
        });
        xmppSession.addSessionStatusListener(new SessionStatusListener(){

            @Override
            public void sessionStatusChanged(SessionStatusEvent e) {
                switch (e.getStatus()) {
                    case DISCONNECTED: {
                        if (e.getException() instanceof StreamException && ((StreamException)e.getException()).getStreamError().getCondition() instanceof Conflict || e.getOldStatus() != XmppSession.Status.AUTHENTICATED) break;
                        ReconnectionManager.this.scheduleReconnection(0);
                        break;
                    }
                    case CONNECTED: {
                        ReconnectionManager.this.cancel();
                        break;
                    }
                    case CLOSED: {
                        ReconnectionManager.this.cancel();
                        ReconnectionManager.this.scheduledExecutorService.shutdown();
                    }
                }
            }
        });
    }

    private void cancel() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
            this.nextReconnectionAttempt = null;
        }
    }

    private void scheduleReconnection(final int attempt) {
        if (this.isEnabled()) {
            int seconds = this.reconnectionStrategy.getNextReconnectionAttempt(attempt);
            this.nextReconnectionAttempt = new Date(System.currentTimeMillis() + (long)(seconds * 1000));
            this.scheduledFuture = this.scheduledExecutorService.schedule(new Runnable(){

                @Override
                public void run() {
                    try {
                        ReconnectionManager.this.xmppSession.reconnect();
                    }
                    catch (IOException | LoginException e1) {
                        ReconnectionManager.this.scheduleReconnection(attempt + 1);
                    }
                }
            }, (long)seconds, TimeUnit.SECONDS);
        }
    }

    public ReconnectionStrategy getReconnectionStrategy() {
        return this.reconnectionStrategy;
    }

    public void setReconnectionStrategy(ReconnectionStrategy reconnectionStrategy) {
        this.reconnectionStrategy = reconnectionStrategy;
    }

    public Date getNextReconnectionAttempt() {
        return this.nextReconnectionAttempt;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (!enabled) {
            this.cancel();
        }
    }
}

