/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.session;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import rocks.xmpp.core.session.Connection;
import rocks.xmpp.core.session.TcpConnectionConfiguration;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.session.XmppStreamReader;
import rocks.xmpp.core.session.XmppStreamWriter;
import rocks.xmpp.core.stream.FeatureEvent;
import rocks.xmpp.core.stream.FeatureListener;
import rocks.xmpp.core.stream.FeatureNegotiator;
import rocks.xmpp.core.stream.model.ClientStreamElement;
import rocks.xmpp.core.tls.SecurityManager;
import rocks.xmpp.extensions.compress.CompressionManager;

public final class TcpConnection
extends Connection {
    private final TcpConnectionConfiguration tcpConnectionConfiguration;
    volatile String streamId;
    private volatile Socket socket;
    private XmppStreamWriter xmppStreamWriter;
    private XmppStreamReader xmppStreamReader;
    private InputStream inputStream;
    private OutputStream outputStream;

    TcpConnection(XmppSession xmppSession, TcpConnectionConfiguration configuration) {
        super(xmppSession, configuration);
        this.tcpConnectionConfiguration = configuration;
        xmppSession.getFeaturesManager().addFeatureNegotiator(new SecurityManager(xmppSession, new FeatureListener(){

            @Override
            public void negotiationStatusChanged(FeatureEvent featureEvent) throws Exception {
                if (featureEvent.getStatus() == FeatureNegotiator.Status.SUCCESS) {
                    TcpConnection.this.secureConnection();
                }
            }
        }, configuration.isSecure()));
        xmppSession.getFeaturesManager().addFeatureNegotiator(new CompressionManager(xmppSession, new FeatureListener(){

            @Override
            public void negotiationStatusChanged(FeatureEvent featureEvent) {
                if (featureEvent.getStatus() == FeatureNegotiator.Status.SUCCESS) {
                    TcpConnection.this.compressStream();
                }
            }
        }, configuration.getCompressionMethod()));
    }

    @Override
    public synchronized void connect() throws IOException {
        if (this.getXmppSession() == null) {
            throw new IllegalStateException("Can't connect without XmppSession. Use XmppSession to connect.");
        }
        if (this.getHostname() != null && !this.getHostname().isEmpty()) {
            this.connectToSocket(InetAddress.getByName(this.getHostname()), this.getPort(), this.getProxy());
        } else if (this.getXmppSession().getDomain() != null) {
            if (!this.connectWithXmppServiceDomain(this.getXmppSession().getDomain())) {
                this.connectToSocket(InetAddress.getByName(this.getXmppSession().getDomain()), this.getPort(), this.getProxy());
            }
        } else {
            throw new IllegalStateException("Neither 'xmppServiceDomain' nor 'host' is set.");
        }
        this.outputStream = new BufferedOutputStream(this.socket.getOutputStream());
        this.inputStream = new BufferedInputStream(this.socket.getInputStream());
        XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newFactory();
        try {
            this.xmppStreamWriter = new XmppStreamWriter(this.outputStream, this.getXmppSession(), xmlOutputFactory, this.tcpConnectionConfiguration.getKeepAliveInterval());
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
        this.xmppStreamWriter.openStream(null);
        try {
            this.xmppStreamReader = new XmppStreamReader(this, this.getXmppSession(), xmlOutputFactory);
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
        this.xmppStreamReader.startReading(this.inputStream);
    }

    private void connectToSocket(InetAddress inetAddress, int port, Proxy proxy) throws IOException {
        if (this.tcpConnectionConfiguration.getSocketFactory() == null) {
            this.socket = proxy != null ? new Socket(proxy) : new Socket();
            this.socket.connect(new InetSocketAddress(inetAddress, port));
        } else {
            this.socket = this.tcpConnectionConfiguration.getSocketFactory().createSocket(inetAddress, port);
        }
    }

    private void secureConnection() throws IOException, CertificateException, NoSuchAlgorithmException {
        SSLContext sslContext = this.tcpConnectionConfiguration.getSSLContext();
        if (sslContext == null) {
            sslContext = SSLContext.getDefault();
        }
        this.socket = sslContext.getSocketFactory().createSocket(this.socket, this.getXmppSession().getDomain(), this.socket.getPort(), true);
        SSLSocket sslSocket = (SSLSocket)this.socket;
        HostnameVerifier verifier = this.tcpConnectionConfiguration.getHostnameVerifier();
        if (verifier == null) {
            SSLParameters sslParameters = sslSocket.getSSLParameters();
            sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
            sslSocket.setSSLParameters(sslParameters);
        } else {
            sslSocket.startHandshake();
            if (!verifier.verify(this.getXmppSession().getDomain(), sslSocket.getSession())) {
                throw new CertificateException("Server failed to authenticate as " + this.getXmppSession().getDomain());
            }
        }
        this.outputStream = new BufferedOutputStream(this.socket.getOutputStream());
        this.inputStream = new BufferedInputStream(this.socket.getInputStream());
    }

    @Override
    protected void compressStream() {
        if (this.tcpConnectionConfiguration.getCompressionMethod() != null) {
            switch (this.tcpConnectionConfiguration.getCompressionMethod()) {
                case ZLIB: {
                    this.inputStream = new InflaterInputStream(this.inputStream);
                    this.outputStream = new DeflaterOutputStream(this.outputStream, true);
                }
            }
        }
    }

    @Override
    public void send(ClientStreamElement element) {
        this.xmppStreamWriter.send(element);
    }

    @Override
    protected void restartStream() {
        this.xmppStreamWriter.reset(this.outputStream);
        this.xmppStreamWriter.openStream(null);
        this.xmppStreamReader.startReading(this.inputStream);
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.xmppStreamWriter != null) {
            this.xmppStreamWriter.shutdown();
        }
        if (this.xmppStreamReader != null) {
            this.xmppStreamReader.shutdown();
        }
        if (this.socket != null) {
            this.socket.close();
        }
    }

    private boolean connectWithXmppServiceDomain(String xmppServiceDomain) throws IOException {
        String query = "_xmpp-client._tcp." + xmppServiceDomain;
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        env.put("java.naming.provider.url", "dns:");
        try {
            InitialDirContext ctx = new InitialDirContext(env);
            Attributes attributes = ctx.getAttributes(query, new String[]{"SRV"});
            Attribute srvAttribute = attributes.get("SRV");
            ArrayList<DnsResourceRecord> dnsSrvRecords = new ArrayList<DnsResourceRecord>();
            if (srvAttribute != null) {
                NamingEnumeration<?> srvRecords = srvAttribute.getAll();
                while (srvRecords.hasMore()) {
                    String srvRecord = (String)srvRecords.next();
                    if (srvRecord == null) continue;
                    if (srvRecord.equals(".")) {
                        return false;
                    }
                    dnsSrvRecords.add(new DnsResourceRecord(srvRecord));
                }
                Collections.sort(dnsSrvRecords, new Comparator<DnsResourceRecord>(){

                    @Override
                    public int compare(DnsResourceRecord o1, DnsResourceRecord o2) {
                        int result = Integer.compare(o1.priority, o2.priority);
                        if (result == 0) {
                            result = Integer.compare(o2.weight, o1.weight);
                        }
                        return result;
                    }
                });
                for (DnsResourceRecord dnsResourceRecord : dnsSrvRecords) {
                    try {
                        InetAddress inetAddress = InetAddress.getByName(dnsResourceRecord.target);
                        this.connectToSocket(inetAddress, dnsResourceRecord.port, this.getProxy());
                        this.port = dnsResourceRecord.port;
                        this.hostname = inetAddress.getHostName();
                        return true;
                    }
                    catch (IOException iOException) {
                    }
                }
                if (dnsSrvRecords.size() > 0) {
                    throw new IOException("Could not connect to any host.");
                }
            }
        }
        catch (NamingException e) {
            return false;
        }
        return false;
    }

    private static final class DnsResourceRecord {
        final int priority;
        final int weight;
        final int port;
        final String target;

        DnsResourceRecord(String srvRecord) {
            String[] recordParts = srvRecord.split(" ");
            this.priority = Integer.parseInt(recordParts[recordParts.length - 4]);
            this.weight = Integer.parseInt(recordParts[recordParts.length - 3]);
            this.port = Integer.parseInt(recordParts[recordParts.length - 2]);
            String target = recordParts[recordParts.length - 1];
            this.target = target.substring(0, target.length() - 1);
        }
    }
}

