/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.session;

import java.util.Collection;
import java.util.HashSet;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import rocks.xmpp.core.session.ExtensionManager;
import rocks.xmpp.core.session.context.CoreContext;
import rocks.xmpp.core.session.debug.XmppDebugger;

public final class XmppSessionConfiguration {
    private static volatile XmppSessionConfiguration defaultConfiguration;
    private final Collection<Class<? extends ExtensionManager>> initialExtensionManagers = new HashSet<Class<? extends ExtensionManager>>();
    private final JAXBContext jaxbContext;
    private XmppDebugger xmppDebugger;
    private int defaultResponseTimeout;

    private XmppSessionConfiguration(Builder builder) {
        this.xmppDebugger = builder.xmppDebugger;
        this.defaultResponseTimeout = builder.defaultResponseTimeout;
        CoreContext context = builder.context;
        if (context == null) {
            try {
                Class<?> extensionContext = Class.forName(CoreContext.class.getPackage().getName() + ".extensions.ExtensionContext");
                context = (CoreContext)extensionContext.newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                context = new CoreContext(new Class[0]);
            }
        }
        this.initialExtensionManagers.addAll(context.getExtensionManagers());
        Class[] classesToBeBound = new Class[context.getExtensions().size()];
        context.getExtensions().toArray(classesToBeBound);
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])classesToBeBound);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static XmppSessionConfiguration getDefault() {
        if (defaultConfiguration != null) return defaultConfiguration;
        Class<XmppSessionConfiguration> clazz = XmppSessionConfiguration.class;
        synchronized (XmppSessionConfiguration.class) {
            if (defaultConfiguration != null) return defaultConfiguration;
            defaultConfiguration = XmppSessionConfiguration.builder().build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultConfiguration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefault(XmppSessionConfiguration configuration) {
        Class<XmppSessionConfiguration> clazz = XmppSessionConfiguration.class;
        synchronized (XmppSessionConfiguration.class) {
            defaultConfiguration = configuration;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    JAXBContext getJAXBContext() {
        return this.jaxbContext;
    }

    Collection<Class<? extends ExtensionManager>> getInitialExtensionManagers() {
        return this.initialExtensionManagers;
    }

    public final XmppDebugger getDebugger() {
        return this.xmppDebugger;
    }

    public int getDefaultResponseTimeout() {
        return this.defaultResponseTimeout;
    }

    public static final class Builder {
        private XmppDebugger xmppDebugger;
        private CoreContext context;
        private int defaultResponseTimeout;

        private Builder() {
            this.defaultResponseTimeout(5000);
        }

        public Builder debugger(XmppDebugger xmppDebugger) {
            this.xmppDebugger = xmppDebugger;
            return this;
        }

        public Builder context(CoreContext context) {
            this.context = context;
            return this;
        }

        public Builder defaultResponseTimeout(int defaultResponseTimeout) {
            this.defaultResponseTimeout = defaultResponseTimeout;
            return this;
        }

        public XmppSessionConfiguration build() {
            return new XmppSessionConfiguration(this);
        }
    }
}

