/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.session;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.XmppUtils;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.session.debug.XmppDebugger;
import rocks.xmpp.core.stream.model.ClientStreamElement;

final class XmppStreamWriter {
    private final XmppSession xmppSession;
    private final ExecutorService executor;
    private final XMLOutputFactory xmlOutputFactory;
    private final Marshaller marshaller;
    private final XmppDebugger debugger;
    private ScheduledExecutorService keepAliveExecutor;
    private volatile XMLStreamWriter prefixFreeCanonicalizationWriter;
    private XMLStreamWriter xmlStreamWriter;
    private OutputStream lastOutputStream;
    private ByteArrayOutputStream byteArrayOutputStream;
    private volatile boolean streamOpened;

    public XmppStreamWriter(OutputStream outputStream, final XmppSession xmppSession, XMLOutputFactory xmlOutputFactory, int keepAliveInterval) throws XMLStreamException, IOException {
        this.xmppSession = xmppSession;
        this.xmlOutputFactory = xmlOutputFactory;
        this.marshaller = xmppSession.getMarshaller();
        this.debugger = xmppSession.getConfiguration().getDebugger();
        this.executor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, "XMPP Writer Thread");
                thread.setDaemon(true);
                return thread;
            }
        });
        if (keepAliveInterval > 0) {
            this.keepAliveExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread thread = new Thread(r, "XMPP KeepAlive Thread");
                    thread.setDaemon(true);
                    return thread;
                }
            });
            this.keepAliveExecutor.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    if (xmppSession.getStatus() == XmppSession.Status.CONNECTED || xmppSession.getStatus() == XmppSession.Status.AUTHENTICATED) {
                        XmppStreamWriter.this.executor.execute(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    XmppStreamWriter.this.xmlStreamWriter.writeCharacters(" ");
                                    XmppStreamWriter.this.xmlStreamWriter.flush();
                                }
                                catch (XMLStreamException e) {
                                    xmppSession.notifyException(e);
                                }
                            }
                        });
                    }
                }
            }, 0L, keepAliveInterval, TimeUnit.SECONDS);
        }
        this.reset(outputStream);
    }

    void reset(final OutputStream outputStream) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    if (XmppStreamWriter.this.lastOutputStream != outputStream) {
                        OutputStream xmppOutputStream;
                        XmppStreamWriter.this.lastOutputStream = outputStream;
                        if (XmppStreamWriter.this.prefixFreeCanonicalizationWriter != null) {
                            XmppStreamWriter.this.prefixFreeCanonicalizationWriter.close();
                        }
                        if (XmppStreamWriter.this.xmlStreamWriter != null) {
                            XmppStreamWriter.this.xmlStreamWriter.close();
                        }
                        if (XmppStreamWriter.this.prefixFreeCanonicalizationWriter != null) {
                            XmppStreamWriter.this.prefixFreeCanonicalizationWriter.close();
                        }
                        if (XmppStreamWriter.this.debugger != null) {
                            XmppStreamWriter.this.byteArrayOutputStream = new ByteArrayOutputStream();
                            xmppOutputStream = XmppStreamWriter.this.debugger.createOutputStream(XmppUtils.createBranchedOutputStream((OutputStream)outputStream, (OutputStream)XmppStreamWriter.this.byteArrayOutputStream));
                        } else {
                            xmppOutputStream = outputStream;
                        }
                        XmppStreamWriter.this.xmlStreamWriter = XmppStreamWriter.this.xmlOutputFactory.createXMLStreamWriter(xmppOutputStream, "UTF-8");
                        XmppStreamWriter.this.prefixFreeCanonicalizationWriter = XmppUtils.createXmppStreamWriter((XMLStreamWriter)XmppStreamWriter.this.xmlStreamWriter, (boolean)true);
                        XmppStreamWriter.this.streamOpened = false;
                    }
                }
                catch (Exception e) {
                    XmppStreamWriter.this.xmppSession.notifyException(e);
                }
            }
        });
    }

    void send(final ClientStreamElement clientStreamElement) {
        if (!this.executor.isShutdown() && clientStreamElement != null) {
            this.executor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        XMLOutputFactory xMLOutputFactory = XmppStreamWriter.this.xmlOutputFactory;
                        synchronized (xMLOutputFactory) {
                            XmppStreamWriter.this.marshaller.marshal((Object)clientStreamElement, XmppStreamWriter.this.prefixFreeCanonicalizationWriter);
                        }
                        XmppStreamWriter.this.prefixFreeCanonicalizationWriter.flush();
                        if (XmppStreamWriter.this.debugger != null) {
                            XmppStreamWriter.this.debugger.writeStanza(new String(XmppStreamWriter.this.byteArrayOutputStream.toByteArray()).trim(), clientStreamElement);
                            XmppStreamWriter.this.byteArrayOutputStream.reset();
                        }
                    }
                    catch (JAXBException | XMLStreamException e) {
                        XmppStreamWriter.this.xmppSession.notifyException((Exception)e);
                    }
                }
            });
        }
    }

    void openStream(final Jid from) {
        if (!this.executor.isShutdown()) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        XmppStreamWriter.this.xmlStreamWriter.writeStartDocument("UTF-8", "1.0");
                        XmppStreamWriter.this.xmlStreamWriter.writeStartElement("stream", "stream", "http://etherx.jabber.org/streams");
                        XmppStreamWriter.this.xmlStreamWriter.writeAttribute("xml", "http://www.w3.org/XML/1998/namespace", "lang", Locale.getDefault().getLanguage());
                        if (XmppStreamWriter.this.xmppSession.getDomain() != null && !XmppStreamWriter.this.xmppSession.getDomain().isEmpty()) {
                            XmppStreamWriter.this.xmlStreamWriter.writeAttribute("to", XmppStreamWriter.this.xmppSession.getDomain());
                        }
                        if (from != null) {
                            XmppStreamWriter.this.xmlStreamWriter.writeAttribute("from", from.toString());
                        }
                        XmppStreamWriter.this.xmlStreamWriter.writeAttribute("version", "1.0");
                        XmppStreamWriter.this.xmlStreamWriter.writeNamespace("", "jabber:client");
                        XmppStreamWriter.this.xmlStreamWriter.writeNamespace("stream", "http://etherx.jabber.org/streams");
                        XmppStreamWriter.this.xmlStreamWriter.writeCharacters("");
                        XmppStreamWriter.this.xmlStreamWriter.flush();
                        if (XmppStreamWriter.this.debugger != null) {
                            XmppStreamWriter.this.debugger.writeStanza(new String(XmppStreamWriter.this.byteArrayOutputStream.toByteArray()).trim(), null);
                            XmppStreamWriter.this.byteArrayOutputStream.reset();
                        }
                        XmppStreamWriter.this.streamOpened = true;
                    }
                    catch (XMLStreamException e) {
                        XmppStreamWriter.this.xmppSession.notifyException(e);
                    }
                }
            });
        }
    }

    private void closeStream() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                if (XmppStreamWriter.this.streamOpened) {
                    try {
                        XmppStreamWriter.this.xmlStreamWriter.writeEndElement();
                        XmppStreamWriter.this.xmlStreamWriter.flush();
                        if (XmppStreamWriter.this.debugger != null) {
                            XmppStreamWriter.this.debugger.writeStanza(new String(XmppStreamWriter.this.byteArrayOutputStream.toByteArray()).trim(), null);
                            XmppStreamWriter.this.byteArrayOutputStream.reset();
                        }
                        XmppStreamWriter.this.xmlStreamWriter.close();
                        XmppStreamWriter.this.streamOpened = false;
                    }
                    catch (XMLStreamException e) {
                        XmppStreamWriter.this.xmppSession.notifyException(e);
                    }
                }
            }
        });
    }

    synchronized void shutdown() {
        if (!this.executor.isShutdown()) {
            this.closeStream();
            if (this.keepAliveExecutor != null) {
                this.keepAliveExecutor.shutdown();
            }
            this.executor.shutdown();
            try {
                if (this.keepAliveExecutor != null) {
                    this.keepAliveExecutor.awaitTermination(100L, TimeUnit.MILLISECONDS);
                }
                this.executor.awaitTermination(250L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

