/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.stream;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import rocks.xmpp.core.stream.FeatureEvent;
import rocks.xmpp.core.stream.FeatureListener;
import rocks.xmpp.core.stream.model.StreamFeature;

public abstract class FeatureNegotiator {
    private final Set<FeatureListener> featureListeners = new CopyOnWriteArraySet<FeatureListener>();
    private final Class<? extends StreamFeature> featureClass;

    public FeatureNegotiator(Class<? extends StreamFeature> featureClass) {
        this.featureClass = featureClass;
    }

    public final void addFeatureListener(FeatureListener featureListener) {
        this.featureListeners.add(featureListener);
    }

    public final void removeFeatureListener(FeatureListener featureListener) {
        this.featureListeners.remove(featureListener);
    }

    protected void notifyFeatureNegotiated(Status status, Object element) throws Exception {
        if (status == null) {
            throw new IllegalArgumentException("status must not be null");
        }
        for (FeatureListener featureListener : this.featureListeners) {
            featureListener.negotiationStatusChanged(new FeatureEvent(this, status, element));
        }
    }

    public abstract Status processNegotiation(Object var1) throws Exception;

    public boolean needsRestart() {
        return false;
    }

    public abstract boolean canProcess(Object var1);

    public final Class<? extends StreamFeature> getFeatureClass() {
        return this.featureClass;
    }

    public static enum Status {
        SUCCESS,
        FAILURE,
        INCOMPLETE,
        IGNORE;

    }
}

