/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.tls;

import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stream.FeatureListener;
import rocks.xmpp.core.stream.FeatureNegotiator;
import rocks.xmpp.core.stream.model.ClientStreamElement;
import rocks.xmpp.core.tls.model.Failure;
import rocks.xmpp.core.tls.model.Proceed;
import rocks.xmpp.core.tls.model.StartTls;

public final class SecurityManager
extends FeatureNegotiator {
    private final XmppSession xmppSession;
    private final boolean isSecure;

    public SecurityManager(XmppSession xmppSession, FeatureListener featureListener, boolean isSecure) {
        super(StartTls.class);
        this.isSecure = isSecure;
        this.addFeatureListener(featureListener);
        if (xmppSession == null) {
            throw new IllegalArgumentException("connection must not be null.");
        }
        this.xmppSession = xmppSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FeatureNegotiator.Status processNegotiation(Object element) throws Exception {
        FeatureNegotiator.Status status = FeatureNegotiator.Status.INCOMPLETE;
        try {
            if (element instanceof StartTls) {
                StartTls startTls = (StartTls)element;
                if (startTls.isMandatory() && !this.isSecure) {
                    throw new Exception("The server requires TLS, but you disabled it.");
                }
                if (this.isSecure) {
                    this.xmppSession.send((ClientStreamElement)new StartTls());
                } else {
                    status = FeatureNegotiator.Status.IGNORE;
                }
            } else if (element instanceof Proceed) {
                status = FeatureNegotiator.Status.SUCCESS;
            } else if (element instanceof Failure) {
                status = FeatureNegotiator.Status.FAILURE;
                throw new Exception("Failure during TLS negotiation.");
            }
        }
        finally {
            this.notifyFeatureNegotiated(status, element);
        }
        return status;
    }

    @Override
    public boolean needsRestart() {
        return true;
    }

    @Override
    public boolean canProcess(Object element) {
        return element instanceof Proceed || element instanceof Failure;
    }
}

