/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.disco;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.ExtensionManager;
import rocks.xmpp.core.session.SessionStatusEvent;
import rocks.xmpp.core.session.SessionStatusListener;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.IQEvent;
import rocks.xmpp.core.stanza.IQListener;
import rocks.xmpp.core.stanza.model.AbstractIQ;
import rocks.xmpp.core.stanza.model.StanzaError;
import rocks.xmpp.core.stanza.model.client.IQ;
import rocks.xmpp.core.stanza.model.errors.Condition;
import rocks.xmpp.core.stanza.model.errors.ItemNotFound;
import rocks.xmpp.core.stream.model.ClientStreamElement;
import rocks.xmpp.extensions.data.model.DataForm;
import rocks.xmpp.extensions.disco.model.info.Feature;
import rocks.xmpp.extensions.disco.model.info.Identity;
import rocks.xmpp.extensions.disco.model.info.InfoDiscovery;
import rocks.xmpp.extensions.disco.model.info.InfoNode;
import rocks.xmpp.extensions.disco.model.items.Item;
import rocks.xmpp.extensions.disco.model.items.ItemDiscovery;
import rocks.xmpp.extensions.disco.model.items.ItemNode;

public final class ServiceDiscoveryManager
extends ExtensionManager
implements InfoNode,
ItemNode {
    private static Identity defaultIdentity = new Identity("client", "pc");
    private final Set<Identity> identities = new CopyOnWriteArraySet<Identity>();
    private final Set<Feature> features = new CopyOnWriteArraySet<Feature>();
    private final List<DataForm> extensions = new CopyOnWriteArrayList<DataForm>();
    private final List<Item> items = new CopyOnWriteArrayList<Item>();
    private final Map<String, InfoNode> infoNodeMap = new ConcurrentHashMap<String, InfoNode>();
    private final Map<String, ItemNode> itemNodeMap = new ConcurrentHashMap<String, ItemNode>();
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    private ServiceDiscoveryManager(final XmppSession xmppSession) {
        super(xmppSession, "http://jabber.org/protocol/disco#info", "http://jabber.org/protocol/disco#items");
        xmppSession.addSessionStatusListener(new SessionStatusListener(){

            @Override
            public void sessionStatusChanged(SessionStatusEvent e) {
                if (e.getStatus() == XmppSession.Status.CLOSED) {
                    for (PropertyChangeListener propertyChangeListener : ServiceDiscoveryManager.this.pcs.getPropertyChangeListeners()) {
                        ServiceDiscoveryManager.this.pcs.removePropertyChangeListener(propertyChangeListener);
                    }
                }
            }
        });
        xmppSession.addIQListener(new IQListener(){

            @Override
            public void handle(IQEvent e) {
                IQ iq = e.getIQ();
                if (e.isIncoming() && ServiceDiscoveryManager.this.isEnabled() && !e.isConsumed() && iq.getType() == AbstractIQ.Type.GET) {
                    InfoDiscovery infoDiscovery = (InfoDiscovery)iq.getExtension(InfoDiscovery.class);
                    if (infoDiscovery != null) {
                        if (infoDiscovery.getNode() == null) {
                            IQ result = iq.createResult();
                            result.setExtension((Object)new InfoDiscovery(ServiceDiscoveryManager.this.getIdentities(), ServiceDiscoveryManager.this.getFeatures(), ServiceDiscoveryManager.this.getExtensions()));
                            xmppSession.send((ClientStreamElement)result);
                            e.consume();
                        } else {
                            InfoNode infoNode = (InfoNode)ServiceDiscoveryManager.this.infoNodeMap.get(infoDiscovery.getNode());
                            if (infoNode != null) {
                                IQ result = iq.createResult();
                                result.setExtension((Object)new InfoDiscovery(infoNode.getNode(), infoNode.getIdentities(), infoNode.getFeatures(), infoNode.getExtensions()));
                                xmppSession.send((ClientStreamElement)result);
                                e.consume();
                            } else {
                                xmppSession.send((ClientStreamElement)iq.createError(new StanzaError((Condition)new ItemNotFound())));
                                e.consume();
                            }
                        }
                    } else {
                        ItemDiscovery itemDiscovery = (ItemDiscovery)iq.getExtension(ItemDiscovery.class);
                        if (itemDiscovery != null) {
                            if (itemDiscovery.getNode() == null) {
                                IQ result = iq.createResult();
                                result.setExtension((Object)new ItemDiscovery(ServiceDiscoveryManager.this.items));
                                xmppSession.send((ClientStreamElement)result);
                                e.consume();
                            } else {
                                ItemNode itemNode = (ItemNode)ServiceDiscoveryManager.this.itemNodeMap.get(itemDiscovery.getNode());
                                if (itemNode != null) {
                                    IQ result = iq.createResult();
                                    result.setExtension((Object)new ItemDiscovery(itemNode.getNode(), ServiceDiscoveryManager.this.items));
                                    xmppSession.send((ClientStreamElement)result);
                                    e.consume();
                                } else {
                                    xmppSession.send((ClientStreamElement)iq.createError(new StanzaError((Condition)new ItemNotFound())));
                                    e.consume();
                                }
                            }
                        }
                    }
                }
            }
        });
        this.setEnabled(true);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public String getNode() {
        return null;
    }

    public List<Item> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    public synchronized Set<Identity> getIdentities() {
        HashSet<Identity> ids;
        if (!this.identities.isEmpty()) {
            ids = new HashSet<Identity>(this.identities);
        } else {
            ids = new HashSet<Identity>();
            ids.add(defaultIdentity);
        }
        return Collections.unmodifiableSet(ids);
    }

    public Set<Feature> getFeatures() {
        return Collections.unmodifiableSet(this.features);
    }

    public List<DataForm> getExtensions() {
        return Collections.unmodifiableList(this.extensions);
    }

    public synchronized void addItem(Item item) {
        List<Item> oldList = Collections.unmodifiableList(new ArrayList<Item>(this.items));
        this.items.add(item);
        this.pcs.firePropertyChange("items", oldList, this.getItems());
    }

    public synchronized void removeItem(Item item) {
        List<Item> oldList = Collections.unmodifiableList(new ArrayList<Item>(this.items));
        this.items.remove(item);
        this.pcs.firePropertyChange("items", oldList, this.getItems());
    }

    public synchronized void addIdentity(Identity identity) {
        Set<Identity> oldList = Collections.unmodifiableSet(new HashSet<Identity>(this.identities));
        this.identities.add(identity);
        this.pcs.firePropertyChange("identities", oldList, this.getIdentities());
    }

    public synchronized void removeIdentity(Identity identity) {
        Set<Identity> oldList = Collections.unmodifiableSet(new HashSet<Identity>(this.identities));
        this.identities.remove(identity);
        this.pcs.firePropertyChange("identities", oldList, this.getIdentities());
    }

    public synchronized void addFeature(Feature feature) {
        Set<Feature> oldList = Collections.unmodifiableSet(new HashSet<Feature>(this.features));
        this.features.add(feature);
        this.pcs.firePropertyChange("features", oldList, this.getFeatures());
    }

    public synchronized void removeFeature(Feature feature) {
        Set<Feature> oldList = Collections.unmodifiableSet(new HashSet<Feature>(this.features));
        this.features.remove(feature);
        this.pcs.firePropertyChange("features", oldList, this.getFeatures());
    }

    public synchronized void addExtension(DataForm extension) {
        List<DataForm> oldList = Collections.unmodifiableList(new ArrayList<DataForm>(this.extensions));
        this.extensions.add(extension);
        this.pcs.firePropertyChange("extensions", oldList, this.getExtensions());
    }

    public synchronized void removeExtension(DataForm extension) {
        List<DataForm> oldList = Collections.unmodifiableList(new ArrayList<DataForm>(this.extensions));
        this.extensions.remove(extension);
        this.pcs.firePropertyChange("extensions", oldList, this.getExtensions());
    }

    public InfoNode discoverInformation(Jid jid) throws XmppException {
        return this.discoverInformation(jid, null);
    }

    public InfoNode discoverInformation(Jid jid, String node) throws XmppException {
        IQ iq = new IQ(jid, AbstractIQ.Type.GET, (Object)new InfoDiscovery(node));
        IQ result = this.xmppSession.query(iq);
        return (InfoNode)result.getExtension(InfoDiscovery.class);
    }

    public ItemNode discoverItems(Jid jid) throws XmppException {
        return this.discoverItems(jid, null);
    }

    public ItemNode discoverItems(Jid jid, String node) throws XmppException {
        IQ iq = new IQ(AbstractIQ.Type.GET, (Object)new ItemDiscovery(node));
        iq.setTo(jid);
        IQ result = this.xmppSession.query(iq);
        return (ItemNode)result.getExtension(ItemDiscovery.class);
    }

    public void addInfoNode(InfoNode infoNode) {
        this.infoNodeMap.put(infoNode.getNode(), infoNode);
    }

    public void removeInfoNode(String node) {
        this.infoNodeMap.remove(node);
    }

    public void addItemNode(ItemNode itemNode) {
        this.itemNodeMap.put(itemNode.getNode(), itemNode);
    }

    public void removeItemNode(String node) {
        this.itemNodeMap.remove(node);
    }
}

