/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.session;

import java.io.IOException;
import java.net.Proxy;
import javax.xml.stream.XMLOutputFactory;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.MockServer;
import rocks.xmpp.core.SameThreadExecutorService;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.Connection;
import rocks.xmpp.core.session.ConnectionConfiguration;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.session.XmppSessionConfiguration;
import rocks.xmpp.core.stanza.IQEvent;
import rocks.xmpp.core.stanza.IQListener;
import rocks.xmpp.core.stanza.model.AbstractIQ;
import rocks.xmpp.core.stanza.model.Stanza;
import rocks.xmpp.core.stanza.model.StanzaException;
import rocks.xmpp.core.stanza.model.client.IQ;
import rocks.xmpp.core.stream.model.ClientStreamElement;

public class TestXmppSession
extends XmppSession {
    private MockServer mockServer;

    public TestXmppSession() {
        this(Jid.valueOf((String)"test@domain/resource"), new MockServer());
    }

    public TestXmppSession(Jid jid, MockServer mockServer) {
        this(jid, mockServer, XmppSessionConfiguration.getDefault());
    }

    public TestXmppSession(Jid jid, MockServer mockServer, XmppSessionConfiguration configuration) {
        super(null, configuration, new ConnectionConfiguration[0]);
        this.connectedResource = jid;
        XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newFactory();
        this.activeConnection = new Connection("hostname", 5222, Proxy.NO_PROXY){

            protected void restartStream() {
            }

            public void send(ClientStreamElement clientStreamElement) {
            }

            public void connect() throws IOException {
            }

            public void close() throws IOException {
            }
        };
        this.stanzaListenerExecutor = new SameThreadExecutorService();
        this.mockServer = mockServer;
        mockServer.registerConnection(this);
        this.updateStatus(XmppSession.Status.CONNECTED);
    }

    public void send(ClientStreamElement element) {
        super.send(element);
        if (this.mockServer != null && element instanceof Stanza) {
            ((Stanza)element).setFrom(this.connectedResource);
            this.mockServer.receive((Stanza)element);
        }
    }

    public IQ query(final IQ iq) throws XmppException {
        final IQ[] result = new IQ[1];
        IQListener iqListener = new IQListener(){

            public void handle(IQEvent e) {
                if (e.isIncoming() && e.getIQ().getId() != null && e.getIQ().getId().equals(iq.getId())) {
                    result[0] = e.getIQ();
                }
            }
        };
        this.addIQListener(iqListener);
        this.send((ClientStreamElement)iq);
        this.removeIQListener(iqListener);
        IQ response = result[0];
        if (response.getType() == AbstractIQ.Type.ERROR) {
            throw new StanzaException((Stanza)response);
        }
        return response;
    }

    public void close() throws IOException {
        super.close();
        this.updateStatus(XmppSession.Status.CLOSED, null);
    }
}

