/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.stanza.client;

import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.testng.Assert;
import org.testng.annotations.Test;
import rocks.xmpp.core.UnmarshalTest;
import rocks.xmpp.core.stanza.model.AbstractIQ;
import rocks.xmpp.core.stanza.model.client.IQ;

public class IQTest
extends UnmarshalTest {
    protected IQTest() throws JAXBException, XMLStreamException {
        super(IQ.class);
    }

    @Test
    public void unmarshalIQ() throws JAXBException, XMLStreamException {
        String xml = "<iq from='juliet@example.com/balcony'\n       id='b4vs9km4'\n       to='romeo@example.net' type='error'/>";
        IQ iq = this.unmarshal(xml, IQ.class);
        Assert.assertEquals((Object)iq.getType(), (Object)AbstractIQ.Type.ERROR);
        Assert.assertEquals((String)iq.getId(), (String)"b4vs9km4");
        Assert.assertEquals((String)iq.getTo().toString(), (String)"romeo@example.net");
        Assert.assertEquals((String)iq.getFrom().toString(), (String)"juliet@example.com/balcony");
    }

    @Test
    public void unmarshalResultIQ() throws XMLStreamException, JAXBException {
        String xml = "<iq type=\"result\"/>";
        IQ iq = this.unmarshal(xml, IQ.class);
        Assert.assertEquals((Object)iq.getType(), (Object)AbstractIQ.Type.RESULT);
    }

    @Test
    public void unmarshalGetIQ() throws XMLStreamException, JAXBException {
        String xml = "<iq type=\"get\"/>";
        IQ iq = this.unmarshal(xml, IQ.class);
        Assert.assertEquals((Object)iq.getType(), (Object)AbstractIQ.Type.GET);
    }

    @Test
    public void unmarshalSetIQ() throws XMLStreamException, JAXBException {
        String xml = "<iq type=\"set\"/>";
        IQ iq = this.unmarshal(xml, IQ.class);
        Assert.assertEquals((Object)iq.getType(), (Object)AbstractIQ.Type.SET);
    }

    @Test
    public void unmarshalErrorIQ() throws XMLStreamException, JAXBException {
        String xml = "<iq type=\"error\"/>";
        IQ iq = this.unmarshal(xml, IQ.class);
        Assert.assertEquals((Object)iq.getType(), (Object)AbstractIQ.Type.ERROR);
    }
}

