/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.stanza.client;

import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.testng.Assert;
import org.testng.annotations.Test;
import rocks.xmpp.core.UnmarshalTest;
import rocks.xmpp.core.stanza.model.AbstractPresence;
import rocks.xmpp.core.stanza.model.client.Presence;
import rocks.xmpp.core.stanza.model.errors.RemoteServerNotFound;

public class PresenceTest
extends UnmarshalTest {
    protected PresenceTest() throws JAXBException, XMLStreamException {
        super(Presence.class, RemoteServerNotFound.class);
    }

    @Test
    public void unmarshalPresence() throws XMLStreamException, JAXBException {
        String xml = "<presence from='romeo@example.net'              id='xk3h1v69'\n              to='juliet@example.com'\n              type='subscribe'/>";
        Presence presence = this.unmarshal(xml, Presence.class);
        Assert.assertEquals((String)presence.getTo().toString(), (String)"juliet@example.com");
        Assert.assertEquals((String)presence.getFrom().toString(), (String)"romeo@example.net");
        Assert.assertEquals((Object)presence.getType(), (Object)AbstractPresence.Type.SUBSCRIBE);
        Assert.assertEquals((String)presence.getId(), (String)"xk3h1v69");
    }

    @Test
    public void unmarshalPresenceWithError() throws XMLStreamException, JAXBException {
        String xml = "<presence from='juliet@example.com'\n              id='xk3h1v69'\n              to='romeo@example.net'\n              type='error'>\n      <error type='modify'>\n        <remote-server-not-found\n            xmlns='urn:ietf:params:xml:ns:xmpp-stanzas'/>\n      </error>\n    </presence>";
        Presence presence = this.unmarshal(xml, Presence.class);
        Assert.assertEquals((String)presence.getTo().toString(), (String)"romeo@example.net");
        Assert.assertEquals((String)presence.getFrom().toString(), (String)"juliet@example.com");
        Assert.assertEquals((Object)presence.getType(), (Object)AbstractPresence.Type.ERROR);
        Assert.assertNotNull((Object)presence.getError());
        Assert.assertNotNull((Object)(presence.getError().getCondition() instanceof RemoteServerNotFound));
    }

    @Test
    public void unmarshalPresenceTypeSubscribed() throws XMLStreamException, JAXBException {
        String xml = "<presence from='juliet@example.com'\n              id='xk3h1v69'\n              to='romeo@example.net'\n              type='subscribed'/>";
        Presence presence = this.unmarshal(xml, Presence.class);
        Assert.assertEquals((String)presence.getFrom().toString(), (String)"juliet@example.com");
        Assert.assertEquals((String)presence.getTo().toString(), (String)"romeo@example.net");
        Assert.assertEquals((Object)presence.getType(), (Object)AbstractPresence.Type.SUBSCRIBED);
        Assert.assertEquals((String)presence.getId(), (String)"xk3h1v69");
    }

    @Test
    public void unmarshalPresenceTypeUnsubscribed() throws XMLStreamException, JAXBException {
        String xml = "<presence id='tb2m1b59'\n              to='romeo@example.net'\n              type='unsubscribed'/>";
        Presence presence = this.unmarshal(xml, Presence.class);
        Assert.assertEquals((String)presence.getTo().toString(), (String)"romeo@example.net");
        Assert.assertEquals((Object)presence.getType(), (Object)AbstractPresence.Type.UNSUBSCRIBED);
        Assert.assertEquals((String)presence.getId(), (String)"tb2m1b59");
    }

    @Test
    public void unmarshalPresenceTypeUnsubscribe() throws XMLStreamException, JAXBException {
        String xml = "<presence id='tb2m1b59'\n              to='romeo@example.net'\n              type='unsubscribe'/>";
        Presence presence = this.unmarshal(xml, Presence.class);
        Assert.assertEquals((String)presence.getTo().toString(), (String)"romeo@example.net");
        Assert.assertEquals((Object)presence.getType(), (Object)AbstractPresence.Type.UNSUBSCRIBE);
        Assert.assertEquals((String)presence.getId(), (String)"tb2m1b59");
    }

    @Test
    public void unmarshalPresenceTypeProbe() throws XMLStreamException, JAXBException {
        String xml = "<presence id='tb2m1b59'\n              to='romeo@example.net'\n              type='probe'/>";
        Presence presence = this.unmarshal(xml, Presence.class);
        Assert.assertEquals((String)presence.getTo().toString(), (String)"romeo@example.net");
        Assert.assertEquals((Object)presence.getType(), (Object)AbstractPresence.Type.PROBE);
        Assert.assertEquals((String)presence.getId(), (String)"tb2m1b59");
    }

    @Test
    public void unmarshalPresenceTypeUnavailable() throws XMLStreamException, JAXBException {
        String xml = "<presence id='tb2m1b59'\n              to='romeo@example.net'\n              type='unavailable'/>";
        Presence presence = this.unmarshal(xml, Presence.class);
        Assert.assertEquals((String)presence.getTo().toString(), (String)"romeo@example.net");
        Assert.assertEquals((Object)presence.getType(), (Object)AbstractPresence.Type.UNAVAILABLE);
        Assert.assertEquals((String)presence.getId(), (String)"tb2m1b59");
    }

    @Test
    public void unmarshalPresenceStatus() throws XMLStreamException, JAXBException {
        String xml = "<presence from='romeo@example.net/orchard'\n          xml:lang='en'>\n  <show>dnd</show>\n  <status>Wooing Juliet</status>\n</presence>";
        Presence presence = this.unmarshal(xml, Presence.class);
        Assert.assertEquals((String)presence.getFrom().toString(), (String)"romeo@example.net/orchard");
        Assert.assertEquals((Object)presence.getShow(), (Object)AbstractPresence.Show.DND);
        Assert.assertEquals((String)presence.getLanguage(), (String)"en");
        Assert.assertEquals((String)presence.getStatus(), (String)"Wooing Juliet");
    }

    @Test
    public void unmarshalMultiplePresenceStatus() throws XMLStreamException, JAXBException {
        String xml = "<presence from='romeo@example.net/orchard'\n          id='jx62vs97'\n          xml:lang='en'>\n  <show>dnd</show>\n  <status>Wooing Juliet</status>\n  <status xml:lang='de'>Julia</status>\n</presence>";
        Presence presence = this.unmarshal(xml, Presence.class);
        Assert.assertEquals((String)presence.getFrom().toString(), (String)"romeo@example.net/orchard");
        Assert.assertEquals((Object)presence.getShow(), (Object)AbstractPresence.Show.DND);
        Assert.assertEquals((String)presence.getLanguage(), (String)"en");
        Assert.assertEquals((String)presence.getStatus(), (String)"Wooing Juliet");
    }

    @Test
    public void unmarshalPresenceShowAway() throws XMLStreamException, JAXBException {
        String xml = "<presence from='romeo@example.net/orchard'\n          xml:lang='en'>\n  <show>away</show>\n</presence>";
        Presence presence = this.unmarshal(xml, Presence.class);
        Assert.assertEquals((Object)presence.getShow(), (Object)AbstractPresence.Show.AWAY);
    }

    @Test
    public void unmarshalPresenceShowXA() throws XMLStreamException, JAXBException {
        String xml = "<presence from='romeo@example.net/orchard'\n          xml:lang='en'>\n  <show>xa</show>\n</presence>";
        Presence presence = this.unmarshal(xml, Presence.class);
        Assert.assertEquals((Object)presence.getShow(), (Object)AbstractPresence.Show.XA);
    }

    @Test
    public void unmarshalPresenceShowChat() throws XMLStreamException, JAXBException {
        String xml = "<presence from='romeo@example.net/orchard'\n          xml:lang='en'>\n  <show>chat</show>\n</presence>";
        Presence presence = this.unmarshal(xml, Presence.class);
        Assert.assertEquals((Object)presence.getShow(), (Object)AbstractPresence.Show.CHAT);
    }

    @Test
    public void unmarshalPresenceShowDnd() throws XMLStreamException, JAXBException {
        String xml = "<presence from='romeo@example.net/orchard'\n          xml:lang='en'>\n  <show>dnd</show>\n</presence>";
        Presence presence = this.unmarshal(xml, Presence.class);
        Assert.assertEquals((Object)presence.getShow(), (Object)AbstractPresence.Show.DND);
    }

    @Test
    public void unmarshalPriority() throws XMLStreamException, JAXBException {
        String xml = "<presence xml:lang='en'>\n  <show>dnd</show>\n  <status>Wooing Juliet</status>\n  <status xml:lang='cs'>Dvo&#x0159;&#x00ED;m se Julii</status>\n  <priority>1</priority>\n</presence>";
        Presence presence = this.unmarshal(xml, Presence.class);
        Assert.assertEquals((int)presence.getPriority(), (int)1);
    }
}

