/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.disco;

import org.testng.Assert;
import org.testng.annotations.Test;
import rocks.xmpp.core.BaseTest;
import rocks.xmpp.core.MockServer;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.TestXmppSession;
import rocks.xmpp.extensions.disco.ServiceDiscoveryManager;
import rocks.xmpp.extensions.disco.model.info.Feature;
import rocks.xmpp.extensions.disco.model.info.Identity;
import rocks.xmpp.extensions.disco.model.info.InfoNode;

public class ServiceDiscoveryManagerTest
extends BaseTest {
    @Test
    public void testFeatureEquals() {
        ServiceDiscoveryManager serviceDiscoveryManager = (ServiceDiscoveryManager)this.xmppSession.getExtensionManager(ServiceDiscoveryManager.class);
        serviceDiscoveryManager.addFeature(new Feature("http://jabber.org/protocol/muc"));
        Assert.assertTrue((boolean)serviceDiscoveryManager.getFeatures().contains(new Feature("http://jabber.org/protocol/muc")));
    }

    @Test
    public void testItemsEquals() {
        ServiceDiscoveryManager serviceDiscoveryManager = (ServiceDiscoveryManager)this.xmppSession.getExtensionManager(ServiceDiscoveryManager.class);
        serviceDiscoveryManager.addIdentity(new Identity("conference", "text", "name1", "en"));
        Assert.assertTrue((boolean)serviceDiscoveryManager.getIdentities().contains(new Identity("conference", "text", "name2", "en")));
    }

    @Test
    public void testInfoDiscovery() throws XmppException {
        MockServer mockServer = new MockServer();
        TestXmppSession connection1 = new TestXmppSession(ROMEO, mockServer);
        new TestXmppSession(JULIET, mockServer);
        ServiceDiscoveryManager serviceDiscoveryManager = (ServiceDiscoveryManager)connection1.getExtensionManager(ServiceDiscoveryManager.class);
        InfoNode result = serviceDiscoveryManager.discoverInformation(JULIET);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((result.getFeatures().size() > 1 ? 1 : 0) != 0);
        Assert.assertTrue((result.getIdentities().size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testServiceDiscoveryEntry() {
        TestXmppSession connection1 = new TestXmppSession();
        ServiceDiscoveryManager serviceDiscoveryManager = (ServiceDiscoveryManager)connection1.getExtensionManager(ServiceDiscoveryManager.class);
        Assert.assertTrue((boolean)serviceDiscoveryManager.isEnabled());
        Feature featureInfo = new Feature("http://jabber.org/protocol/disco#info");
        Feature featureItems = new Feature("http://jabber.org/protocol/disco#items");
        Assert.assertTrue((boolean)serviceDiscoveryManager.getFeatures().contains(featureInfo));
        Assert.assertTrue((boolean)serviceDiscoveryManager.getFeatures().contains(featureItems));
        serviceDiscoveryManager.setEnabled(false);
        Assert.assertFalse((boolean)serviceDiscoveryManager.isEnabled());
        Assert.assertFalse((boolean)serviceDiscoveryManager.getFeatures().contains(featureInfo));
        Assert.assertFalse((boolean)serviceDiscoveryManager.getFeatures().contains(featureItems));
    }
}

