/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.sasl;

import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import rocks.xmpp.core.sasl.anonymous.AnonymousSaslClient;
import rocks.xmpp.core.sasl.scram.ScramClient;

public final class XmppSaslClientFactory
implements SaslClientFactory {
    @Override
    public SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        for (String mechanism : mechanisms) {
            if ("ANONYMOUS".equals(mechanism)) {
                return new AnonymousSaslClient();
            }
            if (!"SCRAM-SHA-1".equals(mechanism)) continue;
            return new ScramClient("SHA-1", authorizationId, cbh);
        }
        return null;
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        return new String[]{"ANONYMOUS", "SCRAM-SHA-1"};
    }
}

