/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.session;

import javax.net.SocketFactory;
import rocks.xmpp.core.session.Connection;
import rocks.xmpp.core.session.ConnectionConfiguration;
import rocks.xmpp.core.session.TcpConnection;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.session.XmppSessionConfiguration;
import rocks.xmpp.extensions.compress.model.CompressionMethod;

public final class TcpConnectionConfiguration
extends ConnectionConfiguration {
    private static volatile TcpConnectionConfiguration defaultConfiguration;
    private final int keepAliveInterval;
    private final SocketFactory socketFactory;
    private final CompressionMethod compressionMethod;

    private TcpConnectionConfiguration(Builder builder) {
        super(builder);
        this.keepAliveInterval = builder.keepAliveInterval;
        this.socketFactory = builder.socketFactory;
        this.compressionMethod = builder.compressionMethod;
    }

    public static Builder builder() {
        return new Builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TcpConnectionConfiguration getDefault() {
        if (defaultConfiguration != null) return defaultConfiguration;
        Class<XmppSessionConfiguration> clazz = XmppSessionConfiguration.class;
        synchronized (XmppSessionConfiguration.class) {
            if (defaultConfiguration != null) return defaultConfiguration;
            defaultConfiguration = TcpConnectionConfiguration.builder().build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultConfiguration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefault(TcpConnectionConfiguration configuration) {
        Class<TcpConnectionConfiguration> clazz = TcpConnectionConfiguration.class;
        synchronized (TcpConnectionConfiguration.class) {
            defaultConfiguration = configuration;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public Connection createConnection(XmppSession xmppSession) {
        return new TcpConnection(xmppSession, this);
    }

    public int getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public CompressionMethod getCompressionMethod() {
        return this.compressionMethod;
    }

    public static final class Builder
    extends ConnectionConfiguration.Builder<Builder> {
        private int keepAliveInterval;
        private SocketFactory socketFactory;
        private CompressionMethod compressionMethod;

        private Builder() {
            this.secure(true);
            this.port(5222);
            this.keepAliveInterval(30);
        }

        public Builder keepAliveInterval(int keepAliveInterval) {
            this.keepAliveInterval = keepAliveInterval;
            return this;
        }

        public Builder compressionMethod(CompressionMethod compressionMethod) {
            this.compressionMethod = compressionMethod;
            return this;
        }

        public Builder socketFactory(SocketFactory socketFactory) {
            this.socketFactory = socketFactory;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TcpConnectionConfiguration build() {
            return new TcpConnectionConfiguration(this);
        }
    }
}

