/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.session;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.login.LoginException;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.bind.model.Bind;
import rocks.xmpp.core.roster.RosterManager;
import rocks.xmpp.core.sasl.AuthenticationManager;
import rocks.xmpp.core.sasl.model.Mechanisms;
import rocks.xmpp.core.session.ChatManager;
import rocks.xmpp.core.session.Connection;
import rocks.xmpp.core.session.ConnectionConfiguration;
import rocks.xmpp.core.session.ExtensionManager;
import rocks.xmpp.core.session.NoResponseException;
import rocks.xmpp.core.session.ReconnectionManager;
import rocks.xmpp.core.session.SessionStatusEvent;
import rocks.xmpp.core.session.SessionStatusListener;
import rocks.xmpp.core.session.TcpConnectionConfiguration;
import rocks.xmpp.core.session.XmppSessionConfiguration;
import rocks.xmpp.core.session.debug.XmppDebugger;
import rocks.xmpp.core.session.model.Session;
import rocks.xmpp.core.stanza.IQEvent;
import rocks.xmpp.core.stanza.IQListener;
import rocks.xmpp.core.stanza.MessageEvent;
import rocks.xmpp.core.stanza.MessageListener;
import rocks.xmpp.core.stanza.PresenceEvent;
import rocks.xmpp.core.stanza.PresenceListener;
import rocks.xmpp.core.stanza.StanzaFilter;
import rocks.xmpp.core.stanza.model.AbstractIQ;
import rocks.xmpp.core.stanza.model.AbstractMessage;
import rocks.xmpp.core.stanza.model.AbstractPresence;
import rocks.xmpp.core.stanza.model.Stanza;
import rocks.xmpp.core.stanza.model.StanzaError;
import rocks.xmpp.core.stanza.model.StanzaException;
import rocks.xmpp.core.stanza.model.client.IQ;
import rocks.xmpp.core.stanza.model.client.Message;
import rocks.xmpp.core.stanza.model.client.Presence;
import rocks.xmpp.core.stanza.model.errors.Condition;
import rocks.xmpp.core.stanza.model.errors.ServiceUnavailable;
import rocks.xmpp.core.stream.StreamFeatureEvent;
import rocks.xmpp.core.stream.StreamFeatureListener;
import rocks.xmpp.core.stream.StreamFeatureNegotiator;
import rocks.xmpp.core.stream.StreamFeaturesManager;
import rocks.xmpp.core.stream.model.ClientStreamElement;
import rocks.xmpp.core.stream.model.StreamError;
import rocks.xmpp.core.stream.model.StreamException;
import rocks.xmpp.core.stream.model.StreamFeatures;
import rocks.xmpp.core.subscription.PresenceManager;
import rocks.xmpp.extensions.disco.ServiceDiscoveryManager;
import rocks.xmpp.extensions.disco.model.info.Feature;
import rocks.xmpp.extensions.httpbind.BoshConnectionConfiguration;

public class XmppSession
implements Closeable {
    private static final Logger logger = Logger.getLogger(XmppSession.class.getName());
    private final Lock lock = new ReentrantLock();
    private final java.util.concurrent.locks.Condition streamNegotiatedUntilSasl;
    private final java.util.concurrent.locks.Condition streamNegotiatedUntilResourceBinding;
    private final Unmarshaller unmarshaller;
    private final Marshaller marshaller;
    private final AuthenticationManager authenticationManager;
    private final RosterManager rosterManager;
    private final ReconnectionManager reconnectionManager;
    private final PresenceManager presenceManager;
    private final StreamFeaturesManager streamFeaturesManager;
    private final ChatManager chatManager;
    private final Set<MessageListener> messageListeners = new CopyOnWriteArraySet<MessageListener>();
    private final Set<PresenceListener> presenceListeners = new CopyOnWriteArraySet<PresenceListener>();
    private final Set<IQListener> iqListeners = new CopyOnWriteArraySet<IQListener>();
    private final Set<SessionStatusListener> sessionStatusListeners = new CopyOnWriteArraySet<SessionStatusListener>();
    private final Map<Class<? extends ExtensionManager>, ExtensionManager> instances = new ConcurrentHashMap<Class<? extends ExtensionManager>, ExtensionManager>();
    private final List<Connection> connections = new ArrayList<Connection>();
    private final XmppSessionConfiguration configuration;
    ExecutorService stanzaListenerExecutor;
    volatile Jid connectedResource;
    Connection activeConnection;
    private volatile String xmppServiceDomain;
    private volatile Status status = Status.INITIAL;
    private volatile String resource;
    private volatile Exception exception;
    private Thread shutdownHook;
    private boolean wasLoggedIn;
    private XmppDebugger debugger;

    public XmppSession(String xmppServiceDomain, ConnectionConfiguration ... connectionConfigurations) {
        this(xmppServiceDomain, XmppSessionConfiguration.getDefault(), connectionConfigurations);
    }

    public XmppSession(String xmppServiceDomain, XmppSessionConfiguration configuration, ConnectionConfiguration ... connectionConfigurations) {
        this.xmppServiceDomain = xmppServiceDomain;
        this.configuration = configuration;
        this.stanzaListenerExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setDaemon(true);
                return thread;
            }
        });
        try {
            this.unmarshaller = configuration.getJAXBContext().createUnmarshaller();
            this.marshaller = configuration.getJAXBContext().createMarshaller();
            this.marshaller.setProperty("jaxb.fragment", (Object)true);
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException(e);
        }
        for (Class<? extends ExtensionManager> cls : configuration.getInitialExtensionManagers()) {
            this.getExtensionManager(cls);
        }
        this.shutdownHook = new Thread(){

            @Override
            public void run() {
                XmppSession.this.shutdownHook = null;
                try {
                    if (XmppSession.this.status == Status.CONNECTED) {
                        XmppSession.this.close();
                    }
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, e.getMessage(), e);
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        this.reconnectionManager = new ReconnectionManager(this);
        this.streamFeaturesManager = new StreamFeaturesManager(this);
        this.chatManager = new ChatManager(this);
        this.authenticationManager = new AuthenticationManager(this, this.lock);
        this.authenticationManager.addFeatureListener(new StreamFeatureListener(){

            @Override
            public void negotiationStatusChanged(StreamFeatureEvent streamFeatureEvent) {
                if (streamFeatureEvent.getStatus() == StreamFeatureNegotiator.Status.INCOMPLETE && streamFeatureEvent.getElement() instanceof Mechanisms) {
                    XmppSession.this.lock.lock();
                    try {
                        XmppSession.this.streamNegotiatedUntilSasl.signal();
                    }
                    finally {
                        XmppSession.this.lock.unlock();
                    }
                }
            }
        });
        this.rosterManager = new RosterManager(this);
        this.presenceManager = new PresenceManager(this);
        this.streamNegotiatedUntilSasl = this.lock.newCondition();
        this.streamNegotiatedUntilResourceBinding = this.lock.newCondition();
        this.streamFeaturesManager.addFeatureNegotiator(this.authenticationManager);
        this.streamFeaturesManager.addFeatureNegotiator(new StreamFeatureNegotiator(Bind.class){

            @Override
            public StreamFeatureNegotiator.Status processNegotiation(Object element) throws Exception {
                XmppSession.this.lock.lock();
                try {
                    XmppSession.this.streamNegotiatedUntilResourceBinding.signalAll();
                }
                finally {
                    XmppSession.this.lock.unlock();
                }
                return StreamFeatureNegotiator.Status.INCOMPLETE;
            }

            @Override
            public boolean canProcess(Object element) {
                return false;
            }
        });
        this.getExtensionManager(ServiceDiscoveryManager.class).addFeature(new Feature("jid\\20escaping"));
        if (configuration.getDebugger() != null) {
            try {
                this.debugger = configuration.getDebugger().newInstance();
                this.debugger.initialize(this);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
        if (connectionConfigurations.length == 0) {
            this.connections.add(TcpConnectionConfiguration.getDefault().createConnection(this));
            this.connections.add(BoshConnectionConfiguration.getDefault().createConnection(this));
        } else {
            for (ConnectionConfiguration connectionConfiguration : connectionConfigurations) {
                this.connections.add(connectionConfiguration.createConnection(this));
            }
        }
    }

    public Connection getActiveConnection() {
        return this.activeConnection;
    }

    public void setXmppServiceDomain(String xmppServiceDomain) {
        this.xmppServiceDomain = xmppServiceDomain;
    }

    public final void addMessageListener(MessageListener messageListener) {
        this.messageListeners.add(messageListener);
    }

    public final void removeMessageListener(MessageListener messageListener) {
        this.messageListeners.remove(messageListener);
    }

    public final void addPresenceListener(PresenceListener presenceListener) {
        this.presenceListeners.add(presenceListener);
    }

    public final void removePresenceListener(PresenceListener presenceListener) {
        this.presenceListeners.remove(presenceListener);
    }

    public final void addIQListener(IQListener iqListener) {
        this.iqListeners.add(iqListener);
    }

    public final void removeIQListener(IQListener iqListener) {
        this.iqListeners.remove(iqListener);
    }

    public final void addSessionStatusListener(SessionStatusListener sessionStatusListener) {
        this.sessionStatusListeners.add(sessionStatusListener);
    }

    public final void removeSessionStatusListener(SessionStatusListener sessionStatusListener) {
        this.sessionStatusListeners.remove(sessionStatusListener);
    }

    private void notifyStanzaListeners(Stanza element, boolean incoming) {
        if (element instanceof Message) {
            MessageEvent messageEvent = new MessageEvent((Object)this, (Message)element, incoming);
            for (MessageListener messageListener : this.messageListeners) {
                try {
                    messageListener.handle(messageEvent);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, e.getMessage(), e);
                }
            }
        } else if (element instanceof Presence) {
            PresenceEvent presenceEvent = new PresenceEvent((Object)this, (Presence)element, incoming);
            for (PresenceListener presenceListener : this.presenceListeners) {
                try {
                    presenceListener.handle(presenceEvent);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, e.getMessage(), e);
                }
            }
        } else if (element instanceof IQ) {
            IQ iq = (IQ)element;
            IQEvent iqEvent = new IQEvent((Object)this, iq, incoming);
            for (IQListener iqListener : this.iqListeners) {
                try {
                    iqListener.handle(iqEvent);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, e.getMessage(), e);
                }
            }
            if (incoming && (iq.getType() == AbstractIQ.Type.GET || iq.getType() == AbstractIQ.Type.SET) && !iqEvent.isConsumed()) {
                IQ error = iq.createError(new StanzaError((Condition)new ServiceUnavailable()));
                this.send((ClientStreamElement)error);
            }
        }
    }

    private void notifyConnectionListeners(Status status, Status oldStatus, Exception exception) {
        for (SessionStatusListener connectionListener : this.sessionStatusListeners) {
            try {
                connectionListener.sessionStatusChanged(new SessionStatusEvent(this, status, oldStatus, exception));
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    public IQ query(IQ iq) throws XmppException {
        return this.query(iq, this.configuration.getDefaultResponseTimeout());
    }

    public IQ query(final IQ iq, long timeout) throws XmppException {
        if (iq.getType() != AbstractIQ.Type.GET && iq.getType() != AbstractIQ.Type.SET) {
            throw new IllegalArgumentException("IQ must be of type 'get' or 'set'");
        }
        return this.sendAndAwaitIQ((ClientStreamElement)iq, new StanzaFilter<IQ>(){

            @Override
            public boolean accept(IQ stanza) {
                return stanza.getId() != null && stanza.getId().equals(iq.getId()) && (stanza.getType() == AbstractIQ.Type.RESULT || stanza.getType() == AbstractIQ.Type.ERROR);
            }
        }, timeout);
    }

    public IQ sendAndAwaitIQ(ClientStreamElement stanza, StanzaFilter<IQ> filter) throws NoResponseException, StanzaException {
        return this.sendAndAwaitIQ(stanza, filter, this.configuration.getDefaultResponseTimeout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IQ sendAndAwaitIQ(ClientStreamElement stanza, final StanzaFilter<IQ> filter, long timeout) throws NoResponseException, StanzaException {
        final IQ[] result = new IQ[1];
        final java.util.concurrent.locks.Condition resultReceived = this.lock.newCondition();
        IQListener listener = new IQListener(){

            @Override
            public void handle(IQEvent e) {
                IQ iq = e.getIQ();
                if (e.isIncoming() && filter.accept(iq)) {
                    XmppSession.this.lock.lock();
                    try {
                        result[0] = iq;
                    }
                    finally {
                        resultReceived.signal();
                        XmppSession.this.lock.unlock();
                    }
                }
            }
        };
        this.lock.lock();
        try {
            this.addIQListener(listener);
            this.send(stanza);
            if (!resultReceived.await(timeout, TimeUnit.MILLISECONDS)) {
                throw new NoResponseException("Timeout reached, while waiting on a response.");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.lock.unlock();
            this.removeIQListener(listener);
        }
        IQ response = result[0];
        if (response.getType() == AbstractIQ.Type.ERROR) {
            throw new StanzaException((Stanza)response);
        }
        return result[0];
    }

    public Presence sendAndAwaitPresence(ClientStreamElement stanza, StanzaFilter<Presence> filter) throws NoResponseException, StanzaException {
        return this.sendAndAwaitPresence(stanza, filter, this.configuration.getDefaultResponseTimeout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Presence sendAndAwaitPresence(ClientStreamElement stanza, final StanzaFilter<Presence> filter, long timeout) throws NoResponseException, StanzaException {
        final Presence[] result = new Presence[1];
        final java.util.concurrent.locks.Condition resultReceived = this.lock.newCondition();
        PresenceListener listener = new PresenceListener(){

            @Override
            public void handle(PresenceEvent e) {
                Presence presence = e.getPresence();
                if (e.isIncoming() && filter.accept(presence)) {
                    XmppSession.this.lock.lock();
                    try {
                        result[0] = presence;
                    }
                    finally {
                        resultReceived.signal();
                        XmppSession.this.lock.unlock();
                    }
                }
            }
        };
        this.lock.lock();
        try {
            this.addPresenceListener(listener);
            this.send(stanza);
            if (!resultReceived.await(this.configuration.getDefaultResponseTimeout(), TimeUnit.MILLISECONDS)) {
                throw new NoResponseException("Timeout reached, while waiting on a response.");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.lock.unlock();
            this.removePresenceListener(listener);
        }
        Presence response = result[0];
        if (response.getType() == AbstractPresence.Type.ERROR) {
            throw new StanzaException((Stanza)response);
        }
        return result[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message sendAndAwaitMessage(ClientStreamElement stanza, final StanzaFilter<Message> filter) throws NoResponseException, StanzaException {
        final Message[] result = new Message[1];
        final java.util.concurrent.locks.Condition resultReceived = this.lock.newCondition();
        MessageListener listener = new MessageListener(){

            @Override
            public void handle(MessageEvent e) {
                Message message = e.getMessage();
                if (e.isIncoming() && filter.accept(message)) {
                    XmppSession.this.lock.lock();
                    try {
                        result[0] = message;
                    }
                    finally {
                        resultReceived.signal();
                        XmppSession.this.lock.unlock();
                    }
                }
            }
        };
        this.lock.lock();
        try {
            this.addMessageListener(listener);
            this.send(stanza);
            if (!resultReceived.await(this.configuration.getDefaultResponseTimeout(), TimeUnit.MILLISECONDS)) {
                throw new NoResponseException("Timeout reached, while waiting on a response.");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.lock.unlock();
            this.removeMessageListener(listener);
        }
        Message response = result[0];
        if (response.getType() == AbstractMessage.Type.ERROR) {
            throw new StanzaException((Stanza)response);
        }
        return response;
    }

    public final synchronized void reconnect() throws IOException, LoginException {
        if (this.status == Status.DISCONNECTED) {
            this.connect();
            if (this.wasLoggedIn) {
                try {
                    this.updateStatus(Status.AUTHENTICATING);
                    this.getAuthenticationManager().reAuthenticate();
                    this.bindResource(this.resource);
                }
                catch (Exception e) {
                    this.updateStatus(Status.DISCONNECTED);
                    throw e;
                }
                this.updateStatus(Status.AUTHENTICATED);
            }
        }
    }

    public synchronized void connect() throws IOException {
        if (this.status == Status.CLOSED) {
            throw new IllegalStateException("Session is already closed. Create a new one.");
        }
        if (this.status != Status.INITIAL && this.status != Status.DISCONNECTED) {
            throw new IllegalStateException("Already connected.");
        }
        Status oldStatus = this.status;
        Status previousStatus = this.status;
        this.updateStatus(Status.CONNECTING);
        this.exception = null;
        Iterator<Connection> connectionIterator = this.connections.iterator();
        while (connectionIterator.hasNext()) {
            Connection connection = connectionIterator.next();
            try {
                connection.connect();
                this.activeConnection = connection;
                break;
            }
            catch (IOException e) {
                if (connectionIterator.hasNext()) {
                    if (this.xmppServiceDomain != null) {
                        logger.log(Level.WARNING, String.format("Connection to domain %s failed. Trying alternative connection.", this.xmppServiceDomain), e);
                        continue;
                    }
                    logger.log(Level.WARNING, String.format("Connection to host %s:%s failed. Trying alternative connection.", connection.getHostname(), connection.getPort()), e);
                    continue;
                }
                this.updateStatus(previousStatus, e);
                throw e;
            }
        }
        try {
            this.waitUntilSaslNegotiationStarted();
        }
        catch (NoResponseException e) {
            throw new IOException((Throwable)((Object)e));
        }
        if (this.exception != null) {
            this.updateStatus(oldStatus);
            throw new IOException(this.exception);
        }
        this.updateStatus(Status.CONNECTED);
    }

    @Override
    public synchronized void close() throws IOException {
        this.updateStatus(Status.CLOSING);
        this.messageListeners.clear();
        this.presenceListeners.clear();
        this.iqListeners.clear();
        if (this.shutdownHook != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        }
        if (this.activeConnection != null) {
            this.activeConnection.close();
            this.activeConnection = null;
        }
        this.stanzaListenerExecutor.shutdown();
        this.updateStatus(Status.CLOSED);
    }

    public void send(ClientStreamElement element) {
        if (!this.isConnected() && this.status != Status.CONNECTING) {
            throw new IllegalStateException(String.format("Session is not connected to server", new Object[0]));
        }
        if (element instanceof Stanza) {
            this.notifyStanzaListeners((Stanza)element, false);
        }
        if (this.activeConnection == null) {
            throw new IllegalStateException("No connection established.");
        }
        this.activeConnection.send(element);
    }

    public final synchronized void login(String user, String password) throws LoginException {
        this.login(user, password, null);
    }

    public final synchronized void login(String user, String password, String resource) throws LoginException {
        if (user == null) {
            throw new IllegalArgumentException("user must not be null.");
        }
        if (password == null) {
            throw new IllegalArgumentException("password must not be null.");
        }
        if (this.getDomain() == null) {
            throw new IllegalStateException("The XMPP domain must not be null.");
        }
        if (this.getStatus() == Status.AUTHENTICATED) {
            throw new IllegalStateException("You are already logged in.");
        }
        if (this.getStatus() != Status.CONNECTED) {
            throw new IllegalStateException("You must be connected to the server before trying to login.");
        }
        this.exception = null;
        try {
            this.updateStatus(Status.AUTHENTICATING);
            this.authenticationManager.authenticate(null, user, password, null);
            this.bindResource(resource);
            if (this.getRosterManager().isRetrieveRosterOnLogin()) {
                this.getRosterManager().requestRoster();
            }
        }
        catch (Exception e) {
            this.updateStatus(Status.CONNECTED);
            if (this.exception != null) {
                Throwable ex = e;
                while (ex.getCause() != null) {
                    ex = e.getCause();
                }
                ex.initCause(this.exception);
            }
            if (e instanceof LoginException) {
                throw (LoginException)e;
            }
            LoginException loginException = new LoginException("Login failed");
            loginException.initCause(e);
            throw loginException;
        }
        this.updateStatus(Status.AUTHENTICATED);
    }

    public final synchronized void loginAnonymously() throws LoginException {
        try {
            this.updateStatus(Status.AUTHENTICATING);
            this.authenticationManager.authenticateAnonymously();
            this.bindResource(null);
        }
        catch (Exception e) {
            this.updateStatus(Status.CONNECTED);
            if (this.exception != null) {
                Throwable ex = e;
                while (ex.getCause() != null) {
                    ex = e.getCause();
                }
                ex.initCause(this.exception);
            }
            throw e;
        }
        this.updateStatus(Status.AUTHENTICATED);
    }

    private void bindResource(String resource) throws LoginException {
        IQ result;
        this.resource = resource;
        if (!this.streamFeaturesManager.getFeatures().containsKey(Bind.class)) {
            this.lock.lock();
            try {
                if (!this.streamFeaturesManager.getFeatures().containsKey(Bind.class) && !this.streamNegotiatedUntilResourceBinding.await(5L, TimeUnit.SECONDS)) {
                    throw new LoginException("Timeout reached during resource binding.");
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                this.lock.unlock();
            }
        }
        IQ iq = new IQ(AbstractIQ.Type.SET, (Object)new Bind(this.resource));
        try {
            result = this.query(iq);
        }
        catch (StanzaException e) {
            LoginException loginException = new LoginException("Error during resource binding: " + e.getStanza().toString());
            loginException.initCause(e);
            throw loginException;
        }
        catch (XmppException e) {
            LoginException loginException = new LoginException(e.getMessage());
            loginException.initCause(e);
            throw loginException;
        }
        Bind bindResult = (Bind)result.getExtension(Bind.class);
        this.connectedResource = bindResult.getJid();
        if (this.streamFeaturesManager.getFeatures().containsKey(Session.class)) {
            try {
                this.query(new IQ(AbstractIQ.Type.SET, (Object)new Session()));
            }
            catch (StanzaException e) {
                LoginException loginException = new LoginException("Error during session establishment: " + e.getStanza().toString());
                loginException.initCause(e);
                throw loginException;
            }
            catch (XmppException e) {
                LoginException loginException = new LoginException(e.getMessage());
                loginException.initCause(e);
                throw loginException;
            }
        }
    }

    public final boolean handleElement(final Object element) throws Exception {
        if (element instanceof Stanza) {
            this.stanzaListenerExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    XmppSession.this.notifyStanzaListeners((Stanza)element, true);
                }
            });
        } else if (element instanceof StreamFeatures) {
            this.streamFeaturesManager.processFeatures((StreamFeatures)element);
        } else {
            if (element instanceof StreamError) {
                throw new StreamException((StreamError)element);
            }
            return this.streamFeaturesManager.processElement(element);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void notifyException(Exception e) {
        this.exception = e;
        this.lock.lock();
        try {
            this.streamNegotiatedUntilSasl.signalAll();
        }
        finally {
            this.lock.unlock();
        }
        XmppSession xmppSession = this;
        synchronized (xmppSession) {
            if (this.status == Status.AUTHENTICATED || this.status == Status.AUTHENTICATING || this.status == Status.CONNECTED || this.status == Status.CONNECTING) {
                this.updateStatus(Status.DISCONNECTED, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T extends ExtensionManager> T getExtensionManager(Class<T> clazz) {
        ExtensionManager instance = this.instances.get(clazz);
        if (instance == null) {
            Map<Class<? extends ExtensionManager>, ExtensionManager> map = this.instances;
            synchronized (map) {
                instance = this.instances.get(clazz);
                if (instance == null) {
                    try {
                        Constructor<T> constructor = clazz.getDeclaredConstructor(XmppSession.class);
                        constructor.setAccessible(true);
                        instance = (ExtensionManager)constructor.newInstance(this);
                        this.instances.put(clazz, instance);
                    }
                    catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
            }
        }
        return (T)instance;
    }

    public final AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    public final RosterManager getRosterManager() {
        return this.rosterManager;
    }

    public final PresenceManager getPresenceManager() {
        return this.presenceManager;
    }

    public final ReconnectionManager getReconnectionManager() {
        return this.reconnectionManager;
    }

    public final StreamFeaturesManager getStreamFeaturesManager() {
        return this.streamFeaturesManager;
    }

    public final ChatManager getChatManager() {
        return this.chatManager;
    }

    public final Jid getConnectedResource() {
        return this.connectedResource;
    }

    public final String getDomain() {
        return this.xmppServiceDomain;
    }

    public final Status getStatus() {
        return this.status;
    }

    void updateStatus(Status status) {
        this.updateStatus(status, null);
    }

    final void updateStatus(Status status, Exception e) {
        if (this.status != status) {
            Status oldStatus = this.status;
            this.status = status;
            this.notifyConnectionListeners(status, oldStatus, e);
        }
        if (status == Status.CLOSED) {
            this.sessionStatusListeners.clear();
        }
        if (status == Status.AUTHENTICATED) {
            this.wasLoggedIn = true;
        }
    }

    public List<Connection> getConnections() {
        return Collections.unmodifiableList(this.connections);
    }

    public Unmarshaller getUnmarshaller() {
        return this.unmarshaller;
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    protected final void waitUntilSaslNegotiationStarted() throws NoResponseException, IOException {
        this.lock.lock();
        try {
            if (!this.streamNegotiatedUntilSasl.await(10000L, TimeUnit.SECONDS)) {
                if (this.exception != null) {
                    try {
                        throw new IOException(this.exception);
                    }
                    catch (Throwable throwable) {
                        this.exception = null;
                        throw throwable;
                    }
                }
                throw new NoResponseException("Timeout reached while connecting.");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.lock.unlock();
        }
    }

    public final int getDefaultTimeout() {
        return this.configuration.getDefaultResponseTimeout();
    }

    public boolean isConnected() {
        return this.status == Status.CONNECTED || this.status == Status.AUTHENTICATED || this.status == Status.AUTHENTICATING;
    }

    public XmppSessionConfiguration getConfiguration() {
        return this.configuration;
    }

    public XmppDebugger getDebugger() {
        return this.debugger;
    }

    public static enum Status {
        INITIAL,
        CONNECTING,
        CONNECTED,
        AUTHENTICATING,
        AUTHENTICATED,
        DISCONNECTED,
        CLOSING,
        CLOSED;

    }
}

