/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.session;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import rocks.xmpp.core.XmppUtils;
import rocks.xmpp.core.session.TcpConnection;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.session.debug.XmppDebugger;

final class XmppStreamReader {
    private static final Logger logger = Logger.getLogger(XmppStreamReader.class.getName());
    private final TcpConnection connection;
    private final XmppSession xmppSession;
    private final ExecutorService executorService;
    private final XMLInputFactory xmlInputFactory;
    private final XMLOutputFactory xmlOutputFactory;
    private final XmppDebugger debugger;

    public XmppStreamReader(TcpConnection connection, XmppSession xmppSession, XMLOutputFactory xmlOutputFactory) throws JAXBException {
        this.connection = connection;
        this.xmppSession = xmppSession;
        this.debugger = xmppSession.getDebugger();
        this.executorService = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, "XMPP Reader Thread");
                thread.setDaemon(true);
                return thread;
            }
        });
        this.xmlInputFactory = XMLInputFactory.newFactory();
        this.xmlOutputFactory = xmlOutputFactory;
    }

    void startReading(final InputStream inputStream) {
        this.executorService.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean doRestart = false;
                try {
                    Object xmppInputStream;
                    ByteArrayOutputStream byteArrayOutputStream = null;
                    if (XmppStreamReader.this.debugger != null) {
                        byteArrayOutputStream = new ByteArrayOutputStream();
                        xmppInputStream = XmppStreamReader.this.debugger.createInputStream(XmppUtils.createBranchedInputStream((InputStream)inputStream, (OutputStream)byteArrayOutputStream));
                    } else {
                        xmppInputStream = inputStream;
                    }
                    XMLEventReader xmlEventReader = XmppStreamReader.this.xmlInputFactory.createXMLEventReader((InputStream)xmppInputStream, "UTF-8");
                    boolean isFirstPass = true;
                    while (!doRestart && xmlEventReader.hasNext()) {
                        XMLEvent xmlEvent = xmlEventReader.peek();
                        if (xmlEvent.isStartElement()) {
                            StartElement startElement = xmlEvent.asStartElement();
                            if (startElement.getName().getLocalPart().equals("stream") && startElement.getName().getNamespaceURI().equals("http://etherx.jabber.org/streams")) {
                                Attribute fromAttribute;
                                Attribute idAttribute = startElement.getAttributeByName(new QName("id"));
                                if (idAttribute != null) {
                                    ((XmppStreamReader)XmppStreamReader.this).connection.streamId = idAttribute.getValue();
                                }
                                if ((fromAttribute = startElement.getAttributeByName(new QName("from"))) != null) {
                                    XmppStreamReader.this.xmppSession.setXmppServiceDomain(fromAttribute.getValue());
                                }
                                xmlEventReader.next();
                            } else {
                                Object object = XmppStreamReader.this.xmppSession.getUnmarshaller().unmarshal(xmlEventReader);
                                if (XmppStreamReader.this.debugger != null) {
                                    if (isFirstPass) {
                                        XmppStreamReader.this.debugger.readStanza(byteArrayOutputStream.toString(), object);
                                    } else {
                                        StringWriter stringWriter = new StringWriter();
                                        XMLStreamWriter xmlStreamWriter = XmppUtils.createXmppStreamWriter((XMLStreamWriter)XmppStreamReader.this.xmlOutputFactory.createXMLStreamWriter(stringWriter), (boolean)true);
                                        XMLOutputFactory xMLOutputFactory = XmppStreamReader.this.xmlOutputFactory;
                                        synchronized (xMLOutputFactory) {
                                            XmppStreamReader.this.xmppSession.getMarshaller().marshal(object, xmlStreamWriter);
                                        }
                                        XmppStreamReader.this.debugger.readStanza(stringWriter.toString(), object);
                                    }
                                }
                                isFirstPass = false;
                                doRestart = XmppStreamReader.this.xmppSession.handleElement(object);
                            }
                        } else {
                            xmlEventReader.next();
                        }
                        if (!isFirstPass && byteArrayOutputStream != null) {
                            byteArrayOutputStream.reset();
                        }
                        if (xmlEvent.getEventType() != 2 || XmppStreamReader.this.debugger == null) continue;
                        QName qName = xmlEvent.asEndElement().getName();
                        XmppStreamReader.this.debugger.readStanza("</" + qName.getPrefix() + ":" + qName.getLocalPart() + ">", null);
                    }
                    xmlEventReader.close();
                }
                catch (Exception e) {
                    XmppStreamReader.this.xmppSession.notifyException(e);
                }
                finally {
                    if (doRestart) {
                        XmppStreamReader.this.connection.restartStream();
                    } else {
                        XmppStreamReader xmppStreamReader = XmppStreamReader.this;
                        synchronized (xmppStreamReader) {
                            if (!XmppStreamReader.this.executorService.isShutdown()) {
                                XmppStreamReader.this.executorService.shutdown();
                                try {
                                    XmppStreamReader.this.connection.close();
                                }
                                catch (IOException e) {
                                    logger.log(Level.WARNING, e.getMessage(), e);
                                }
                            }
                        }
                    }
                }
            }
        });
    }

    synchronized void shutdown() {
        if (!this.executorService.isShutdown()) {
            this.executorService.shutdown();
            try {
                this.executorService.awaitTermination(250L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

