/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.stream;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import rocks.xmpp.core.stream.StreamFeatureEvent;
import rocks.xmpp.core.stream.StreamFeatureListener;
import rocks.xmpp.core.stream.model.StreamFeature;

public abstract class StreamFeatureNegotiator {
    private final Set<StreamFeatureListener> streamFeatureListeners = new CopyOnWriteArraySet<StreamFeatureListener>();
    private final Class<? extends StreamFeature> featureClass;

    public StreamFeatureNegotiator(Class<? extends StreamFeature> featureClass) {
        this.featureClass = featureClass;
    }

    public final void addFeatureListener(StreamFeatureListener streamFeatureListener) {
        this.streamFeatureListeners.add(streamFeatureListener);
    }

    public final void removeFeatureListener(StreamFeatureListener streamFeatureListener) {
        this.streamFeatureListeners.remove(streamFeatureListener);
    }

    protected void notifyFeatureNegotiated(Status status, Object element) throws Exception {
        if (status == null) {
            throw new IllegalArgumentException("status must not be null");
        }
        for (StreamFeatureListener streamFeatureListener : this.streamFeatureListeners) {
            streamFeatureListener.negotiationStatusChanged(new StreamFeatureEvent(this, status, element));
        }
    }

    public abstract Status processNegotiation(Object var1) throws Exception;

    public boolean needsRestart() {
        return false;
    }

    public abstract boolean canProcess(Object var1);

    public final Class<? extends StreamFeature> getFeatureClass() {
        return this.featureClass;
    }

    public static enum Status {
        SUCCESS,
        FAILURE,
        INCOMPLETE,
        IGNORE;

    }
}

