/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.stream;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import rocks.xmpp.core.session.SessionStatusEvent;
import rocks.xmpp.core.session.SessionStatusListener;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stream.StreamFeatureNegotiator;
import rocks.xmpp.core.stream.model.StreamFeature;
import rocks.xmpp.core.stream.model.StreamFeatures;
import rocks.xmpp.core.tls.model.StartTls;

public final class StreamFeaturesManager {
    private final Map<Class<? extends StreamFeature>, StreamFeature> features = new ConcurrentHashMap<Class<? extends StreamFeature>, StreamFeature>();
    private final List<StreamFeature> featuresToNegotiate = new ArrayList<StreamFeature>();
    private final Set<Class<? extends StreamFeature>> negotiatedFeatures = new HashSet<Class<? extends StreamFeature>>();
    private final List<StreamFeatureNegotiator> streamFeatureNegotiators = new ArrayList<StreamFeatureNegotiator>();

    public StreamFeaturesManager(XmppSession xmppSession) {
        xmppSession.addSessionStatusListener(new SessionStatusListener(){

            @Override
            public void sessionStatusChanged(SessionStatusEvent e) {
                switch (e.getStatus()) {
                    case CONNECTING: {
                        StreamFeaturesManager.this.features.clear();
                        StreamFeaturesManager.this.featuresToNegotiate.clear();
                        StreamFeaturesManager.this.negotiatedFeatures.clear();
                        break;
                    }
                    case CLOSED: {
                        StreamFeaturesManager.this.streamFeatureNegotiators.clear();
                        StreamFeaturesManager.this.featuresToNegotiate.clear();
                        StreamFeaturesManager.this.negotiatedFeatures.clear();
                        StreamFeaturesManager.this.features.clear();
                    }
                }
            }
        });
    }

    public Map<Class<? extends StreamFeature>, StreamFeature> getFeatures() {
        return Collections.unmodifiableMap(this.features);
    }

    public void addFeatureNegotiator(StreamFeatureNegotiator streamFeatureNegotiator) {
        this.streamFeatureNegotiators.add(streamFeatureNegotiator);
    }

    public void processFeatures(StreamFeatures featuresElement) throws Exception {
        List featureList = featuresElement.getFeatures();
        ArrayList<StreamFeature> sortedFeatureList = new ArrayList<StreamFeature>();
        this.featuresToNegotiate.clear();
        for (Object feature : featureList) {
            if (!(feature instanceof StreamFeature)) continue;
            StreamFeature f = (StreamFeature)feature;
            this.features.put(f.getClass(), f);
            sortedFeatureList.add(f);
        }
        if (featureList.size() == 1 && featureList.get(0) instanceof StartTls) {
            ((StartTls)featureList.get(0)).setMandatory(true);
        }
        Collections.sort(sortedFeatureList);
        this.featuresToNegotiate.addAll(sortedFeatureList);
        this.negotiateNextFeature();
    }

    public boolean processElement(Object element) throws Exception {
        for (StreamFeatureNegotiator streamFeatureNegotiator : this.streamFeatureNegotiators) {
            if (streamFeatureNegotiator.getFeatureClass() != element && !streamFeatureNegotiator.canProcess(element)) continue;
            StreamFeatureNegotiator.Status status = streamFeatureNegotiator.processNegotiation(element);
            this.negotiatedFeatures.add(streamFeatureNegotiator.getFeatureClass());
            if (status != StreamFeatureNegotiator.Status.SUCCESS && status != StreamFeatureNegotiator.Status.IGNORE) continue;
            if (streamFeatureNegotiator.needsRestart()) {
                return true;
            }
            this.negotiateNextFeature();
        }
        return false;
    }

    public void negotiateNextFeature() throws Exception {
        if (this.featuresToNegotiate.size() > 0) {
            StreamFeature advertisedFeature = this.featuresToNegotiate.remove(0);
            if (!this.negotiatedFeatures.contains(advertisedFeature.getClass())) {
                for (StreamFeatureNegotiator streamFeatureNegotiator : this.streamFeatureNegotiators) {
                    if (streamFeatureNegotiator.getFeatureClass() != advertisedFeature.getClass() || streamFeatureNegotiator.processNegotiation(advertisedFeature) != StreamFeatureNegotiator.Status.INCOMPLETE) continue;
                    return;
                }
            }
            this.negotiateNextFeature();
        }
    }
}

