/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.compress;

import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stream.StreamFeatureListener;
import rocks.xmpp.core.stream.StreamFeatureNegotiator;
import rocks.xmpp.core.stream.model.ClientStreamElement;
import rocks.xmpp.extensions.compress.model.Compress;
import rocks.xmpp.extensions.compress.model.Compressed;
import rocks.xmpp.extensions.compress.model.CompressionMethod;
import rocks.xmpp.extensions.compress.model.Failure;
import rocks.xmpp.extensions.compress.model.feature.Compression;

public final class CompressionManager
extends StreamFeatureNegotiator {
    private final XmppSession xmppSession;
    private final CompressionMethod method;

    public CompressionManager(XmppSession xmppSession, StreamFeatureListener streamFeatureListener, CompressionMethod compressionMethod) {
        super(Compression.class);
        this.addFeatureListener(streamFeatureListener);
        this.xmppSession = xmppSession;
        this.method = compressionMethod;
    }

    @Override
    public StreamFeatureNegotiator.Status processNegotiation(Object element) throws Exception {
        StreamFeatureNegotiator.Status status = StreamFeatureNegotiator.Status.INCOMPLETE;
        try {
            if (element instanceof Compression) {
                if (this.method != null) {
                    this.xmppSession.send((ClientStreamElement)new Compress(this.method));
                    status = StreamFeatureNegotiator.Status.INCOMPLETE;
                } else {
                    status = StreamFeatureNegotiator.Status.IGNORE;
                }
            } else if (element instanceof Compressed) {
                status = StreamFeatureNegotiator.Status.SUCCESS;
            } else if (element instanceof Failure) {
                status = StreamFeatureNegotiator.Status.FAILURE;
                throw new Exception("Failure during compression negotiation: " + ((Failure)element).getCondition());
            }
        }
        finally {
            this.notifyFeatureNegotiated(status, element);
        }
        return status;
    }

    @Override
    public boolean needsRestart() {
        return true;
    }

    @Override
    public boolean canProcess(Object element) {
        return element instanceof Compressed || element instanceof Failure;
    }
}

