/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.httpbind;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Deque;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.net.ssl.HttpsURLConnection;
import javax.xml.bind.JAXBElement;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.XMLEvent;
import rocks.xmpp.core.XmppUtils;
import rocks.xmpp.core.session.Connection;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.session.debug.XmppDebugger;
import rocks.xmpp.core.stream.model.ClientStreamElement;
import rocks.xmpp.extensions.httpbind.BoshConnectionConfiguration;
import rocks.xmpp.extensions.httpbind.BoshException;
import rocks.xmpp.extensions.httpbind.model.Body;

public final class BoshConnection
extends Connection {
    final Map<Long, Body> unacknowledgedRequests = new ConcurrentSkipListMap<Long, Body>();
    private final AtomicLong rid = new AtomicLong();
    private final ExecutorService httpBindExecutor;
    private final XMLOutputFactory xmlOutputFactory;
    private final XMLInputFactory xmlInputFactory;
    private final BoshConnectionConfiguration boshConnectionConfiguration;
    private final XmppDebugger debugger;
    private final Deque<String> keySequence = new LinkedList<String>();
    private int requestCount;
    private volatile long highestReceivedRid;
    private volatile String sessionId;
    private volatile boolean usingAcknowledgments;
    private volatile URL url;

    BoshConnection(XmppSession xmppSession, BoshConnectionConfiguration configuration) {
        super(xmppSession, configuration);
        this.boshConnectionConfiguration = configuration;
        this.debugger = this.getXmppSession().getDebugger();
        this.httpBindExecutor = Executors.newFixedThreadPool(2, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, "XMPP BOSH request thread");
                thread.setDaemon(true);
                return thread;
            }
        });
        this.xmlOutputFactory = XMLOutputFactory.newFactory();
        this.xmlInputFactory = XMLInputFactory.newFactory();
    }

    private static void handleCode(int httpCode) throws BoshException {
        if (httpCode != 200) {
            switch (httpCode) {
                case 400: {
                    throw new BoshException(Body.Condition.BAD_REQUEST);
                }
                case 403: {
                    throw new BoshException(Body.Condition.POLICY_VIOLATION);
                }
                case 404: {
                    throw new BoshException(Body.Condition.ITEM_NOT_FOUND);
                }
            }
            throw new BoshException(Body.Condition.UNDEFINED_CONDITION, httpCode);
        }
    }

    private static String findBoshUrl(String xmppServiceDomain) {
        try {
            String query = "_xmppconnect." + xmppServiceDomain;
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            InitialDirContext ctx = new InitialDirContext(env);
            Attributes attributes = ctx.getAttributes(query, new String[]{"TXT"});
            Attribute srvAttribute = attributes.get("TXT");
            if (srvAttribute != null) {
                NamingEnumeration<?> enumeration = srvAttribute.getAll();
                while (enumeration.hasMore()) {
                    String txtRecord = (String)enumeration.next();
                    String[] txtRecordParts = txtRecord.split("=");
                    String key = txtRecordParts[0];
                    String value = txtRecordParts[1];
                    if (!"_xmpp-client-xbosh".equals(key)) continue;
                    return value;
                }
            }
        }
        catch (NamingException e) {
            return null;
        }
        return null;
    }

    private void generateKeySequence() {
        this.keySequence.clear();
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            SecureRandom random = new SecureRandom();
            int n = 256 + random.nextInt(32512);
            String kn = UUID.randomUUID().toString();
            for (int i = 0; i < n; ++i) {
                kn = String.format("%040x", new BigInteger(1, digest.digest(kn.getBytes())));
                this.keySequence.add(kn);
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void connect() throws IOException {
        if (this.getXmppSession() == null) {
            throw new IllegalStateException("Can't connect without XmppSession. Use XmppSession to connect.");
        }
        if (this.url == null) {
            String protocol;
            String string = protocol = this.boshConnectionConfiguration.isSecure() ? "https" : "http";
            if (this.getHostname() != null) {
                this.url = new URL(protocol, this.getHostname(), this.getPort(), this.boshConnectionConfiguration.getFile());
            } else if (this.getXmppSession().getDomain() != null) {
                String resolvedUrl = BoshConnection.findBoshUrl(this.getXmppSession().getDomain());
                this.url = resolvedUrl != null ? new URL(resolvedUrl) : new URL(protocol, this.getXmppSession().getDomain(), this.getPort(), this.boshConnectionConfiguration.getFile());
                this.port = this.url.getPort() > 0 ? this.url.getPort() : this.url.getDefaultPort();
                this.hostname = this.url.getHost();
            } else {
                throw new IllegalStateException("Neither an URL nor a domain given for a BOSH connection.");
            }
        }
        this.sessionId = null;
        this.requestCount = 0;
        this.rid.set(new BigInteger(52, new Random()).longValue());
        Body.Builder body = Body.builder().requestId(this.rid.getAndIncrement()).language(Locale.getDefault().getLanguage()).version("1.11").wait(this.boshConnectionConfiguration.getWait()).hold((byte)1).route(this.boshConnectionConfiguration.getRoute()).ack(1L).xmppVersion("1.0");
        if (this.boshConnectionConfiguration.isUseKeySequence()) {
            Deque<String> deque = this.keySequence;
            synchronized (deque) {
                this.generateKeySequence();
                body.newKey(this.keySequence.removeLast());
            }
        }
        if (this.getXmppSession().getDomain() != null && !this.getXmppSession().getDomain().isEmpty()) {
            body.to(this.getXmppSession().getDomain());
        }
        this.sendNewRequest(body.build());
    }

    private void unpackBody(Body body, long rid) throws Exception {
        if (body.getSid() != null) {
            this.sessionId = body.getSid();
            if (body.getAck() != null) {
                this.usingAcknowledgments = true;
            }
            if (body.getFrom() != null) {
                this.getXmppSession().setXmppServiceDomain(body.getFrom().getDomain());
            }
        }
        this.highestReceivedRid = body.getRid() != null ? body.getRid() : rid;
        this.unacknowledgedRequests.remove(this.highestReceivedRid);
        if (body.getType() == Body.Type.TERMINATE && body.getCondition() != null && body.getCondition() != Body.Condition.REMOTE_STREAM_ERROR) {
            throw new BoshException(body.getCondition(), body.getUri());
        }
        if (body.getType() == Body.Type.ERROR) {
            for (Body unacknowledgedRequest : this.unacknowledgedRequests.values()) {
                this.sendNewRequest(unacknowledgedRequest);
            }
        }
        for (Object wrappedObject : body.getWrappedObjects()) {
            if (!this.getXmppSession().handleElement(wrappedObject)) continue;
            this.restartStream();
        }
    }

    @Override
    protected void restartStream() {
        Body.Builder bodyBuilder = Body.builder().restart(true).to(this.getXmppSession().getDomain()).language(Locale.getDefault().getLanguage()).sessionId(this.getSessionId()).requestId(this.rid.getAndIncrement());
        this.appendKey(bodyBuilder);
        if (!this.unacknowledgedRequests.isEmpty()) {
            bodyBuilder.ack(this.highestReceivedRid);
        }
        this.sendNewRequest(bodyBuilder.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        ExecutorService executorService = this.httpBindExecutor;
        synchronized (executorService) {
            if (!this.httpBindExecutor.isShutdown() && this.sessionId != null) {
                Body.Builder bodyBuilder = Body.builder().requestId(this.rid.getAndIncrement()).sessionId(this.getSessionId()).type(Body.Type.TERMINATE);
                this.appendKey(bodyBuilder);
                this.sendNewRequest(bodyBuilder.build());
                this.httpBindExecutor.shutdown();
                try {
                    this.httpBindExecutor.awaitTermination(500L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long detach() {
        ExecutorService executorService = this.httpBindExecutor;
        synchronized (executorService) {
            if (!this.httpBindExecutor.isShutdown()) {
                this.httpBindExecutor.shutdown();
            }
        }
        return this.rid.get();
    }

    @Override
    public void send(ClientStreamElement element) {
        Body.Builder bodyBuilder = Body.builder().wrappedObjects(Arrays.asList(element)).requestId(this.rid.getAndIncrement()).sessionId(this.getSessionId());
        this.appendKey(bodyBuilder);
        if (!this.unacknowledgedRequests.isEmpty()) {
            bodyBuilder.ack(this.highestReceivedRid);
        }
        this.sendNewRequest(bodyBuilder.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendKey(Body.Builder bodyBuilder) {
        if (this.boshConnectionConfiguration.isUseKeySequence()) {
            Deque<String> deque = this.keySequence;
            synchronized (deque) {
                if (!this.keySequence.isEmpty()) {
                    bodyBuilder.key(this.keySequence.removeLast());
                    if (this.keySequence.isEmpty()) {
                        this.generateKeySequence();
                        bodyBuilder.newKey(this.keySequence.removeLast());
                    }
                }
            }
        }
    }

    public String getSessionId() {
        return this.sessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendNewRequest(final Body body) {
        ExecutorService executorService = this.httpBindExecutor;
        synchronized (executorService) {
            if (!this.httpBindExecutor.isShutdown()) {
                this.httpBindExecutor.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        HttpURLConnection httpConnection = null;
                        try {
                            AutoCloseable byteArrayOutputStream;
                            ExecutorService executorService = BoshConnection.this.httpBindExecutor;
                            synchronized (executorService) {
                                Proxy proxy;
                                BoshConnection.this.requestCount++;
                                if (BoshConnection.this.usingAcknowledgments) {
                                    BoshConnection.this.unacknowledgedRequests.put(body.getRid(), body);
                                }
                                if ((httpConnection = (proxy = BoshConnection.this.getProxy()) != null ? (HttpURLConnection)BoshConnection.this.url.openConnection(BoshConnection.this.getProxy()) : (HttpURLConnection)BoshConnection.this.url.openConnection()) instanceof HttpsURLConnection) {
                                    if (BoshConnection.this.boshConnectionConfiguration.getSSLContext() != null) {
                                        ((HttpsURLConnection)httpConnection).setSSLSocketFactory(BoshConnection.this.boshConnectionConfiguration.getSSLContext().getSocketFactory());
                                    }
                                    if (BoshConnection.this.boshConnectionConfiguration.getHostnameVerifier() != null) {
                                        ((HttpsURLConnection)httpConnection).setHostnameVerifier(BoshConnection.this.boshConnectionConfiguration.getHostnameVerifier());
                                    }
                                }
                                httpConnection.setRequestProperty("Content-Type", "text/xml; charset=utf-8");
                                httpConnection.setDoOutput(true);
                                httpConnection.setRequestMethod("POST");
                                if (BoshConnection.this.getXmppSession().getStatus() == XmppSession.Status.CONNECTING) {
                                    httpConnection.setReadTimeout(10000);
                                } else {
                                    httpConnection.setReadTimeout((BoshConnection.this.boshConnectionConfiguration.getWait() + 5) * 1000);
                                }
                                ByteArrayOutputStream byteArrayOutputStreamRequest = new ByteArrayOutputStream();
                                try (XMLStreamWriter xmlStreamWriter = null;){
                                    OutputStream branchedOutputStream = XmppUtils.createBranchedOutputStream((OutputStream)httpConnection.getOutputStream(), (OutputStream)byteArrayOutputStreamRequest);
                                    OutputStream xmppOutputStream = BoshConnection.this.debugger != null ? BoshConnection.this.debugger.createOutputStream(branchedOutputStream) : branchedOutputStream;
                                    xmlStreamWriter = XmppUtils.createXmppStreamWriter((XMLStreamWriter)BoshConnection.this.xmlOutputFactory.createXMLStreamWriter(xmppOutputStream, "UTF-8"), (boolean)true);
                                    BoshConnection.this.getXmppSession().getMarshaller().marshal((Object)body, xmlStreamWriter);
                                    if (BoshConnection.this.debugger != null) {
                                        BoshConnection.this.debugger.writeStanza(byteArrayOutputStreamRequest.toString(), body);
                                    }
                                }
                            }
                            if (httpConnection.getResponseCode() == 200) {
                                byteArrayOutputStream = new ByteArrayOutputStream();
                                XMLEventReader xmlEventReader = null;
                                InputStream inputStream = XmppUtils.createBranchedInputStream((InputStream)httpConnection.getInputStream(), (OutputStream)byteArrayOutputStream);
                                InputStream xmppInputStream = BoshConnection.this.debugger != null ? BoshConnection.this.debugger.createInputStream(inputStream) : inputStream;
                                try {
                                    xmlEventReader = BoshConnection.this.xmlInputFactory.createXMLEventReader(xmppInputStream, "UTF-8");
                                    while (xmlEventReader.hasNext()) {
                                        XMLEvent xmlEvent = xmlEventReader.peek();
                                        if (xmlEvent.isStartElement()) {
                                            ExecutorService executorService2 = BoshConnection.this.httpBindExecutor;
                                            synchronized (executorService2) {
                                                JAXBElement element = BoshConnection.this.getXmppSession().getUnmarshaller().unmarshal(xmlEventReader, Body.class);
                                                if (BoshConnection.this.debugger != null) {
                                                    BoshConnection.this.debugger.readStanza(((ByteArrayOutputStream)byteArrayOutputStream).toString(), element.getValue());
                                                }
                                                BoshConnection.this.unpackBody((Body)element.getValue(), body.getRid());
                                                continue;
                                            }
                                        }
                                        xmlEventReader.next();
                                    }
                                }
                                finally {
                                    if (xmlEventReader != null) {
                                        xmlEventReader.close();
                                    }
                                }
                            } else {
                                BoshConnection.handleCode(httpConnection.getResponseCode());
                            }
                            Thread.sleep(100L);
                            byteArrayOutputStream = BoshConnection.this.httpBindExecutor;
                            synchronized (byteArrayOutputStream) {
                                if (--BoshConnection.this.requestCount == 0) {
                                    Body.Builder bodyBuilder = Body.builder().requestId(BoshConnection.this.rid.getAndIncrement()).sessionId(BoshConnection.this.getSessionId());
                                    BoshConnection.this.appendKey(bodyBuilder);
                                    if (!BoshConnection.this.unacknowledgedRequests.isEmpty()) {
                                        bodyBuilder.ack(BoshConnection.this.highestReceivedRid);
                                    }
                                    BoshConnection.this.sendNewRequest(bodyBuilder.build());
                                }
                            }
                        }
                        catch (Exception e) {
                            BoshConnection.this.getXmppSession().notifyException(e);
                        }
                        finally {
                            if (httpConnection != null) {
                                httpConnection.disconnect();
                            }
                        }
                    }
                });
            }
        }
    }

    public String getRoute() {
        return this.boshConnectionConfiguration.getRoute();
    }
}

