/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.session;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.testng.Assert;
import org.testng.annotations.Test;
import rocks.xmpp.core.IntegrationTest;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.ConnectionConfiguration;
import rocks.xmpp.core.session.SessionStatusEvent;
import rocks.xmpp.core.session.SessionStatusListener;
import rocks.xmpp.core.session.TcpConnectionConfiguration;
import rocks.xmpp.core.session.XmppSession;

public class MultiThreadingIT
extends IntegrationTest {
    @Test
    public void shouldNotCloseMoreThanOnce() throws XmppException, InterruptedException {
        final XmppSession xmppSession = new XmppSession("localhost", new ConnectionConfiguration[]{TcpConnectionConfiguration.getDefault()});
        final AtomicInteger closing = new AtomicInteger();
        final AtomicInteger closed = new AtomicInteger();
        xmppSession.addSessionStatusListener(new SessionStatusListener(){

            public void sessionStatusChanged(SessionStatusEvent e) {
                if (e.getStatus() == XmppSession.Status.CLOSING) {
                    closing.incrementAndGet();
                }
                if (e.getStatus() == XmppSession.Status.CLOSED) {
                    closed.incrementAndGet();
                }
            }
        });
        xmppSession.connect();
        ExecutorService executor = Executors.newCachedThreadPool();
        final CountDownLatch countDownLatch = new CountDownLatch(100);
        final AtomicReference exception = new AtomicReference();
        for (int i = 0; i < 100; ++i) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        xmppSession.close();
                    }
                    catch (XmppException e) {
                        exception.set(e);
                    }
                    finally {
                        countDownLatch.countDown();
                    }
                }
            });
        }
        countDownLatch.await();
        Assert.assertEquals((int)closing.get(), (int)1);
        Assert.assertEquals((int)closed.get(), (int)1);
        if (exception.get() != null) {
            Assert.fail((String)((Exception)exception.get()).getMessage(), (Throwable)((Throwable)exception.get()));
        }
    }

    @Test
    public void shouldNotConnectMoreThanOnceWhileConnected() throws Exception {
        final XmppSession xmppSession = new XmppSession("localhost", new ConnectionConfiguration[]{TcpConnectionConfiguration.getDefault()});
        final AtomicInteger connecting = new AtomicInteger();
        final AtomicInteger connected = new AtomicInteger();
        xmppSession.addSessionStatusListener(new SessionStatusListener(){

            public void sessionStatusChanged(SessionStatusEvent e) {
                if (e.getStatus() == XmppSession.Status.CONNECTING) {
                    connecting.incrementAndGet();
                }
                if (e.getStatus() == XmppSession.Status.CONNECTED) {
                    connected.incrementAndGet();
                }
            }
        });
        ExecutorService executor = Executors.newCachedThreadPool();
        final CountDownLatch countDownLatch = new CountDownLatch(100);
        final AtomicReference exception = new AtomicReference();
        for (int i = 0; i < 100; ++i) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        xmppSession.connect();
                    }
                    catch (XmppException e) {
                        exception.set(e);
                    }
                    finally {
                        countDownLatch.countDown();
                    }
                }
            });
        }
        countDownLatch.await();
        Assert.assertEquals((int)connecting.get(), (int)1);
        Assert.assertEquals((int)connected.get(), (int)1);
        if (exception.get() != null) {
            throw (Exception)exception.get();
        }
    }

    @Test
    public void shouldNotConnectWhileLoggedIn() throws Exception {
        final XmppSession xmppSession = new XmppSession("localhost", new ConnectionConfiguration[]{TcpConnectionConfiguration.getDefault()});
        final AtomicInteger connecting = new AtomicInteger();
        final AtomicInteger connected = new AtomicInteger();
        xmppSession.addSessionStatusListener(new SessionStatusListener(){

            public void sessionStatusChanged(SessionStatusEvent e) {
                if (e.getStatus() == XmppSession.Status.CONNECTING) {
                    connecting.incrementAndGet();
                }
                if (e.getStatus() == XmppSession.Status.CONNECTED) {
                    connected.incrementAndGet();
                }
            }
        });
        xmppSession.connect();
        xmppSession.loginAnonymously();
        ExecutorService executor = Executors.newCachedThreadPool();
        final CountDownLatch countDownLatch = new CountDownLatch(100);
        final AtomicReference exception = new AtomicReference();
        for (int i = 0; i < 100; ++i) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        xmppSession.connect();
                    }
                    catch (XmppException e) {
                        exception.set(e);
                    }
                    finally {
                        countDownLatch.countDown();
                    }
                }
            });
        }
        countDownLatch.await();
        Assert.assertEquals((int)connecting.get(), (int)1);
        Assert.assertEquals((int)connected.get(), (int)1);
        if (exception.get() != null) {
            throw (Exception)exception.get();
        }
    }

    @Test
    public void shouldOnlyLoginOnce() throws Exception {
        final XmppSession xmppSession = new XmppSession("localhost", new ConnectionConfiguration[]{TcpConnectionConfiguration.getDefault()});
        final AtomicInteger authenticating = new AtomicInteger();
        final AtomicInteger authenticated = new AtomicInteger();
        final AtomicInteger exceptions = new AtomicInteger();
        xmppSession.addSessionStatusListener(new SessionStatusListener(){

            public void sessionStatusChanged(SessionStatusEvent e) {
                if (e.getStatus() == XmppSession.Status.AUTHENTICATING) {
                    authenticating.incrementAndGet();
                }
                if (e.getStatus() == XmppSession.Status.AUTHENTICATED) {
                    authenticated.incrementAndGet();
                }
            }
        });
        xmppSession.connect();
        ExecutorService executor = Executors.newCachedThreadPool();
        final CountDownLatch countDownLatch = new CountDownLatch(100);
        for (int i = 0; i < 100; ++i) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        xmppSession.login("111", "111");
                    }
                    catch (Exception e) {
                        exceptions.incrementAndGet();
                    }
                    finally {
                        countDownLatch.countDown();
                    }
                }
            });
        }
        countDownLatch.await();
        Assert.assertEquals((int)authenticating.get(), (int)1);
        Assert.assertEquals((int)authenticated.get(), (int)1);
        Assert.assertEquals((int)exceptions.get(), (int)99);
    }
}

