/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.disco;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import org.testng.Assert;
import org.testng.annotations.Test;
import rocks.xmpp.core.BaseTest;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.MockServer;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.TestXmppSession;
import rocks.xmpp.extensions.data.model.DataForm;
import rocks.xmpp.extensions.disco.DefaultItemProvider;
import rocks.xmpp.extensions.disco.ServiceDiscoveryManager;
import rocks.xmpp.extensions.disco.model.info.Feature;
import rocks.xmpp.extensions.disco.model.info.Identity;
import rocks.xmpp.extensions.disco.model.info.InfoNode;
import rocks.xmpp.extensions.disco.model.items.Item;
import rocks.xmpp.extensions.disco.model.items.ItemNode;
import rocks.xmpp.extensions.rsm.ResultSetProvider;
import rocks.xmpp.extensions.rsm.model.ResultSetManagement;

public class ServiceDiscoveryManagerTest
extends BaseTest {
    @Test
    public void testFeatureEquals() {
        ServiceDiscoveryManager serviceDiscoveryManager = (ServiceDiscoveryManager)this.xmppSession.getManager(ServiceDiscoveryManager.class);
        serviceDiscoveryManager.addFeature(new Feature("http://jabber.org/protocol/muc"));
        Assert.assertTrue((boolean)serviceDiscoveryManager.getFeatures().contains(new Feature("http://jabber.org/protocol/muc")));
    }

    @Test
    public void testItemsEquals() {
        ServiceDiscoveryManager serviceDiscoveryManager = (ServiceDiscoveryManager)this.xmppSession.getManager(ServiceDiscoveryManager.class);
        serviceDiscoveryManager.addIdentity(new Identity("conference", "text", "name1", "en"));
        Assert.assertTrue((boolean)serviceDiscoveryManager.getIdentities().contains(new Identity("conference", "text", "name2", "en")));
    }

    @Test
    public void testInfoDiscovery() throws XmppException {
        MockServer mockServer = new MockServer();
        TestXmppSession connection1 = new TestXmppSession(ROMEO, mockServer);
        new TestXmppSession(JULIET, mockServer);
        ServiceDiscoveryManager serviceDiscoveryManager = (ServiceDiscoveryManager)connection1.getManager(ServiceDiscoveryManager.class);
        InfoNode result = serviceDiscoveryManager.discoverInformation(JULIET);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((result.getFeatures().size() > 1 ? 1 : 0) != 0);
        Assert.assertTrue((result.getIdentities().size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testServiceDiscoveryEntry() {
        TestXmppSession connection1 = new TestXmppSession();
        ServiceDiscoveryManager serviceDiscoveryManager = (ServiceDiscoveryManager)connection1.getManager(ServiceDiscoveryManager.class);
        Assert.assertTrue((boolean)serviceDiscoveryManager.isEnabled());
        Feature featureInfo = new Feature("http://jabber.org/protocol/disco#info");
        Feature featureItems = new Feature("http://jabber.org/protocol/disco#items");
        Assert.assertTrue((boolean)serviceDiscoveryManager.getFeatures().contains(featureInfo));
        Assert.assertTrue((boolean)serviceDiscoveryManager.getFeatures().contains(featureItems));
        serviceDiscoveryManager.setEnabled(false);
        Assert.assertFalse((boolean)serviceDiscoveryManager.isEnabled());
        Assert.assertFalse((boolean)serviceDiscoveryManager.getFeatures().contains(featureInfo));
        Assert.assertFalse((boolean)serviceDiscoveryManager.getFeatures().contains(featureItems));
        serviceDiscoveryManager.addFeature(featureInfo);
        serviceDiscoveryManager.addFeature(featureItems);
        Assert.assertTrue((boolean)serviceDiscoveryManager.isEnabled());
    }

    @Test
    public void testItemDiscovery() throws XmppException {
        MockServer mockServer = new MockServer();
        TestXmppSession connection1 = new TestXmppSession(ROMEO, mockServer);
        ServiceDiscoveryManager serviceDiscoveryManager = (ServiceDiscoveryManager)connection1.getManager(ServiceDiscoveryManager.class);
        serviceDiscoveryManager.setItemProvider((ResultSetProvider)new DefaultItemProvider(Arrays.asList(new Item(Jid.valueOf((String)"test"), "root", "name"))));
        TestXmppSession connection2 = new TestXmppSession(JULIET, mockServer);
        ServiceDiscoveryManager serviceDiscoveryManager2 = (ServiceDiscoveryManager)connection2.getManager(ServiceDiscoveryManager.class);
        ItemNode result = serviceDiscoveryManager2.discoverItems(ROMEO);
        Assert.assertEquals((int)result.getItems().size(), (int)1);
        Assert.assertEquals((String)((Item)result.getItems().get(0)).getNode(), (String)"root");
        Assert.assertEquals((String)((Item)result.getItems().get(0)).getName(), (String)"name");
        Assert.assertEquals((Object)((Item)result.getItems().get(0)).getJid(), (Object)Jid.valueOf((String)"test"));
    }

    @Test
    public void testItemDiscoveryWithNode() throws XmppException {
        MockServer mockServer = new MockServer();
        TestXmppSession connection1 = new TestXmppSession(ROMEO, mockServer);
        ServiceDiscoveryManager serviceDiscoveryManager = (ServiceDiscoveryManager)connection1.getManager(ServiceDiscoveryManager.class);
        DefaultItemProvider defaultItemProvider = new DefaultItemProvider(Arrays.asList(new Item(Jid.valueOf((String)"test"), "node1")));
        serviceDiscoveryManager.setItemProvider("node1", (ResultSetProvider)defaultItemProvider);
        TestXmppSession connection2 = new TestXmppSession(JULIET, mockServer);
        ServiceDiscoveryManager serviceDiscoveryManager2 = (ServiceDiscoveryManager)connection2.getManager(ServiceDiscoveryManager.class);
        ItemNode result = serviceDiscoveryManager2.discoverItems(ROMEO, "node1");
        Assert.assertEquals((int)result.getItems().size(), (int)1);
        Assert.assertEquals((String)((Item)result.getItems().get(0)).getNode(), (String)"node1");
    }

    @Test
    public void testItemDiscoveryWithRsm() throws XmppException {
        MockServer mockServer = new MockServer();
        TestXmppSession connection1 = new TestXmppSession(ROMEO, mockServer);
        ServiceDiscoveryManager serviceDiscoveryManager = (ServiceDiscoveryManager)connection1.getManager(ServiceDiscoveryManager.class);
        ArrayList<Item> items = new ArrayList<Item>();
        for (int i = 0; i < 100; ++i) {
            items.add(new Item(Jid.valueOf((String)"test"), "item" + i));
        }
        serviceDiscoveryManager.setItemProvider((ResultSetProvider)new DefaultItemProvider(items));
        TestXmppSession connection2 = new TestXmppSession(JULIET, mockServer);
        ServiceDiscoveryManager serviceDiscoveryManager2 = (ServiceDiscoveryManager)connection2.getManager(ServiceDiscoveryManager.class);
        ItemNode resultItemCount = serviceDiscoveryManager2.discoverItems(ROMEO, ResultSetManagement.forItemCount());
        Assert.assertTrue((boolean)resultItemCount.getItems().isEmpty());
        Assert.assertEquals((Object)resultItemCount.getResultSetManagement().getItemCount(), (Object)100);
        ItemNode result = serviceDiscoveryManager2.discoverItems(ROMEO, ResultSetManagement.forLimit((int)10));
        Assert.assertEquals((int)result.getItems().size(), (int)10);
        Assert.assertEquals((String)((Item)result.getItems().get(0)).getNode(), (String)"item0");
        Assert.assertEquals((Object)result.getResultSetManagement().getItemCount(), (Object)100);
        Assert.assertEquals((Object)result.getResultSetManagement().getFirstItemIndex(), (Object)0);
        ItemNode result2 = serviceDiscoveryManager2.discoverItems(ROMEO, ResultSetManagement.forLimit((int)10, (int)20));
        Assert.assertEquals((int)result2.getItems().size(), (int)10);
        Assert.assertEquals((String)((Item)result2.getItems().get(0)).getNode(), (String)"item20");
        Assert.assertEquals((Object)result2.getResultSetManagement().getItemCount(), (Object)100);
        Assert.assertEquals((Object)result2.getResultSetManagement().getFirstItemIndex(), (Object)20);
        ItemNode page1 = serviceDiscoveryManager2.discoverItems(ROMEO, ResultSetManagement.forNextPage((int)10, (String)((Item)result2.getItems().get(result2.getItems().size() - 1)).getId()));
        Assert.assertEquals((int)page1.getItems().size(), (int)10);
        Assert.assertEquals((String)((Item)page1.getItems().get(0)).getNode(), (String)"item30");
        Assert.assertEquals((Object)page1.getResultSetManagement().getItemCount(), (Object)100);
        Assert.assertEquals((Object)page1.getResultSetManagement().getFirstItemIndex(), (Object)30);
        ItemNode page2 = serviceDiscoveryManager2.discoverItems(ROMEO, ResultSetManagement.forNextPage((int)10, (String)((Item)page1.getItems().get(page1.getItems().size() - 1)).getId()));
        Assert.assertEquals((int)page2.getItems().size(), (int)10);
        Assert.assertEquals((String)((Item)page2.getItems().get(0)).getNode(), (String)"item40");
        Assert.assertEquals((Object)page2.getResultSetManagement().getItemCount(), (Object)100);
        Assert.assertEquals((Object)page2.getResultSetManagement().getFirstItemIndex(), (Object)40);
    }

    @Test
    public void testItemDiscoveryWithPaging() throws XmppException {
        MockServer mockServer = new MockServer();
        TestXmppSession connection1 = new TestXmppSession(ROMEO, mockServer);
        ServiceDiscoveryManager serviceDiscoveryManager = (ServiceDiscoveryManager)connection1.getManager(ServiceDiscoveryManager.class);
        ArrayList<Item> items = new ArrayList<Item>();
        for (int i = 0; i < 30; ++i) {
            items.add(new Item(Jid.valueOf((String)"test"), "item" + i));
        }
        serviceDiscoveryManager.setItemProvider((ResultSetProvider)new DefaultItemProvider(items));
        TestXmppSession connection2 = new TestXmppSession(JULIET, mockServer);
        ServiceDiscoveryManager serviceDiscoveryManager2 = (ServiceDiscoveryManager)connection2.getManager(ServiceDiscoveryManager.class);
        ItemNode resultItemCount = serviceDiscoveryManager2.discoverItems(ROMEO, ResultSetManagement.forItemCount());
        Assert.assertTrue((boolean)resultItemCount.getItems().isEmpty());
        Assert.assertEquals((Object)resultItemCount.getResultSetManagement().getItemCount(), (Object)30);
        ItemNode page1 = serviceDiscoveryManager2.discoverItems(ROMEO, ResultSetManagement.forLimit((int)10));
        Assert.assertEquals((int)page1.getItems().size(), (int)10);
        Assert.assertEquals((String)((Item)page1.getItems().get(0)).getNode(), (String)"item0");
        Assert.assertEquals((Object)page1.getResultSetManagement().getItemCount(), (Object)30);
        Assert.assertEquals((Object)page1.getResultSetManagement().getFirstItemIndex(), (Object)0);
        ItemNode page2 = serviceDiscoveryManager2.discoverItems(ROMEO, ResultSetManagement.forNextPage((int)10, (String)((Item)page1.getItems().get(page1.getItems().size() - 1)).getId()));
        Assert.assertEquals((int)page2.getItems().size(), (int)10);
        Assert.assertEquals((String)((Item)page2.getItems().get(0)).getNode(), (String)"item10");
        Assert.assertEquals((Object)page2.getResultSetManagement().getItemCount(), (Object)30);
        Assert.assertEquals((Object)page2.getResultSetManagement().getFirstItemIndex(), (Object)10);
        ItemNode page3 = serviceDiscoveryManager2.discoverItems(ROMEO, ResultSetManagement.forNextPage((int)10, (String)((Item)page2.getItems().get(page2.getItems().size() - 1)).getId()));
        Assert.assertEquals((int)page3.getItems().size(), (int)10);
        Assert.assertEquals((String)((Item)page3.getItems().get(0)).getNode(), (String)"item20");
        Assert.assertEquals((Object)page3.getResultSetManagement().getItemCount(), (Object)30);
        Assert.assertEquals((Object)page3.getResultSetManagement().getFirstItemIndex(), (Object)20);
        ItemNode page4 = serviceDiscoveryManager2.discoverItems(ROMEO, ResultSetManagement.forNextPage((int)10, (String)((Item)page3.getItems().get(page3.getItems().size() - 1)).getId()));
        Assert.assertEquals((int)page4.getItems().size(), (int)0);
        ItemNode page5 = serviceDiscoveryManager2.discoverItems(ROMEO, ResultSetManagement.forPreviousPage((int)10, (String)((Item)page3.getItems().get(0)).getId()));
        Assert.assertEquals((int)page5.getItems().size(), (int)10);
        Assert.assertEquals((String)((Item)page5.getItems().get(0)).getNode(), (String)"item10");
        Assert.assertEquals((Object)page5.getResultSetManagement().getItemCount(), (Object)30);
        Assert.assertEquals((Object)page5.getResultSetManagement().getFirstItemIndex(), (Object)10);
        ItemNode page6 = serviceDiscoveryManager2.discoverItems(ROMEO, ResultSetManagement.forPreviousPage((int)5, (String)((Item)page5.getItems().get(0)).getId()));
        Assert.assertEquals((int)page6.getItems().size(), (int)5);
        Assert.assertEquals((String)((Item)page6.getItems().get(0)).getNode(), (String)"item5");
        Assert.assertEquals((Object)page6.getResultSetManagement().getItemCount(), (Object)30);
        Assert.assertEquals((Object)page6.getResultSetManagement().getFirstItemIndex(), (Object)5);
    }

    @Test
    public void testPropertyChangeHandler() {
        ServiceDiscoveryManager serviceDiscoveryManager = (ServiceDiscoveryManager)this.xmppSession.getManager(ServiceDiscoveryManager.class);
        final int[] listenerCalled = new int[]{0};
        serviceDiscoveryManager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                listenerCalled[0] = listenerCalled[0] + 1;
            }
        });
        serviceDiscoveryManager.addFeature(new Feature("dummy"));
        serviceDiscoveryManager.removeFeature(new Feature("dummy"));
        serviceDiscoveryManager.addIdentity(new Identity("cat", "type"));
        serviceDiscoveryManager.removeIdentity(new Identity("cat", "type"));
        DataForm dataForm = new DataForm(DataForm.Type.SUBMIT);
        serviceDiscoveryManager.addExtension(dataForm);
        serviceDiscoveryManager.removeExtension(dataForm);
        if (listenerCalled[0] != 6) {
            Assert.fail();
        }
    }
}

