/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.chat;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import rocks.xmpp.core.stanza.MessageEvent;
import rocks.xmpp.core.stanza.MessageListener;
import rocks.xmpp.core.stanza.model.client.Message;

public abstract class Chat {
    private static final Logger logger = Logger.getLogger(Chat.class.getName());
    protected final Set<MessageListener> inboundMessageListeners = new CopyOnWriteArraySet<MessageListener>();

    public abstract Message sendMessage(String var1);

    public abstract Message sendMessage(Message var1);

    public final void addInboundMessageListener(MessageListener messageListener) {
        this.inboundMessageListeners.add(messageListener);
    }

    public final void removeInboundMessageListener(MessageListener messageListener) {
        this.inboundMessageListeners.remove(messageListener);
    }

    protected void notifyInboundMessageListeners(MessageEvent messageEvent) {
        for (MessageListener messageListener : this.inboundMessageListeners) {
            try {
                messageListener.handleMessage(messageEvent);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }
}

