/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.roster;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.XmppUtils;
import rocks.xmpp.core.roster.RosterEvent;
import rocks.xmpp.core.roster.RosterListener;
import rocks.xmpp.core.roster.model.Contact;
import rocks.xmpp.core.roster.model.ContactGroup;
import rocks.xmpp.core.roster.model.Roster;
import rocks.xmpp.core.roster.versioning.model.RosterVersioning;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.SessionStatusEvent;
import rocks.xmpp.core.session.SessionStatusListener;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.AbstractIQHandler;
import rocks.xmpp.core.stanza.model.AbstractIQ;
import rocks.xmpp.core.stanza.model.client.IQ;
import rocks.xmpp.core.stanza.model.errors.Condition;
import rocks.xmpp.core.stream.StreamFeaturesManager;
import rocks.xmpp.core.subscription.PresenceManager;
import rocks.xmpp.core.util.cache.DirectoryCache;
import rocks.xmpp.extensions.privatedata.PrivateDataManager;
import rocks.xmpp.extensions.privatedata.rosterdelimiter.model.RosterDelimiter;

public final class RosterManager
extends Manager {
    private static final Logger logger = Logger.getLogger(RosterManager.class.getName());
    private final Map<Jid, Contact> contactMap = new ConcurrentHashMap<Jid, Contact>();
    private final Set<RosterListener> rosterListeners = new CopyOnWriteArraySet<RosterListener>();
    private final XmppSession xmppSession;
    private final Map<String, byte[]> rosterCacheDirectory;
    private final Set<ContactGroup> groups = new TreeSet<ContactGroup>();
    private final Set<Contact> unaffiliatedContacts = new TreeSet<Contact>();
    private final Map<String, ContactGroup> rosterGroupMap = new HashMap<String, ContactGroup>();
    private final PrivateDataManager privateDataManager;
    private boolean retrieveRosterOnLogin = true;
    private boolean askForGroupDelimiter;
    private String groupDelimiter;

    private RosterManager(XmppSession xmppSession) {
        this.xmppSession = xmppSession;
        this.privateDataManager = xmppSession.getManager(PrivateDataManager.class);
        this.rosterCacheDirectory = xmppSession.getConfiguration().getCacheDirectory() != null ? new DirectoryCache(xmppSession.getConfiguration().getCacheDirectory().resolve("rosterver")) : null;
        this.setEnabled(true);
    }

    private static Collection<Contact> collectAllContactsInGroup(ContactGroup contactGroup) {
        ArrayList<Contact> contacts = new ArrayList<Contact>();
        for (Contact contact : contactGroup.getContacts()) {
            RosterManager.addContactIfNotExists(contact, contacts);
        }
        ArrayList<Contact> contactsInSubGroups = new ArrayList<Contact>();
        for (ContactGroup subGroup : contactGroup.getGroups()) {
            contactsInSubGroups.addAll(RosterManager.collectAllContactsInGroup(subGroup));
        }
        for (Contact contact : contactsInSubGroups) {
            RosterManager.addContactIfNotExists(contact, contacts);
        }
        return contacts;
    }

    private static void addContactIfNotExists(Contact contact, Collection<Contact> contacts) {
        boolean contactExists = false;
        for (Contact c : contacts) {
            if (!c.getJid().equals((Object)contact.getJid())) continue;
            contactExists = true;
        }
        if (!contactExists) {
            contacts.add(contact);
        }
    }

    @Override
    protected final void initialize() {
        this.xmppSession.addIQHandler(Roster.class, new AbstractIQHandler(this, AbstractIQ.Type.SET){

            @Override
            public IQ processRequest(IQ iq) {
                Roster roster = (Roster)iq.getExtension(Roster.class);
                if (iq.getFrom() == null || iq.getFrom().equals((Object)RosterManager.this.xmppSession.getConnectedResource().asBareJid())) {
                    RosterManager.this.updateRoster(roster, true);
                    return iq.createResult();
                }
                return iq.createError(Condition.SERVICE_UNAVAILABLE);
            }
        }, false);
        this.xmppSession.addSessionStatusListener(new SessionStatusListener(){

            @Override
            public void sessionStatusChanged(SessionStatusEvent e) {
                if (e.getStatus() == XmppSession.Status.CLOSED) {
                    RosterManager.this.rosterListeners.clear();
                }
            }
        });
    }

    public final Collection<Contact> getContacts() {
        return Collections.unmodifiableCollection(new ArrayList<Contact>(this.contactMap.values()));
    }

    public final Contact getContact(Jid jid) {
        return this.contactMap.get(Objects.requireNonNull(jid, "jid must not be null").asBareJid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateRoster(Roster roster, boolean isRosterPush) {
        ArrayList<Contact> addedContacts = new ArrayList<Contact>();
        ArrayList<Contact> updatedContacts = new ArrayList<Contact>();
        ArrayList<Contact> removedContacts = new ArrayList<Contact>();
        ArrayList contacts = new ArrayList(roster.getContacts());
        Collections.sort(contacts);
        RosterManager rosterManager = this;
        synchronized (rosterManager) {
            if (!isRosterPush) {
                this.rosterGroupMap.clear();
                this.contactMap.clear();
            }
            for (Contact contact : contacts) {
                Contact oldContact = this.contactMap.get(contact.getJid());
                if (contact.getSubscription() == Contact.Subscription.REMOVE) {
                    this.contactMap.remove(contact.getJid());
                    removedContacts.add(contact);
                } else if (oldContact != null && !oldContact.equals((Object)contact)) {
                    this.contactMap.put(contact.getJid(), contact);
                    updatedContacts.add(contact);
                } else if (oldContact == null) {
                    this.contactMap.put(contact.getJid(), contact);
                    addedContacts.add(contact);
                }
                if (contact.getSubscription() != Contact.Subscription.REMOVE) {
                    for (String group : contact.getGroups()) {
                        String[] nestedGroups = this.groupDelimiter != null && !this.groupDelimiter.isEmpty() ? group.split(this.groupDelimiter) : new String[]{group};
                        String currentGroupName = "";
                        ContactGroup currentGroup = null;
                        for (int i = 0; i < nestedGroups.length; ++i) {
                            String nestedGroupName = nestedGroups[i];
                            ContactGroup nestedGroup = this.rosterGroupMap.get(currentGroupName = currentGroupName + nestedGroupName);
                            if (nestedGroup == null) {
                                nestedGroup = new ContactGroup(nestedGroupName, currentGroupName, currentGroup);
                                this.rosterGroupMap.put(currentGroupName, nestedGroup);
                                if (i == 0) {
                                    this.groups.add(nestedGroup);
                                }
                                if (currentGroup != null) {
                                    currentGroup.getGroups().add(nestedGroup);
                                }
                            }
                            currentGroup = nestedGroup;
                            if (i >= nestedGroups.length - 1) continue;
                            currentGroupName = currentGroupName + this.groupDelimiter;
                        }
                        if (currentGroup == null) continue;
                        this.removeContactByJid(contact, currentGroup.getContacts());
                        currentGroup.getContacts().add(contact);
                    }
                }
                this.removeContactByJid(contact, this.unaffiliatedContacts);
                if (contact.getGroups().isEmpty() && contact.getSubscription() != Contact.Subscription.REMOVE) {
                    this.unaffiliatedContacts.add(contact);
                }
                this.removeContactsFromGroups(contact, this.groups);
            }
            this.cacheRoster(roster.getVersion());
        }
        this.notifyRosterListeners(new RosterEvent(this, addedContacts, updatedContacts, removedContacts));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheRoster(String version) {
        if (this.rosterCacheDirectory != null && version != null) {
            Roster roster = new Roster(this.contactMap.values(), version);
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                try (XMLStreamWriter xmppStreamWriter = null;){
                    xmppStreamWriter = XmppUtils.createXmppStreamWriter((XMLStreamWriter)XMLOutputFactory.newFactory().createXMLStreamWriter(outputStream), (boolean)true);
                    xmppStreamWriter.flush();
                    this.xmppSession.createMarshaller().marshal((Object)roster, xmppStreamWriter);
                }
                this.rosterCacheDirectory.put(XmppUtils.hash((byte[])this.xmppSession.getConnectedResource().asBareJid().toString().getBytes()) + ".xml", outputStream.toByteArray());
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Could not write roster to cache.", e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Roster readRosterFromCache() {
        if (this.rosterCacheDirectory == null) return null;
        try {
            byte[] rosterData = this.rosterCacheDirectory.get(XmppUtils.hash((byte[])this.xmppSession.getConnectedResource().asBareJid().toString().getBytes()) + ".xml");
            if (rosterData == null) return null;
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(rosterData);){
                Roster roster = (Roster)this.xmppSession.createUnmarshaller().unmarshal((InputStream)inputStream);
                return roster;
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Could not read roster from cache.", e);
        }
        return null;
    }

    private void removeContactByJid(Contact contact, Collection<Contact> contacts) {
        for (Contact c : contacts) {
            if (!c.getJid().equals((Object)contact.getJid())) continue;
            contacts.remove(c);
            break;
        }
    }

    private void removeContactsFromGroups(Contact contact, Collection<ContactGroup> contactGroups) {
        ArrayList<ContactGroup> emptyGroups = new ArrayList<ContactGroup>();
        for (ContactGroup group : contactGroups) {
            if (!this.removeRecursively(contact, group)) continue;
            emptyGroups.add(group);
            this.rosterGroupMap.remove(group.getFullName());
        }
        contactGroups.removeAll(emptyGroups);
    }

    private boolean removeRecursively(Contact contact, ContactGroup contactGroup) {
        this.removeContactsFromGroups(contact, contactGroup.getGroups());
        boolean contactExistsInGroup = false;
        block0: for (Contact c : contactGroup.getContacts()) {
            if (!c.getJid().equals((Object)contact.getJid())) continue;
            for (String groupName : contact.getGroups()) {
                if (!groupName.equals(contactGroup.getFullName())) continue;
                contactExistsInGroup = true;
                break block0;
            }
        }
        if (!contactExistsInGroup || contact.getSubscription() == Contact.Subscription.REMOVE) {
            this.removeContactByJid(contact, contactGroup.getContacts());
        }
        return contactGroup.getContacts().isEmpty() && contactGroup.getGroups().isEmpty();
    }

    public final synchronized Collection<ContactGroup> getContactGroups() {
        return Collections.unmodifiableCollection(new ArrayList<ContactGroup>(this.groups));
    }

    public final synchronized Collection<Contact> getUnaffiliatedContacts() {
        return Collections.unmodifiableCollection(new ArrayList<Contact>(this.unaffiliatedContacts));
    }

    public final void addRosterListener(RosterListener rosterListener) {
        this.rosterListeners.add(rosterListener);
    }

    public final void removeRosterListener(RosterListener rosterListener) {
        this.rosterListeners.remove(rosterListener);
    }

    private void notifyRosterListeners(RosterEvent rosterEvent) {
        for (RosterListener rosterListener : this.rosterListeners) {
            try {
                rosterListener.rosterChanged(rosterEvent);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    public final synchronized boolean isRetrieveRosterOnLogin() {
        return this.retrieveRosterOnLogin;
    }

    public final synchronized void setRetrieveRosterOnLogin(boolean retrieveRosterOnLogin) {
        this.retrieveRosterOnLogin = retrieveRosterOnLogin;
    }

    public final Roster requestRoster() throws XmppException {
        Roster rosterRequest;
        if (this.isAskForGroupDelimiter()) {
            try {
                PrivateDataManager privateDataManager = this.xmppSession.getManager(PrivateDataManager.class);
                RosterDelimiter rosterDelimiter = privateDataManager.getData(RosterDelimiter.class);
                this.setGroupDelimiter(rosterDelimiter.getRosterDelimiter());
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Roster delimiter could not be retrieved from private storage.");
            }
        }
        Roster roster = null;
        if (this.isRosterVersioningSupported()) {
            roster = this.readRosterFromCache();
            String ver = roster != null ? roster.getVersion() : "";
            rosterRequest = new Roster(ver);
        } else {
            rosterRequest = new Roster();
        }
        IQ result = this.xmppSession.query(new IQ(AbstractIQ.Type.GET, (Object)rosterRequest));
        Roster rosterResult = (Roster)result.getExtension(Roster.class);
        if (rosterResult != null) {
            roster = rosterResult;
        }
        this.updateRoster(roster, false);
        return roster;
    }

    public final void addContact(Contact contact, boolean requestSubscription, String status) throws XmppException {
        Objects.requireNonNull(contact, "contact must not be null.");
        this.xmppSession.query(new IQ(AbstractIQ.Type.SET, (Object)new Roster(new Contact[]{contact})));
        if (requestSubscription) {
            this.xmppSession.getManager(PresenceManager.class).requestSubscription(contact.getJid(), status);
        }
    }

    public final void updateContact(Contact contact) throws XmppException {
        this.addContact(contact, false, null);
    }

    public final void removeContact(Jid jid) throws XmppException {
        Roster roster = new Roster(new Contact[]{new Contact(jid, null, null, null, Contact.Subscription.REMOVE, Collections.emptyList())});
        this.xmppSession.query(new IQ(AbstractIQ.Type.SET, (Object)roster));
    }

    public final void renameContactGroup(ContactGroup contactGroup, String name) throws XmppException {
        int depth = -1;
        ContactGroup parentGroup = contactGroup;
        do {
            parentGroup = parentGroup.getParentGroup();
            ++depth;
        } while (parentGroup != null);
        this.replaceGroupName(contactGroup, name, depth);
    }

    private synchronized void replaceGroupName(ContactGroup contactGroup, String name, int index) throws XmppException {
        String newName = name;
        if (this.groupDelimiter != null && !this.groupDelimiter.isEmpty()) {
            String[] groups = contactGroup.getFullName().split(this.groupDelimiter);
            if (index < groups.length) {
                groups[index] = name;
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < groups.length - 1; ++i) {
                sb.append(groups[i]);
                sb.append(this.groupDelimiter);
            }
            sb.append(groups[groups.length - 1]);
            newName = sb.toString();
        }
        for (Contact contact : contactGroup.getContacts()) {
            ArrayList<String> newGroups = new ArrayList<String>(contact.getGroups());
            newGroups.remove(contactGroup.getFullName());
            newGroups.add(newName);
            if (contact.getGroups().equals(newGroups)) continue;
            this.updateContact(new Contact(contact.getJid(), contact.getName(), newGroups));
        }
        for (ContactGroup subGroup : contactGroup.getGroups()) {
            this.replaceGroupName(subGroup, name, index);
        }
    }

    public final void removeContactGroup(ContactGroup contactGroup) throws XmppException {
        Collection<Contact> allContacts = RosterManager.collectAllContactsInGroup(contactGroup);
        if (contactGroup.getParentGroup() != null) {
            for (Contact contact : allContacts) {
                this.updateContact(new Contact(contact.getJid(), contact.getName(), new String[]{contactGroup.getParentGroup().getFullName()}));
            }
        } else {
            for (Contact contact : allContacts) {
                this.updateContact(new Contact(contact.getJid(), contact.getName()));
            }
        }
    }

    public final synchronized String getGroupDelimiter() {
        return this.groupDelimiter;
    }

    public final synchronized void setGroupDelimiter(String groupDelimiter) {
        this.groupDelimiter = groupDelimiter;
    }

    public final synchronized void storeGroupDelimiter(String groupDelimiter) throws XmppException {
        this.privateDataManager.storeData(new RosterDelimiter(groupDelimiter));
        this.setGroupDelimiter(groupDelimiter);
    }

    public synchronized boolean isAskForGroupDelimiter() {
        return this.askForGroupDelimiter;
    }

    public synchronized void setAskForGroupDelimiter(boolean askForGroupDelimiter) {
        this.askForGroupDelimiter = askForGroupDelimiter;
    }

    public boolean isRosterVersioningSupported() {
        return this.xmppSession.getManager(StreamFeaturesManager.class).getFeatures().containsKey(RosterVersioning.class);
    }
}

