/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.session;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.context.CoreContext;
import rocks.xmpp.core.session.debug.XmppDebugger;

public final class XmppSessionConfiguration {
    private static final Path DEFAULT_APPLICATION_DATA_PATH;
    private static volatile XmppSessionConfiguration defaultConfiguration;
    private final Collection<Class<? extends Manager>> initialExtensionManagers = new ArrayList<Class<? extends Manager>>();
    private final JAXBContext jaxbContext;
    private final Class<? extends XmppDebugger> xmppDebugger;
    private final int defaultResponseTimeout;
    private final List<String> authenticationMechanisms;
    private final Path cacheDirectory;

    private XmppSessionConfiguration(Builder builder) {
        this.xmppDebugger = builder.xmppDebugger;
        this.defaultResponseTimeout = builder.defaultResponseTimeout;
        this.authenticationMechanisms = builder.authenticationMechanisms;
        this.cacheDirectory = builder.cacheDirectory;
        CoreContext context = builder.context;
        if (context == null) {
            try {
                Class<?> extensionContext = Class.forName(CoreContext.class.getPackage().getName() + ".extensions.ExtensionContext");
                context = (CoreContext)extensionContext.newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                context = new CoreContext(new Class[0]);
            }
        }
        this.initialExtensionManagers.addAll(context.getManagers());
        Class[] classesToBeBound = new Class[context.getExtensions().size()];
        context.getExtensions().toArray(classesToBeBound);
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])classesToBeBound);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static XmppSessionConfiguration getDefault() {
        if (defaultConfiguration != null) return defaultConfiguration;
        Class<XmppSessionConfiguration> clazz = XmppSessionConfiguration.class;
        synchronized (XmppSessionConfiguration.class) {
            if (defaultConfiguration != null) return defaultConfiguration;
            defaultConfiguration = XmppSessionConfiguration.builder().build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultConfiguration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefault(XmppSessionConfiguration configuration) {
        Class<XmppSessionConfiguration> clazz = XmppSessionConfiguration.class;
        synchronized (XmppSessionConfiguration.class) {
            defaultConfiguration = configuration;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    JAXBContext getJAXBContext() {
        return this.jaxbContext;
    }

    Collection<Class<? extends Manager>> getInitialManagers() {
        return this.initialExtensionManagers;
    }

    public final Class<? extends XmppDebugger> getDebugger() {
        return this.xmppDebugger;
    }

    public final int getDefaultResponseTimeout() {
        return this.defaultResponseTimeout;
    }

    public final List<String> getAuthenticationMechanisms() {
        return Collections.unmodifiableList(this.authenticationMechanisms);
    }

    public final Path getCacheDirectory() {
        return this.cacheDirectory;
    }

    static {
        Path path;
        String appName = "xmpp.rocks";
        try {
            String appData = System.getenv("APPDATA");
            if (appData != null) {
                path = Paths.get(appData, new String[0]);
            } else {
                appData = System.getProperty("user.home");
                path = Paths.get(appData, "Library", "Application Support");
                if (!Files.exists(path, new LinkOption[0])) {
                    path = Paths.get(appData, new String[0]);
                }
            }
            path = path.resolve(appName);
        }
        catch (Exception e) {
            path = Paths.get(appName, new String[0]);
        }
        DEFAULT_APPLICATION_DATA_PATH = path;
    }

    public static final class Builder {
        private Class<? extends XmppDebugger> xmppDebugger;
        private CoreContext context;
        private int defaultResponseTimeout;
        private Path cacheDirectory;
        private List<String> authenticationMechanisms = Arrays.asList("SCRAM-SHA-1", "DIGEST-MD5", "GSSAPI", "CRAM-MD5", "PLAIN", "ANONYMOUS");

        private Builder() {
            this.defaultResponseTimeout(5000).cacheDirectory(DEFAULT_APPLICATION_DATA_PATH);
        }

        public final Builder debugger(Class<? extends XmppDebugger> xmppDebugger) {
            this.xmppDebugger = xmppDebugger;
            return this;
        }

        public final Builder context(CoreContext context) {
            this.context = context;
            return this;
        }

        public final Builder defaultResponseTimeout(int defaultResponseTimeout) {
            this.defaultResponseTimeout = defaultResponseTimeout;
            return this;
        }

        public final Builder authenticationMechanisms(String ... authenticationMechanisms) {
            this.authenticationMechanisms = Arrays.asList(authenticationMechanisms);
            return this;
        }

        public final Builder cacheDirectory(Path path) {
            if (path != null && Files.exists(path, new LinkOption[0]) && !Files.isDirectory(path, new LinkOption[0])) {
                throw new IllegalArgumentException("path is not a directory.");
            }
            this.cacheDirectory = path;
            return this;
        }

        public final XmppSessionConfiguration build() {
            return new XmppSessionConfiguration(this);
        }
    }
}

