/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.session;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import rocks.xmpp.core.XmppUtils;
import rocks.xmpp.core.session.TcpConnection;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.session.debug.XmppDebugger;
import rocks.xmpp.core.stream.StreamErrorException;
import rocks.xmpp.core.stream.model.StreamError;
import rocks.xmpp.core.stream.model.errors.Condition;
import rocks.xmpp.core.stream.model.errors.Text;

final class XmppStreamReader {
    private final TcpConnection connection;
    private final XmppSession xmppSession;
    private final ExecutorService executorService;
    private final XMLInputFactory xmlInputFactory;
    private final XMLOutputFactory xmlOutputFactory;
    private final XmppDebugger debugger;
    private final Marshaller marshaller;
    private final Unmarshaller unmarshaller;

    public XmppStreamReader(TcpConnection connection, XmppSession xmppSession, XMLOutputFactory xmlOutputFactory) {
        this.connection = connection;
        this.xmppSession = xmppSession;
        this.debugger = xmppSession.getDebugger();
        this.marshaller = xmppSession.createMarshaller();
        this.unmarshaller = xmppSession.createUnmarshaller();
        this.executorService = Executors.newSingleThreadExecutor(XmppUtils.createNamedThreadFactory((String)"XMPP Reader Thread"));
        this.xmlInputFactory = XMLInputFactory.newFactory();
        this.xmlOutputFactory = xmlOutputFactory;
    }

    synchronized void startReading(final InputStream inputStream) {
        if (!this.executorService.isShutdown()) {
            this.executorService.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    boolean doRestart = false;
                    XMLEventReader xmlEventReader = null;
                    try {
                        InputStream xmppInputStream;
                        ByteArrayOutputStream byteArrayOutputStream = null;
                        if (XmppStreamReader.this.debugger != null) {
                            byteArrayOutputStream = new ByteArrayOutputStream();
                            xmppInputStream = XmppStreamReader.this.debugger.createInputStream(XmppUtils.createBranchedInputStream((InputStream)inputStream, (OutputStream)byteArrayOutputStream));
                        } else {
                            xmppInputStream = inputStream;
                        }
                        xmlEventReader = XmppStreamReader.this.xmlInputFactory.createXMLEventReader(xmppInputStream, "UTF-8");
                        boolean isFirstPass = true;
                        while (!doRestart && xmlEventReader.hasNext()) {
                            XMLEvent xmlEvent = xmlEventReader.peek();
                            if (xmlEvent.isStartElement()) {
                                StartElement startElement = xmlEvent.asStartElement();
                                if (startElement.getName().getLocalPart().equals("stream") && startElement.getName().getNamespaceURI().equals("http://etherx.jabber.org/streams")) {
                                    Attribute fromAttribute;
                                    Attribute idAttribute = startElement.getAttributeByName(new QName("id"));
                                    if (idAttribute != null) {
                                        TcpConnection tcpConnection = XmppStreamReader.this.connection;
                                        synchronized (tcpConnection) {
                                            ((XmppStreamReader)XmppStreamReader.this).connection.streamId = idAttribute.getValue();
                                        }
                                    }
                                    if ((fromAttribute = startElement.getAttributeByName(new QName("from"))) != null) {
                                        XmppStreamReader.this.xmppSession.setXmppServiceDomain(fromAttribute.getValue());
                                    }
                                    xmlEventReader.next();
                                } else {
                                    Object object = XmppStreamReader.this.unmarshaller.unmarshal(xmlEventReader);
                                    if (XmppStreamReader.this.debugger != null) {
                                        if (isFirstPass && byteArrayOutputStream != null) {
                                            XmppStreamReader.this.debugger.readStanza(byteArrayOutputStream.toString(), object);
                                        } else {
                                            StringWriter stringWriter = new StringWriter();
                                            XMLStreamWriter xmlStreamWriter = XmppUtils.createXmppStreamWriter((XMLStreamWriter)XmppStreamReader.this.xmlOutputFactory.createXMLStreamWriter(stringWriter), (boolean)true);
                                            XmppStreamReader.this.marshaller.marshal(object, xmlStreamWriter);
                                            XmppStreamReader.this.debugger.readStanza(stringWriter.toString(), object);
                                        }
                                    }
                                    isFirstPass = false;
                                    doRestart = XmppStreamReader.this.xmppSession.handleElement(object);
                                }
                            } else {
                                xmlEventReader.next();
                            }
                            if (!isFirstPass && byteArrayOutputStream != null) {
                                byteArrayOutputStream.reset();
                            }
                            if (xmlEvent.getEventType() != 2 || XmppStreamReader.this.debugger == null) continue;
                            QName qName = xmlEvent.asEndElement().getName();
                            XmppStreamReader.this.debugger.readStanza("</" + qName.getPrefix() + ":" + qName.getLocalPart() + ">", null);
                        }
                        xmlEventReader.close();
                        if (!doRestart && XmppStreamReader.this.xmppSession.getStatus() != XmppSession.Status.CLOSING) {
                            throw new StreamErrorException(new StreamError(Condition.UNDEFINED_CONDITION, new Text("Stream closed by server", "en"), null));
                        }
                    }
                    catch (Exception e) {
                        XmppStreamReader xmppStreamReader = XmppStreamReader.this;
                        synchronized (xmppStreamReader) {
                            if (!XmppStreamReader.this.executorService.isShutdown()) {
                                XmppStreamReader.this.executorService.shutdown();
                            }
                        }
                        XmppStreamReader.this.xmppSession.notifyException(e);
                    }
                    finally {
                        if (xmlEventReader != null) {
                            try {
                                xmlEventReader.close();
                            }
                            catch (XMLStreamException e) {
                                XmppStreamReader.this.xmppSession.notifyException(e);
                            }
                        }
                        if (doRestart) {
                            XmppStreamReader.this.connection.restartStream();
                        }
                    }
                }
            });
        }
    }

    synchronized void shutdown() {
        if (!this.executorService.isShutdown()) {
            this.executorService.shutdown();
            try {
                this.executorService.awaitTermination(250L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

