/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.stream;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.NoResponseException;
import rocks.xmpp.core.session.SessionStatusEvent;
import rocks.xmpp.core.session.SessionStatusListener;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stream.StreamFeatureNegotiator;
import rocks.xmpp.core.stream.StreamNegotiationException;
import rocks.xmpp.core.stream.model.StreamFeature;
import rocks.xmpp.core.stream.model.StreamFeatures;
import rocks.xmpp.core.tls.model.StartTls;

public final class StreamFeaturesManager
extends Manager {
    private final Lock lock = new ReentrantLock();
    private final Map<Class<? extends StreamFeature>, Condition> featureNegotiationStartedConditions = new ConcurrentHashMap<Class<? extends StreamFeature>, Condition>();
    private final Map<Class<? extends StreamFeature>, StreamFeature> advertisedFeatures = new HashMap<Class<? extends StreamFeature>, StreamFeature>();
    private final List<StreamFeature> featuresToNegotiate = new ArrayList<StreamFeature>();
    private final Set<Class<? extends StreamFeature>> negotiatedFeatures = new HashSet<Class<? extends StreamFeature>>();
    private final Set<StreamFeatureNegotiator> streamFeatureNegotiators = new CopyOnWriteArraySet<StreamFeatureNegotiator>();
    private final Condition negotiationCompleted = this.lock.newCondition();
    private final XmppSession xmppSession;

    private StreamFeaturesManager(XmppSession xmppSession) {
        this.xmppSession = xmppSession;
    }

    @Override
    protected final void initialize() {
        this.xmppSession.addSessionStatusListener(new SessionStatusListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sessionStatusChanged(SessionStatusEvent e) {
                switch (e.getStatus()) {
                    case CONNECTING: {
                        1 var2_2 = this;
                        synchronized (var2_2) {
                            StreamFeaturesManager.this.featureNegotiationStartedConditions.clear();
                            StreamFeaturesManager.this.advertisedFeatures.clear();
                            StreamFeaturesManager.this.negotiatedFeatures.clear();
                            break;
                        }
                    }
                    case CLOSED: {
                        1 var2_3 = this;
                        synchronized (var2_3) {
                            StreamFeaturesManager.this.featureNegotiationStartedConditions.clear();
                            StreamFeaturesManager.this.advertisedFeatures.clear();
                            StreamFeaturesManager.this.featuresToNegotiate.clear();
                            StreamFeaturesManager.this.negotiatedFeatures.clear();
                            StreamFeaturesManager.this.streamFeatureNegotiators.clear();
                            break;
                        }
                    }
                }
            }
        });
    }

    public final Map<Class<? extends StreamFeature>, StreamFeature> getFeatures() {
        return Collections.unmodifiableMap(new HashMap<Class<? extends StreamFeature>, StreamFeature>(this.advertisedFeatures));
    }

    public final void addFeatureNegotiator(StreamFeatureNegotiator streamFeatureNegotiator) {
        this.streamFeatureNegotiators.add(streamFeatureNegotiator);
    }

    public final synchronized void processFeatures(StreamFeatures featuresElement) throws StreamNegotiationException {
        List featureList = featuresElement.getFeatures();
        ArrayList<StreamFeature> sortedFeatureList = new ArrayList<StreamFeature>();
        this.featuresToNegotiate.clear();
        for (Object feature : featureList) {
            if (!(feature instanceof StreamFeature)) continue;
            StreamFeature f = (StreamFeature)feature;
            this.advertisedFeatures.put(f.getClass(), f);
            sortedFeatureList.add(f);
        }
        if (featureList.size() == 1 && featureList.get(0) instanceof StartTls) {
            ((StartTls)featureList.get(0)).setMandatory(true);
        }
        Collections.sort(sortedFeatureList);
        this.featuresToNegotiate.addAll(sortedFeatureList);
        this.negotiateNextFeature();
    }

    public final synchronized boolean processElement(Object element) throws StreamNegotiationException {
        for (StreamFeatureNegotiator streamFeatureNegotiator : this.streamFeatureNegotiators) {
            if (streamFeatureNegotiator.getFeatureClass() != element && !streamFeatureNegotiator.canProcess(element)) continue;
            StreamFeatureNegotiator.Status status = streamFeatureNegotiator.processNegotiation(element);
            if (!EnumSet.of(StreamFeatureNegotiator.Status.SUCCESS, StreamFeatureNegotiator.Status.IGNORE).contains((Object)status)) continue;
            this.negotiatedFeatures.add(streamFeatureNegotiator.getFeatureClass());
            if (status == StreamFeatureNegotiator.Status.SUCCESS && streamFeatureNegotiator.needsRestart()) {
                return true;
            }
            this.negotiateNextFeature();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean negotiateNextFeature() throws StreamNegotiationException {
        if (!this.featuresToNegotiate.isEmpty()) {
            StreamFeature advertisedFeature = this.featuresToNegotiate.remove(0);
            if (!this.negotiatedFeatures.contains(advertisedFeature.getClass())) {
                Condition condition;
                StreamFeatureNegotiator.Status negotiationStatus = StreamFeatureNegotiator.Status.IGNORE;
                for (StreamFeatureNegotiator streamFeatureNegotiator : this.streamFeatureNegotiators) {
                    if (streamFeatureNegotiator.getFeatureClass() != advertisedFeature.getClass()) continue;
                    negotiationStatus = streamFeatureNegotiator.processNegotiation(advertisedFeature);
                    break;
                }
                if (EnumSet.of(StreamFeatureNegotiator.Status.SUCCESS, StreamFeatureNegotiator.Status.IGNORE).contains((Object)negotiationStatus)) {
                    this.negotiatedFeatures.add(advertisedFeature.getClass());
                }
                if ((condition = this.featureNegotiationStartedConditions.remove(advertisedFeature.getClass())) != null) {
                    this.lock.lock();
                    try {
                        condition.signalAll();
                    }
                    finally {
                        this.lock.unlock();
                    }
                }
                if (negotiationStatus == StreamFeatureNegotiator.Status.INCOMPLETE) {
                    return true;
                }
            }
            return this.negotiateNextFeature();
        }
        this.lock.lock();
        try {
            this.negotiationCompleted.signalAll();
        }
        finally {
            this.lock.unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void awaitNegotiation(Class<? extends StreamFeature> streamFeature, long timeout) throws InterruptedException, NoResponseException {
        StreamFeaturesManager streamFeaturesManager = this;
        synchronized (streamFeaturesManager) {
            if (this.negotiatedFeatures.contains(streamFeature) || this.featureNegotiationStartedConditions.containsKey(streamFeature)) {
                return;
            }
        }
        Condition condition = this.lock.newCondition();
        this.featureNegotiationStartedConditions.put(streamFeature, condition);
        this.lock.lock();
        try {
            if (!condition.await(timeout, TimeUnit.MILLISECONDS)) {
                throw new NoResponseException("No response while waiting on feature: " + streamFeature.getSimpleName());
            }
        }
        catch (InterruptedException e) {
            this.featureNegotiationStartedConditions.remove(streamFeature);
            throw e;
        }
        finally {
            this.lock.unlock();
        }
    }

    public final void completeNegotiation(long timeout) throws InterruptedException, NoResponseException, StreamNegotiationException {
        if (!this.negotiateNextFeature()) {
            return;
        }
        this.lock.lock();
        try {
            if (!this.negotiationCompleted.await(timeout, TimeUnit.MILLISECONDS)) {
                throw new NoResponseException("No response while waiting during stream feature negotiation.");
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void cancelNegotiation() {
        for (Condition condition : this.featureNegotiationStartedConditions.values()) {
            this.lock.lock();
            try {
                condition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
        this.featureNegotiationStartedConditions.clear();
    }
}

