/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.subscription;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.SessionStatusEvent;
import rocks.xmpp.core.session.SessionStatusListener;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.PresenceEvent;
import rocks.xmpp.core.stanza.PresenceListener;
import rocks.xmpp.core.stanza.model.AbstractPresence;
import rocks.xmpp.core.stanza.model.client.Presence;
import rocks.xmpp.core.stream.model.ClientStreamElement;

public final class PresenceManager
extends Manager {
    private static final Logger logger = Logger.getLogger(PresenceManager.class.getName());
    private final XmppSession xmppSession;
    private final ConcurrentHashMap<Jid, Map<String, Presence>> presenceMap = new ConcurrentHashMap();
    private final Map<String, Presence> lastSentPresences = new ConcurrentHashMap<String, Presence>();

    private PresenceManager(XmppSession xmppSession) {
        this.xmppSession = xmppSession;
    }

    @Override
    protected final void initialize() {
        this.xmppSession.addInboundPresenceListener(new PresenceListener(){

            @Override
            public void handlePresence(PresenceEvent e) {
                Presence presence = e.getPresence();
                if (presence.getFrom() != null) {
                    PresenceManager.this.presenceMap.putIfAbsent(presence.getFrom().asBareJid(), new ConcurrentHashMap());
                    Map presencesPerResource = (Map)PresenceManager.this.presenceMap.get(presence.getFrom().asBareJid());
                    presencesPerResource.put(presence.getFrom().getResource() != null ? presence.getFrom().getResource() : "", presence);
                }
            }
        });
        this.xmppSession.addOutboundPresenceListener(new PresenceListener(){

            @Override
            public void handlePresence(PresenceEvent e) {
                Presence presence = e.getPresence();
                if (presence.getType() == null || presence.getType() == AbstractPresence.Type.UNAVAILABLE) {
                    if (presence.getTo() == null) {
                        PresenceManager.this.lastSentPresences.put("", presence);
                    } else {
                        PresenceManager.this.lastSentPresences.put(presence.getTo().toString(), presence);
                    }
                }
            }
        });
        this.xmppSession.addSessionStatusListener(new SessionStatusListener(){

            @Override
            public void sessionStatusChanged(SessionStatusEvent e) {
                if (e.getStatus() == XmppSession.Status.DISCONNECTED) {
                    for (Jid contact : PresenceManager.this.presenceMap.keySet()) {
                        try {
                            PresenceManager.this.xmppSession.handleElement(new Presence(AbstractPresence.Type.UNAVAILABLE).withFrom(contact));
                        }
                        catch (Exception e1) {
                            logger.log(Level.WARNING, e1.getMessage(), e1);
                        }
                    }
                }
            }
        });
    }

    public final Presence getPresence(Jid jid) {
        if (Objects.requireNonNull(jid, "jid must not be null.").isBareJid()) {
            ArrayList<Presence> presences;
            Map<String, Presence> presencesPerResource = this.presenceMap.get(jid);
            if (presencesPerResource != null && !(presences = new ArrayList<Presence>(presencesPerResource.values())).isEmpty()) {
                Collections.sort(presences);
                return (Presence)presences.get(0);
            }
        } else {
            Presence presence;
            Map<String, Presence> presencesPerResource = this.presenceMap.get(jid.asBareJid());
            if (presencesPerResource != null && (presence = presencesPerResource.get(jid.getResource())) != null) {
                return presence;
            }
        }
        return new Presence(AbstractPresence.Type.UNAVAILABLE).withFrom(jid);
    }

    public final String requestSubscription(Jid jid, String status) {
        Presence presence = new Presence(jid.asBareJid(), AbstractPresence.Type.SUBSCRIBE, status, UUID.randomUUID().toString());
        this.xmppSession.send((ClientStreamElement)presence);
        return presence.getId();
    }

    public final String approveSubscription(Jid jid) {
        Presence presence = new Presence(jid, AbstractPresence.Type.SUBSCRIBED, null, UUID.randomUUID().toString());
        this.xmppSession.send((ClientStreamElement)presence);
        return presence.getId();
    }

    public final String denySubscription(Jid jid) {
        Presence presence = new Presence(jid, AbstractPresence.Type.UNSUBSCRIBED, null, UUID.randomUUID().toString());
        this.xmppSession.send((ClientStreamElement)presence);
        return presence.getId();
    }

    public final String unsubscribe(Jid jid) {
        Presence presence = new Presence(jid, AbstractPresence.Type.UNSUBSCRIBE, null, UUID.randomUUID().toString());
        this.xmppSession.send((ClientStreamElement)presence);
        return presence.getId();
    }

    public final Presence getLastSentPresence() {
        return this.lastSentPresences.get("");
    }

    public final Collection<Presence> getLastSentPresences() {
        return this.lastSentPresences.values();
    }
}

