/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.httpbind;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.net.ssl.HttpsURLConnection;
import javax.xml.bind.JAXBElement;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.XMLEvent;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.XmppUtils;
import rocks.xmpp.core.session.Connection;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.session.debug.XmppDebugger;
import rocks.xmpp.core.stanza.model.Stanza;
import rocks.xmpp.core.stream.model.ClientStreamElement;
import rocks.xmpp.extensions.compress.CompressionMethod;
import rocks.xmpp.extensions.httpbind.BoshConnectionConfiguration;
import rocks.xmpp.extensions.httpbind.BoshException;
import rocks.xmpp.extensions.httpbind.model.Body;

public final class BoshConnection
extends Connection {
    final Map<Long, Body> unacknowledgedRequests = new ConcurrentSkipListMap<Long, Body>();
    private final AtomicLong rid = new AtomicLong();
    private final XMLOutputFactory xmlOutputFactory;
    private final XMLInputFactory xmlInputFactory;
    private final BoshConnectionConfiguration boshConnectionConfiguration;
    private final XmppDebugger debugger;
    private final Deque<String> keySequence = new ArrayDeque<String>();
    private final AtomicInteger requestCount = new AtomicInteger();
    private final Map<String, CompressionMethod> compressionMethods;
    private final String clientAcceptEncoding;
    private ExecutorService httpBindExecutor;
    private CompressionMethod requestCompressionMethod;
    private String requestContentEncoding;
    private long highestReceivedRid;
    private String sessionId;
    private String authId;
    private boolean usingAcknowledgments;
    private URL url;

    BoshConnection(XmppSession xmppSession, BoshConnectionConfiguration configuration) {
        super(xmppSession, configuration);
        this.boshConnectionConfiguration = configuration;
        this.debugger = this.getXmppSession().getDebugger();
        this.xmlOutputFactory = XMLOutputFactory.newFactory();
        this.xmlInputFactory = XMLInputFactory.newFactory();
        this.compressionMethods = new LinkedHashMap<String, CompressionMethod>();
        for (CompressionMethod compressionMethod : this.boshConnectionConfiguration.getCompressionMethods()) {
            this.compressionMethods.put(compressionMethod.getName(), compressionMethod);
        }
        if (!this.compressionMethods.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            for (String compressionMethodName : this.compressionMethods.keySet()) {
                sb.append(compressionMethodName);
                if (++i >= this.compressionMethods.size()) continue;
                sb.append(",");
            }
            this.clientAcceptEncoding = sb.toString();
        } else {
            this.clientAcceptEncoding = null;
        }
    }

    private static void handleCode(int httpCode) throws BoshException {
        if (httpCode != 200) {
            switch (httpCode) {
                case 400: {
                    throw new BoshException(Body.Condition.BAD_REQUEST, httpCode);
                }
                case 403: {
                    throw new BoshException(Body.Condition.POLICY_VIOLATION, httpCode);
                }
                case 404: {
                    throw new BoshException(Body.Condition.ITEM_NOT_FOUND, httpCode);
                }
            }
            throw new BoshException(Body.Condition.UNDEFINED_CONDITION, httpCode);
        }
    }

    private static String findBoshUrl(String xmppServiceDomain, long timeout) {
        try {
            String query = "_xmppconnect." + xmppServiceDomain;
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            if (timeout > 0L) {
                env.put("com.sun.jndi.dns.timeout.initial", String.valueOf(timeout));
            }
            InitialDirContext ctx = new InitialDirContext(env);
            Attributes attributes = ctx.getAttributes(query, new String[]{"TXT"});
            Attribute srvAttribute = attributes.get("TXT");
            if (srvAttribute != null) {
                NamingEnumeration<?> enumeration = srvAttribute.getAll();
                while (enumeration.hasMore()) {
                    String txtRecord = (String)enumeration.next();
                    String[] txtRecordParts = txtRecord.split("=");
                    String key = txtRecordParts[0];
                    String value = txtRecordParts[1];
                    if (!"_xmpp-client-xbosh".equals(key)) continue;
                    return value;
                }
            }
        }
        catch (NamingException e) {
            return null;
        }
        return null;
    }

    private void generateKeySequence() {
        this.keySequence.clear();
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            SecureRandom random = new SecureRandom();
            int n = 256 + random.nextInt(32512);
            String kn = UUID.randomUUID().toString();
            for (int i = 0; i < n; ++i) {
                kn = String.format("%040x", new BigInteger(1, digest.digest(kn.getBytes())));
                this.keySequence.add(kn);
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Deprecated
    public final void connect() throws IOException {
        this.connect(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized void connect(Jid from) throws IOException {
        if (this.sessionId != null) {
            return;
        }
        if (this.getXmppSession() == null) {
            throw new IllegalStateException("Can't connect without XmppSession. Use XmppSession to connect.");
        }
        if (this.url == null) {
            int targetPort;
            String protocol;
            String string = protocol = this.boshConnectionConfiguration.isSecure() ? "https" : "http";
            int n = this.getPort() > 0 ? this.getPort() : (targetPort = this.boshConnectionConfiguration.isSecure() ? 5281 : 5280);
            if (this.getHostname() != null) {
                this.url = new URL(protocol, this.getHostname(), targetPort, this.boshConnectionConfiguration.getFile());
            } else if (this.getXmppSession().getDomain() != null) {
                String resolvedUrl = BoshConnection.findBoshUrl(this.getXmppSession().getDomain(), this.boshConnectionConfiguration.getConnectTimeout());
                this.url = resolvedUrl != null ? new URL(resolvedUrl) : new URL(protocol, this.getXmppSession().getDomain(), targetPort, this.boshConnectionConfiguration.getFile());
                this.port = this.url.getPort() > 0 ? this.url.getPort() : this.url.getDefaultPort();
                this.hostname = this.url.getHost();
            } else {
                throw new IllegalStateException("Neither an URL nor a domain given for a BOSH connection.");
            }
        }
        this.from = from;
        this.sessionId = null;
        this.authId = null;
        this.requestCount.set(0);
        this.rid.set(new BigInteger(52, new Random()).longValue());
        Body.Builder body = Body.builder().requestId(this.rid.getAndIncrement()).language(Locale.getDefault().getLanguage()).version("1.11").wait(this.boshConnectionConfiguration.getWait()).hold((byte)1).route(this.boshConnectionConfiguration.getRoute()).ack(1L).from(from).xmppVersion("1.0");
        if (this.boshConnectionConfiguration.isUseKeySequence()) {
            Deque<String> targetPort = this.keySequence;
            synchronized (targetPort) {
                this.generateKeySequence();
                body.newKey(this.keySequence.removeLast());
            }
        }
        if (this.getXmppSession().getDomain() != null && !this.getXmppSession().getDomain().isEmpty()) {
            body.to(this.getXmppSession().getDomain());
        }
        HttpURLConnection connection = null;
        try {
            connection = this.getConnection();
            connection.setConnectTimeout(this.boshConnectionConfiguration.getConnectTimeout());
            connection.setReadTimeout(this.boshConnectionConfiguration.getConnectTimeout());
            connection.connect();
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        this.httpBindExecutor = Executors.newFixedThreadPool(2, XmppUtils.createNamedThreadFactory((String)"XMPP BOSH Request Thread"));
        this.sendNewRequest(body.build());
    }

    @Override
    public final boolean isSecure() {
        return this.boshConnectionConfiguration.isSecure();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpackBody(Body responseBody) throws Exception {
        if (responseBody.getSid() != null) {
            Iterator<Body> iterator = this;
            synchronized (iterator) {
                this.sessionId = responseBody.getSid();
                this.authId = responseBody.getAuthId();
                if (responseBody.getAck() != null) {
                    this.usingAcknowledgments = true;
                }
                if (responseBody.getAccept() != null) {
                    String[] serverAcceptedEncodings;
                    for (String serverAcceptedEncoding : serverAcceptedEncodings = responseBody.getAccept().split(",")) {
                        this.requestCompressionMethod = this.compressionMethods.get(serverAcceptedEncoding);
                        this.requestContentEncoding = serverAcceptedEncoding;
                        if (this.requestCompressionMethod != null) break;
                    }
                }
                if (responseBody.getFrom() != null) {
                    this.getXmppSession().setXmppServiceDomain(responseBody.getFrom().getDomain());
                }
            }
        }
        if (responseBody.getAck() != null) {
            this.ackReceived(responseBody.getAck());
        }
        if (responseBody.getType() == Body.Type.TERMINATE && responseBody.getCondition() != null && responseBody.getCondition() != Body.Condition.REMOTE_STREAM_ERROR) {
            throw new BoshException(responseBody.getCondition(), responseBody.getUri());
        }
        if (responseBody.getType() == Body.Type.ERROR) {
            for (Body unacknowledgedRequest : this.unacknowledgedRequests.values()) {
                this.sendNewRequest(unacknowledgedRequest);
            }
        }
        for (Body wrappedObject : responseBody.getWrappedObjects()) {
            if (!this.getXmppSession().handleElement(wrappedObject)) continue;
            this.restartStream();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void restartStream() {
        Body.Builder bodyBuilder;
        BoshConnection boshConnection = this;
        synchronized (boshConnection) {
            bodyBuilder = Body.builder().restart(true).to(this.getXmppSession().getDomain()).language(Locale.getDefault().getLanguage()).sessionId(this.getSessionId()).from(this.from).requestId(this.rid.getAndIncrement());
            this.appendKey(bodyBuilder);
            if (!this.unacknowledgedRequests.isEmpty()) {
                bodyBuilder.ack(this.highestReceivedRid);
            }
        }
        this.sendNewRequest(bodyBuilder.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws Exception {
        if (this.getSessionId() != null) {
            BoshConnection boshConnection = this;
            synchronized (boshConnection) {
                this.sessionId = null;
                this.authId = null;
                this.requestContentEncoding = null;
                this.keySequence.clear();
                this.requestContentEncoding = null;
                if (this.httpBindExecutor != null && !this.httpBindExecutor.isShutdown()) {
                    Body.Builder bodyBuilder = Body.builder().requestId(this.rid.getAndIncrement()).sessionId(this.getSessionId()).type(Body.Type.TERMINATE);
                    this.appendKey(bodyBuilder);
                    this.sendNewRequest(bodyBuilder.build());
                    this.httpBindExecutor.shutdown();
                    this.httpBindExecutor.awaitTermination(500L, TimeUnit.MILLISECONDS);
                    this.httpBindExecutor = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long detach() {
        BoshConnection boshConnection = this;
        synchronized (boshConnection) {
            if (this.httpBindExecutor != null && !this.httpBindExecutor.isShutdown()) {
                this.httpBindExecutor.shutdown();
                this.httpBindExecutor = null;
            }
        }
        return this.rid.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void send(ClientStreamElement element) {
        Body.Builder bodyBuilder = Body.builder().wrappedObjects(Arrays.asList(element)).requestId(this.rid.getAndIncrement()).sessionId(this.getSessionId());
        this.appendKey(bodyBuilder);
        if (!this.unacknowledgedRequests.isEmpty()) {
            BoshConnection boshConnection = this;
            synchronized (boshConnection) {
                bodyBuilder.ack(this.highestReceivedRid);
            }
        }
        this.sendNewRequest(bodyBuilder.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendKey(Body.Builder bodyBuilder) {
        if (this.boshConnectionConfiguration.isUseKeySequence()) {
            Deque<String> deque = this.keySequence;
            synchronized (deque) {
                if (!this.keySequence.isEmpty()) {
                    bodyBuilder.key(this.keySequence.removeLast());
                    if (this.keySequence.isEmpty()) {
                        this.generateKeySequence();
                        bodyBuilder.newKey(this.keySequence.removeLast());
                    }
                }
            }
        }
    }

    public final synchronized String getSessionId() {
        return this.sessionId;
    }

    @Override
    public final synchronized String getStreamId() {
        return this.authId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendNewRequest(final Body body) {
        BoshConnection boshConnection = this;
        synchronized (boshConnection) {
            if (this.httpBindExecutor != null && !this.httpBindExecutor.isShutdown()) {
                this.httpBindExecutor.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block37: {
                            HttpURLConnection httpConnection = null;
                            try {
                                BoshConnection boshConnection = BoshConnection.this;
                                synchronized (boshConnection) {
                                    BoshConnection.this.requestCount.getAndIncrement();
                                    if (BoshConnection.this.usingAcknowledgments) {
                                        BoshConnection.this.unacknowledgedRequests.put(body.getRid(), body);
                                    }
                                    httpConnection = BoshConnection.this.getConnection();
                                    httpConnection.setRequestProperty("Content-Type", "text/xml; charset=utf-8");
                                    if (BoshConnection.this.clientAcceptEncoding != null) {
                                        httpConnection.setRequestProperty("Accept-Encoding", BoshConnection.this.clientAcceptEncoding);
                                    }
                                    if (BoshConnection.this.requestCompressionMethod != null && BoshConnection.this.requestContentEncoding != null) {
                                        httpConnection.setRequestProperty("Content-Encoding", BoshConnection.this.requestContentEncoding);
                                    }
                                    httpConnection.setDoOutput(true);
                                    httpConnection.setRequestMethod("POST");
                                    httpConnection.setReadTimeout((BoshConnection.this.boshConnectionConfiguration.getWait() + 5) * 1000);
                                    ByteArrayOutputStream byteArrayOutputStreamRequest = new ByteArrayOutputStream();
                                    OutputStream requestStream = BoshConnection.this.requestCompressionMethod != null ? BoshConnection.this.requestCompressionMethod.compress(httpConnection.getOutputStream()) : httpConnection.getOutputStream();
                                    try (XMLStreamWriter xmlStreamWriter = null;){
                                        OutputStream branchedOutputStream = XmppUtils.createBranchedOutputStream((OutputStream)requestStream, (OutputStream)byteArrayOutputStreamRequest);
                                        OutputStream xmppOutputStream = BoshConnection.this.debugger != null ? BoshConnection.this.debugger.createOutputStream(branchedOutputStream) : branchedOutputStream;
                                        xmlStreamWriter = XmppUtils.createXmppStreamWriter((XMLStreamWriter)BoshConnection.this.xmlOutputFactory.createXMLStreamWriter(xmppOutputStream, "UTF-8"), (boolean)true);
                                        BoshConnection.this.getXmppSession().createMarshaller().marshal((Object)body, xmlStreamWriter);
                                        if (BoshConnection.this.debugger != null) {
                                            BoshConnection.this.debugger.writeStanza(byteArrayOutputStreamRequest.toString(), body);
                                        }
                                    }
                                }
                                if (httpConnection.getResponseCode() == 200) {
                                    boshConnection = BoshConnection.this;
                                    synchronized (boshConnection) {
                                        BoshConnection.this.highestReceivedRid = body.getRid();
                                    }
                                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                                    XMLEventReader xmlEventReader = null;
                                    String contentEncoding = httpConnection.getHeaderField("Content-Encoding");
                                    InputStream responseStream = contentEncoding != null ? ((CompressionMethod)BoshConnection.this.compressionMethods.get(contentEncoding)).decompress(httpConnection.getInputStream()) : httpConnection.getInputStream();
                                    InputStream inputStream = XmppUtils.createBranchedInputStream((InputStream)responseStream, (OutputStream)byteArrayOutputStream);
                                    InputStream xmppInputStream = BoshConnection.this.debugger != null ? BoshConnection.this.debugger.createInputStream(inputStream) : inputStream;
                                    try {
                                        xmlEventReader = BoshConnection.this.xmlInputFactory.createXMLEventReader(xmppInputStream, "UTF-8");
                                        while (xmlEventReader.hasNext()) {
                                            XMLEvent xmlEvent = xmlEventReader.peek();
                                            if (xmlEvent.isStartElement()) {
                                                JAXBElement element = BoshConnection.this.getXmppSession().createUnmarshaller().unmarshal(xmlEventReader, Body.class);
                                                if (BoshConnection.this.debugger != null) {
                                                    BoshConnection.this.debugger.readStanza(byteArrayOutputStream.toString(), element.getValue());
                                                }
                                                BoshConnection.this.unpackBody((Body)element.getValue());
                                                continue;
                                            }
                                            xmlEventReader.next();
                                        }
                                    }
                                    finally {
                                        BoshConnection.this.ackReceived(body.getRid());
                                        if (xmlEventReader != null) {
                                            xmlEventReader.close();
                                        }
                                    }
                                }
                                BoshConnection.handleCode(httpConnection.getResponseCode());
                                Thread.sleep(100L);
                                if (BoshConnection.this.requestCount.decrementAndGet() != 0) break block37;
                                Body.Builder bodyBuilder = Body.builder().requestId(BoshConnection.this.rid.getAndIncrement()).sessionId(BoshConnection.this.getSessionId());
                                BoshConnection.this.appendKey(bodyBuilder);
                                if (!BoshConnection.this.unacknowledgedRequests.isEmpty()) {
                                    BoshConnection boshConnection2 = BoshConnection.this;
                                    synchronized (boshConnection2) {
                                        bodyBuilder.ack(BoshConnection.this.highestReceivedRid);
                                    }
                                }
                                BoshConnection.this.sendNewRequest(bodyBuilder.build());
                            }
                            catch (Exception e) {
                                1 var3_5 = this;
                                synchronized (var3_5) {
                                    if (BoshConnection.this.httpBindExecutor != null && !BoshConnection.this.httpBindExecutor.isShutdown()) {
                                        BoshConnection.this.httpBindExecutor.shutdown();
                                    }
                                }
                                BoshConnection.this.getXmppSession().notifyException(e);
                            }
                            finally {
                                if (httpConnection != null) {
                                    httpConnection.disconnect();
                                }
                            }
                        }
                    }
                });
            }
        }
    }

    private void ackReceived(Long rid) {
        Body body = this.unacknowledgedRequests.remove(rid);
        if (body != null) {
            for (Object object : body.getWrappedObjects()) {
                if (!(object instanceof Stanza)) continue;
            }
        }
    }

    private HttpURLConnection getConnection() throws IOException {
        Proxy proxy = this.getProxy();
        HttpURLConnection httpURLConnection = proxy != null ? (HttpURLConnection)this.url.openConnection(proxy) : (HttpURLConnection)this.url.openConnection();
        if (httpURLConnection instanceof HttpsURLConnection) {
            if (this.boshConnectionConfiguration.getSSLContext() != null) {
                ((HttpsURLConnection)httpURLConnection).setSSLSocketFactory(this.boshConnectionConfiguration.getSSLContext().getSocketFactory());
            }
            if (this.boshConnectionConfiguration.getHostnameVerifier() != null) {
                ((HttpsURLConnection)httpURLConnection).setHostnameVerifier(this.boshConnectionConfiguration.getHostnameVerifier());
            }
        }
        return httpURLConnection;
    }

    public final String getRoute() {
        return this.boshConnectionConfiguration.getRoute();
    }

    public final synchronized String toString() {
        StringBuilder sb = new StringBuilder("BOSH connection");
        if (this.hostname != null) {
            sb.append(String.format(" to %s", this.url));
        }
        if (this.sessionId != null) {
            sb.append(" (").append(this.sessionId).append(")");
        }
        if (this.from != null) {
            sb.append(", from: ").append((CharSequence)this.from);
        }
        return sb.toString();
    }
}

