/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.chat;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.chat.ChatSession;
import rocks.xmpp.core.chat.ChatSessionEvent;
import rocks.xmpp.core.chat.ChatSessionListener;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.SessionStatusEvent;
import rocks.xmpp.core.session.SessionStatusListener;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.MessageEvent;
import rocks.xmpp.core.stanza.MessageListener;
import rocks.xmpp.core.stanza.PresenceEvent;
import rocks.xmpp.core.stanza.PresenceListener;
import rocks.xmpp.core.stanza.model.AbstractMessage;
import rocks.xmpp.core.stanza.model.client.Message;
import rocks.xmpp.core.stanza.model.client.Presence;

public final class ChatManager
extends Manager {
    private static final Logger logger = Logger.getLogger(ChatManager.class.getName());
    private final XmppSession xmppSession;
    private final Map<Jid, Map<String, ChatSession>> chatSessions = new ConcurrentHashMap<Jid, Map<String, ChatSession>>();
    private final Set<ChatSessionListener> chatSessionListeners = new CopyOnWriteArraySet<ChatSessionListener>();

    private ChatManager(XmppSession xmppSession) {
        this.xmppSession = xmppSession;
    }

    @Override
    protected final void initialize() {
        this.xmppSession.addInboundMessageListener(new MessageListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleMessage(MessageEvent e) {
                Message message = e.getMessage();
                if (message.getType() == AbstractMessage.Type.CHAT) {
                    String threadId;
                    Jid chatPartner = e.isInbound() ? message.getFrom() : message.getTo();
                    String string = threadId = message.getThread() != null ? message.getThread() : UUID.randomUUID().toString();
                    if (chatPartner != null) {
                        Map map = ChatManager.this.chatSessions;
                        synchronized (map) {
                            ChatSession chatSession = ChatManager.this.buildChatSession(chatPartner, threadId, ChatManager.this.xmppSession, e.isInbound());
                            if (e.isInbound()) {
                                chatSession.setChatPartner(message.getFrom());
                            }
                            chatSession.notifyInboundMessageListeners(new MessageEvent((Object)chatSession, message, e.isInbound()));
                        }
                    }
                }
            }
        });
        this.xmppSession.addInboundPresenceListener(new PresenceListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handlePresence(PresenceEvent e) {
                Presence presence = e.getPresence();
                Map map = ChatManager.this.chatSessions;
                synchronized (map) {
                    Jid contact = presence.getFrom().asBareJid();
                    if (ChatManager.this.chatSessions.containsKey(contact)) {
                        for (ChatSession chatSession : ((Map)ChatManager.this.chatSessions.get(contact)).values()) {
                            chatSession.setChatPartner(contact);
                        }
                    }
                }
            }
        });
        this.xmppSession.addSessionStatusListener(new SessionStatusListener(){

            @Override
            public void sessionStatusChanged(SessionStatusEvent e) {
                if (e.getStatus() == XmppSession.Status.CLOSED) {
                    ChatManager.this.chatSessionListeners.clear();
                    ChatManager.this.chatSessions.clear();
                }
            }
        });
    }

    public void addChatSessionListener(ChatSessionListener chatSessionListener) {
        this.chatSessionListeners.add(chatSessionListener);
    }

    public void removeChatSessionListener(ChatSessionListener chatSessionListener) {
        this.chatSessionListeners.remove(chatSessionListener);
    }

    private void notifyChatSessionCreated(ChatSession chatSession, boolean createdByInboundMessage) {
        ChatSessionEvent chatSessionEvent = new ChatSessionEvent(this, chatSession, createdByInboundMessage);
        for (ChatSessionListener chatSessionListener : this.chatSessionListeners) {
            try {
                chatSessionListener.chatSessionCreated(chatSessionEvent);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChatSession createChatSession(Jid chatPartner) {
        Map<Jid, Map<String, ChatSession>> map = this.chatSessions;
        synchronized (map) {
            return this.buildChatSession(Objects.requireNonNull(chatPartner, "chatPartner must not be null."), UUID.randomUUID().toString(), this.xmppSession, false);
        }
    }

    private final ChatSession buildChatSession(Jid chatPartner, String threadId, XmppSession xmppSession, boolean inbound) {
        Map<String, ChatSession> chatSessionMap;
        Jid contact = chatPartner.asBareJid();
        if (!this.chatSessions.containsKey(contact)) {
            this.chatSessions.put(contact, new HashMap());
        }
        if (!(chatSessionMap = this.chatSessions.get(contact)).containsKey(threadId)) {
            ChatSession chatSession = new ChatSession(chatPartner, threadId, xmppSession);
            chatSessionMap.put(threadId, chatSession);
            this.notifyChatSessionCreated(chatSession, inbound);
        }
        return chatSessionMap.get(threadId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyChatSession(ChatSession chatSession) {
        Jid user = Objects.requireNonNull(chatSession, "chatSession must not be null.").getChatPartner().asBareJid();
        Map<Jid, Map<String, ChatSession>> map = this.chatSessions;
        synchronized (map) {
            if (this.chatSessions.containsKey(user)) {
                Map<String, ChatSession> chatSessionMap = this.chatSessions.get(user);
                chatSessionMap.remove(chatSession.getThread());
                if (chatSessionMap.isEmpty()) {
                    this.chatSessions.remove(user);
                }
            }
        }
    }
}

