/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.session;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.extensions.disco.ServiceDiscoveryManager;
import rocks.xmpp.extensions.disco.model.info.Feature;

public abstract class ExtensionManager
extends Manager {
    protected final XmppSession xmppSession;
    private final Collection<String> features;
    private final ServiceDiscoveryManager serviceDiscoveryManager;

    protected ExtensionManager(XmppSession xmppSession, String ... features) {
        this(xmppSession, Arrays.asList(features));
    }

    protected ExtensionManager(XmppSession xmppSession, Collection<String> features) {
        this.xmppSession = xmppSession;
        this.features = features;
        this.serviceDiscoveryManager = this instanceof ServiceDiscoveryManager ? (ServiceDiscoveryManager)this : xmppSession.getManager(ServiceDiscoveryManager.class);
    }

    @Override
    public final boolean isEnabled() {
        ArrayList<Feature> f = new ArrayList<Feature>();
        for (String namespace : this.features) {
            f.add(new Feature(namespace));
        }
        return this.serviceDiscoveryManager.getFeatures().containsAll(f);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.serviceDiscoveryManager != null) {
            for (String namespace : this.features) {
                if (enabled) {
                    this.serviceDiscoveryManager.addFeature(new Feature(namespace));
                    continue;
                }
                this.serviceDiscoveryManager.removeFeature(new Feature(namespace));
            }
        }
    }
}

