/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.session;

import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.XmppUtils;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.ReconnectionStrategy;
import rocks.xmpp.core.session.SessionStatusEvent;
import rocks.xmpp.core.session.SessionStatusListener;
import rocks.xmpp.core.session.TruncatedBinaryExponentialBackoffStrategy;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stream.StreamErrorException;
import rocks.xmpp.core.stream.model.errors.Condition;

public final class ReconnectionManager
extends Manager {
    private static final Logger logger = Logger.getLogger(ReconnectionManager.class.getName());
    private final ScheduledExecutorService scheduledExecutorService;
    private final XmppSession xmppSession;
    private ReconnectionStrategy reconnectionStrategy;
    private ScheduledFuture<?> scheduledFuture;
    private Date nextReconnectionAttempt;

    private ReconnectionManager(XmppSession xmppSession) {
        this.xmppSession = xmppSession;
        this.reconnectionStrategy = new TruncatedBinaryExponentialBackoffStrategy(60, 5);
        this.setEnabled(true);
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(XmppUtils.createNamedThreadFactory((String)"XMPP Reconnection Thread"));
    }

    @Override
    protected final void initialize() {
        this.xmppSession.addSessionStatusListener(new SessionStatusListener(){

            @Override
            public void sessionStatusChanged(SessionStatusEvent e) {
                switch (e.getStatus()) {
                    case DISCONNECTED: {
                        if (e.getThrowable() instanceof StreamErrorException && ((StreamErrorException)((Object)e.getThrowable())).getStreamError().getCondition() == Condition.CONFLICT || e.getOldStatus() != XmppSession.Status.AUTHENTICATED) break;
                        ReconnectionManager.this.scheduleReconnection(0);
                        break;
                    }
                    case CONNECTED: {
                        ReconnectionManager.this.cancel();
                        break;
                    }
                    case CLOSED: {
                        ReconnectionManager.this.cancel();
                        ReconnectionManager.this.scheduledExecutorService.shutdown();
                    }
                }
            }
        });
    }

    private synchronized void cancel() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
            this.nextReconnectionAttempt = null;
        }
    }

    private synchronized void scheduleReconnection(final int attempt) {
        if (this.isEnabled()) {
            int seconds = this.reconnectionStrategy.getNextReconnectionAttempt(attempt);
            if (attempt == 0) {
                logger.log(Level.FINE, "Disconnect detected. Next reconnection attempt in {0} seconds.", seconds);
            } else {
                logger.log(Level.FINE, "Still disconnected after {0} retries. Next reconnection attempt in {1} seconds.", new Object[]{attempt, seconds});
            }
            this.nextReconnectionAttempt = new Date(System.currentTimeMillis() + (long)(seconds * 1000));
            this.scheduledFuture = this.scheduledExecutorService.schedule(new Runnable(){

                @Override
                public void run() {
                    try {
                        ReconnectionManager.this.xmppSession.connect();
                        logger.log(Level.FINE, "Reconnection successful.");
                    }
                    catch (XmppException e) {
                        logger.log(Level.FINE, "Reconnection failed.", e);
                        ReconnectionManager.this.scheduleReconnection(attempt + 1);
                    }
                }
            }, (long)seconds, TimeUnit.SECONDS);
        }
    }

    public final synchronized ReconnectionStrategy getReconnectionStrategy() {
        return this.reconnectionStrategy;
    }

    public final synchronized void setReconnectionStrategy(ReconnectionStrategy reconnectionStrategy) {
        this.reconnectionStrategy = reconnectionStrategy;
    }

    public final synchronized Date getNextReconnectionAttempt() {
        return this.nextReconnectionAttempt;
    }

    @Override
    public final void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (!enabled) {
            this.cancel();
        }
    }
}

