/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.session;

import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stream.StreamFeatureListener;
import rocks.xmpp.core.stream.StreamFeatureNegotiator;
import rocks.xmpp.core.stream.StreamNegotiationException;
import rocks.xmpp.core.stream.model.ClientStreamElement;
import rocks.xmpp.core.tls.model.Failure;
import rocks.xmpp.core.tls.model.Proceed;
import rocks.xmpp.core.tls.model.StartTls;

final class SecurityManager
extends StreamFeatureNegotiator {
    private final XmppSession xmppSession;
    private final boolean isSecure;

    public SecurityManager(XmppSession xmppSession, StreamFeatureListener streamFeatureListener, boolean isSecure) {
        super(StartTls.class);
        this.isSecure = isSecure;
        this.addFeatureListener(streamFeatureListener);
        this.xmppSession = xmppSession;
    }

    @Override
    public StreamFeatureNegotiator.Status processNegotiation(Object element) throws StreamNegotiationException {
        StreamFeatureNegotiator.Status status = StreamFeatureNegotiator.Status.INCOMPLETE;
        if (element instanceof StartTls) {
            StartTls startTls = (StartTls)element;
            if (startTls.isMandatory() && !this.isSecure) {
                throw new StreamNegotiationException("The server requires TLS, but you disabled it.");
            }
            if (this.isSecure) {
                this.xmppSession.send((ClientStreamElement)new StartTls());
            } else {
                status = StreamFeatureNegotiator.Status.IGNORE;
            }
        } else if (element instanceof Proceed) {
            this.notifyFeatureNegotiated();
            status = StreamFeatureNegotiator.Status.SUCCESS;
        } else if (element instanceof Failure) {
            throw new StreamNegotiationException("Failure during TLS negotiation.");
        }
        return status;
    }

    @Override
    public boolean needsRestart() {
        return true;
    }

    @Override
    public boolean canProcess(Object element) {
        return element instanceof Proceed || element instanceof Failure;
    }
}

