/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.session;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.XmppUtils;
import rocks.xmpp.core.bind.model.Bind;
import rocks.xmpp.core.chat.ChatManager;
import rocks.xmpp.core.roster.RosterManager;
import rocks.xmpp.core.sasl.model.Mechanisms;
import rocks.xmpp.core.session.AuthenticationManager;
import rocks.xmpp.core.session.Connection;
import rocks.xmpp.core.session.ConnectionConfiguration;
import rocks.xmpp.core.session.ConnectionException;
import rocks.xmpp.core.session.ExtensionManager;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.NoResponseException;
import rocks.xmpp.core.session.ReconnectionManager;
import rocks.xmpp.core.session.SessionStatusEvent;
import rocks.xmpp.core.session.SessionStatusListener;
import rocks.xmpp.core.session.TcpConnectionConfiguration;
import rocks.xmpp.core.session.XmppSessionConfiguration;
import rocks.xmpp.core.session.debug.XmppDebugger;
import rocks.xmpp.core.session.model.Session;
import rocks.xmpp.core.stanza.IQEvent;
import rocks.xmpp.core.stanza.IQHandler;
import rocks.xmpp.core.stanza.IQListener;
import rocks.xmpp.core.stanza.MessageEvent;
import rocks.xmpp.core.stanza.MessageListener;
import rocks.xmpp.core.stanza.PresenceEvent;
import rocks.xmpp.core.stanza.PresenceListener;
import rocks.xmpp.core.stanza.StanzaException;
import rocks.xmpp.core.stanza.StanzaFilter;
import rocks.xmpp.core.stanza.model.AbstractIQ;
import rocks.xmpp.core.stanza.model.AbstractMessage;
import rocks.xmpp.core.stanza.model.AbstractPresence;
import rocks.xmpp.core.stanza.model.Stanza;
import rocks.xmpp.core.stanza.model.client.IQ;
import rocks.xmpp.core.stanza.model.client.Message;
import rocks.xmpp.core.stanza.model.client.Presence;
import rocks.xmpp.core.stanza.model.errors.Condition;
import rocks.xmpp.core.stream.StreamErrorException;
import rocks.xmpp.core.stream.StreamFeatureNegotiator;
import rocks.xmpp.core.stream.StreamFeaturesManager;
import rocks.xmpp.core.stream.StreamNegotiationException;
import rocks.xmpp.core.stream.model.ClientStreamElement;
import rocks.xmpp.core.stream.model.StreamError;
import rocks.xmpp.core.stream.model.StreamFeatures;
import rocks.xmpp.core.subscription.PresenceManager;
import rocks.xmpp.extensions.disco.ServiceDiscoveryManager;
import rocks.xmpp.extensions.disco.model.info.Feature;
import rocks.xmpp.extensions.httpbind.BoshConnectionConfiguration;

public class XmppSession
implements AutoCloseable {
    private static final Logger logger = Logger.getLogger(XmppSession.class.getName());
    private final AuthenticationManager authenticationManager;
    private final Set<MessageListener> inboundMessageListeners = new CopyOnWriteArraySet<MessageListener>();
    private final Set<MessageListener> outboundMessageListeners = new CopyOnWriteArraySet<MessageListener>();
    private final Set<PresenceListener> inboundPresenceListeners = new CopyOnWriteArraySet<PresenceListener>();
    private final Set<PresenceListener> outboundPresenceListeners = new CopyOnWriteArraySet<PresenceListener>();
    private final Set<IQListener> inboundIQListeners = new CopyOnWriteArraySet<IQListener>();
    private final Set<IQListener> outboundIQListeners = new CopyOnWriteArraySet<IQListener>();
    private final Map<Class<?>, IQHandler> iqHandlerMap = new HashMap();
    private final Map<Class<?>, Boolean> iqHandlerInvocationModes = new HashMap();
    private final Set<SessionStatusListener> sessionStatusListeners = new CopyOnWriteArraySet<SessionStatusListener>();
    private final Map<Class<? extends Manager>, Manager> instances = new ConcurrentHashMap<Class<? extends Manager>, Manager>();
    private final List<Connection> connections = new ArrayList<Connection>();
    private final XmppSessionConfiguration configuration;
    ExecutorService iqHandlerExecutor;
    ExecutorService stanzaListenerExecutor;
    volatile Jid connectedResource;
    volatile Connection activeConnection;
    private volatile String xmppServiceDomain;
    private Status status = Status.INITIAL;
    private volatile String resource;
    private volatile Throwable exception;
    private volatile Thread shutdownHook;
    private volatile XmppDebugger debugger;
    private volatile boolean wasLoggedIn;
    private volatile String lastAuthorizationId;
    private volatile Collection<String> lastMechanisms;
    private volatile CallbackHandler lastCallbackHandler;
    private volatile boolean anonymous;

    public XmppSession(String xmppServiceDomain, ConnectionConfiguration ... connectionConfigurations) {
        this(xmppServiceDomain, XmppSessionConfiguration.getDefault(), connectionConfigurations);
    }

    public XmppSession(String xmppServiceDomain, XmppSessionConfiguration configuration, ConnectionConfiguration ... connectionConfigurations) {
        this.xmppServiceDomain = xmppServiceDomain;
        this.configuration = configuration;
        this.stanzaListenerExecutor = Executors.newSingleThreadExecutor(XmppUtils.createNamedThreadFactory((String)"Stanza Listener Thread"));
        this.iqHandlerExecutor = Executors.newCachedThreadPool(XmppUtils.createNamedThreadFactory((String)"IQ Handler Thread"));
        this.shutdownHook = new Thread(){

            @Override
            public void run() {
                XmppSession.this.shutdownHook = null;
                try {
                    XmppSession.this.close();
                }
                catch (XmppException e) {
                    logger.log(Level.WARNING, e.getMessage(), e);
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        StreamFeaturesManager streamFeaturesManager = this.getManager(StreamFeaturesManager.class);
        this.authenticationManager = new AuthenticationManager(this);
        streamFeaturesManager.addFeatureNegotiator(this.authenticationManager);
        streamFeaturesManager.addFeatureNegotiator(new StreamFeatureNegotiator(Bind.class){

            @Override
            public StreamFeatureNegotiator.Status processNegotiation(Object element) throws StreamNegotiationException {
                return StreamFeatureNegotiator.Status.INCOMPLETE;
            }

            @Override
            public boolean canProcess(Object element) {
                return false;
            }
        });
        this.getManager(ServiceDiscoveryManager.class).addFeature(new Feature("jid\\20escaping"));
        if (configuration.getDebugger() != null) {
            try {
                this.debugger = configuration.getDebugger().newInstance();
                this.debugger.initialize(this);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
        if (connectionConfigurations.length == 0) {
            this.connections.add(TcpConnectionConfiguration.getDefault().createConnection(this));
            this.connections.add(BoshConnectionConfiguration.getDefault().createConnection(this));
        } else {
            for (ConnectionConfiguration connectionConfiguration : connectionConfigurations) {
                this.connections.add(connectionConfiguration.createConnection(this));
            }
        }
        for (Class<? extends Manager> cls : configuration.getInitialManagers()) {
            this.getManager(cls);
        }
    }

    private static void throwAsXmppExceptionIfNotNull(Throwable e) throws XmppException {
        if (e != null) {
            if (e instanceof XmppException) {
                throw (XmppException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw new XmppException(e);
        }
    }

    public final Connection getActiveConnection() {
        return this.activeConnection;
    }

    public final void setXmppServiceDomain(String xmppServiceDomain) {
        this.xmppServiceDomain = xmppServiceDomain;
    }

    @Deprecated
    public final void addMessageListener(MessageListener messageListener) {
        this.inboundMessageListeners.add(messageListener);
        this.outboundMessageListeners.add(messageListener);
    }

    @Deprecated
    public final void removeMessageListener(MessageListener messageListener) {
        this.inboundMessageListeners.remove(messageListener);
        this.outboundMessageListeners.remove(messageListener);
    }

    public final void addInboundMessageListener(MessageListener messageListener) {
        this.inboundMessageListeners.add(messageListener);
    }

    public final void removeInboundMessageListener(MessageListener messageListener) {
        this.inboundMessageListeners.remove(messageListener);
    }

    public final void addOutboundMessageListener(MessageListener messageListener) {
        this.outboundMessageListeners.add(messageListener);
    }

    public final void removeOutboundMessageListener(MessageListener messageListener) {
        this.outboundMessageListeners.remove(messageListener);
    }

    @Deprecated
    public final void addPresenceListener(PresenceListener presenceListener) {
        this.inboundPresenceListeners.add(presenceListener);
        this.outboundPresenceListeners.add(presenceListener);
    }

    @Deprecated
    public final void removePresenceListener(PresenceListener presenceListener) {
        this.inboundPresenceListeners.remove(presenceListener);
        this.outboundPresenceListeners.remove(presenceListener);
    }

    public final void addInboundPresenceListener(PresenceListener presenceListener) {
        this.inboundPresenceListeners.add(presenceListener);
    }

    public final void removeInboundPresenceListener(PresenceListener presenceListener) {
        this.inboundPresenceListeners.remove(presenceListener);
    }

    public final void addOutboundPresenceListener(PresenceListener presenceListener) {
        this.outboundPresenceListeners.add(presenceListener);
    }

    public final void removeOutboundPresenceListener(PresenceListener presenceListener) {
        this.outboundPresenceListeners.remove(presenceListener);
    }

    @Deprecated
    public final void addIQListener(IQListener iqListener) {
        this.inboundIQListeners.add(iqListener);
        this.outboundIQListeners.add(iqListener);
    }

    @Deprecated
    public final void removeIQListener(IQListener iqListener) {
        this.inboundIQListeners.remove(iqListener);
        this.outboundIQListeners.remove(iqListener);
    }

    public final void addInboundIQListener(IQListener iqListener) {
        this.inboundIQListeners.add(iqListener);
    }

    public final void removeInboundIQListener(IQListener iqListener) {
        this.inboundIQListeners.remove(iqListener);
    }

    public final void addOutboundIQListener(IQListener iqListener) {
        this.outboundIQListeners.add(iqListener);
    }

    public final void removeOutboundIQListener(IQListener iqListener) {
        this.outboundIQListeners.remove(iqListener);
    }

    public final void addIQHandler(Class<?> type, IQHandler iqHandler) {
        this.addIQHandler(type, iqHandler, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addIQHandler(Class<?> type, IQHandler iqHandler, boolean invokeAsync) {
        Map<Class<?>, IQHandler> map = this.iqHandlerMap;
        synchronized (map) {
            this.iqHandlerMap.put(type, iqHandler);
            this.iqHandlerInvocationModes.put(type, invokeAsync);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeIQHandler(Class<?> type) {
        Map<Class<?>, IQHandler> map = this.iqHandlerMap;
        synchronized (map) {
            this.iqHandlerMap.remove(type);
            this.iqHandlerInvocationModes.remove(type);
        }
    }

    public final void addSessionStatusListener(SessionStatusListener sessionStatusListener) {
        this.sessionStatusListeners.add(sessionStatusListener);
    }

    public final void removeSessionStatusListener(SessionStatusListener sessionStatusListener) {
        this.sessionStatusListeners.remove(sessionStatusListener);
    }

    public IQ query(IQ iq) throws XmppException {
        return this.query(iq, this.configuration.getDefaultResponseTimeout());
    }

    public IQ query(final IQ iq, long timeout) throws XmppException {
        if (!iq.isRequest()) {
            throw new IllegalArgumentException("IQ must be of type 'get' or 'set'");
        }
        final IQ[] result = new IQ[1];
        final ReentrantLock queryLock = new ReentrantLock();
        final java.util.concurrent.locks.Condition resultReceived = queryLock.newCondition();
        IQListener listener = new IQListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleIQ(IQEvent e) {
                IQ responseIQ = e.getIQ();
                if (responseIQ.isResponse() && responseIQ.getId() != null && responseIQ.getId().equals(iq.getId())) {
                    queryLock.lock();
                    try {
                        result[0] = responseIQ;
                    }
                    finally {
                        resultReceived.signal();
                        queryLock.unlock();
                    }
                }
            }
        };
        queryLock.lock();
        try {
            this.addInboundIQListener(listener);
            this.send((ClientStreamElement)iq);
            if (!resultReceived.await(timeout, TimeUnit.MILLISECONDS)) {
                throw new NoResponseException("Timeout reached, while waiting on a response.");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new XmppException("Thread is interrupted.", (Throwable)e);
        }
        finally {
            queryLock.unlock();
            this.removeInboundIQListener(listener);
        }
        IQ response = result[0];
        if (response.getType() == AbstractIQ.Type.ERROR) {
            throw new StanzaException((Stanza)response);
        }
        return result[0];
    }

    public final Presence sendAndAwaitPresence(ClientStreamElement stanza, final StanzaFilter<Presence> filter) throws XmppException {
        final Presence[] result = new Presence[1];
        final ReentrantLock presenceLock = new ReentrantLock();
        final java.util.concurrent.locks.Condition resultReceived = presenceLock.newCondition();
        PresenceListener listener = new PresenceListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handlePresence(PresenceEvent e) {
                Presence presence = e.getPresence();
                if (filter.accept(presence)) {
                    presenceLock.lock();
                    try {
                        result[0] = presence;
                    }
                    finally {
                        resultReceived.signal();
                        presenceLock.unlock();
                    }
                }
            }
        };
        presenceLock.lock();
        try {
            this.addInboundPresenceListener(listener);
            this.send(stanza);
            if (!resultReceived.await(this.configuration.getDefaultResponseTimeout(), TimeUnit.MILLISECONDS)) {
                throw new NoResponseException("Timeout reached, while waiting on a response.");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new XmppException("Thread is interrupted.", (Throwable)e);
        }
        finally {
            presenceLock.unlock();
            this.removeInboundPresenceListener(listener);
        }
        Presence response = result[0];
        if (response.getType() == AbstractPresence.Type.ERROR) {
            throw new StanzaException((Stanza)response);
        }
        return result[0];
    }

    public final Message sendAndAwaitMessage(ClientStreamElement stanza, final StanzaFilter<Message> filter) throws XmppException {
        final Message[] result = new Message[1];
        final ReentrantLock messageLock = new ReentrantLock();
        final java.util.concurrent.locks.Condition resultReceived = messageLock.newCondition();
        MessageListener listener = new MessageListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleMessage(MessageEvent e) {
                Message message = e.getMessage();
                if (filter.accept(message)) {
                    messageLock.lock();
                    try {
                        result[0] = message;
                    }
                    finally {
                        resultReceived.signal();
                        messageLock.unlock();
                    }
                }
            }
        };
        messageLock.lock();
        try {
            this.addInboundMessageListener(listener);
            this.send(stanza);
            if (!resultReceived.await(this.configuration.getDefaultResponseTimeout(), TimeUnit.MILLISECONDS)) {
                throw new NoResponseException("Timeout reached, while waiting on a response.");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new XmppException("Thread is interrupted.", (Throwable)e);
        }
        finally {
            messageLock.unlock();
            this.removeInboundMessageListener(listener);
        }
        Message response = result[0];
        if (response.getType() == AbstractMessage.Type.ERROR) {
            throw new StanzaException((Stanza)response);
        }
        return response;
    }

    @Deprecated
    public final void reconnect() throws XmppException {
        this.connect();
    }

    public final void connect() throws XmppException {
        this.connect(null);
    }

    public final void connect(Jid from) throws XmppException {
        Status previousStatus = this.getStatus();
        if (previousStatus == Status.CLOSED) {
            throw new IllegalStateException("Session is already closed. Create a new one.");
        }
        if (this.isConnected() || !this.updateStatus(Status.CONNECTING)) {
            logger.fine("Already connected. Return silently.");
            return;
        }
        this.exception = null;
        try {
            Iterator<Connection> connectionIterator = this.connections.iterator();
            while (connectionIterator.hasNext()) {
                Connection connection = connectionIterator.next();
                try {
                    connection.connect(from);
                    this.activeConnection = connection;
                    break;
                }
                catch (IOException e) {
                    if (connectionIterator.hasNext()) {
                        logger.log(Level.WARNING, "{0} failed to connect. Trying alternative connection.", connection);
                        logger.log(Level.FINE, e.getMessage(), e);
                        continue;
                    }
                    throw new ConnectionException(e);
                }
            }
            logger.log(Level.FINE, "Connected via {0}", this.activeConnection);
            logger.fine("Negotiating stream, waiting until SASL is ready to be negotiated.");
            try {
                this.getManager(StreamFeaturesManager.class).awaitNegotiation(Mechanisms.class, 10000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw e;
            }
            XmppSession.throwAsXmppExceptionIfNotNull(this.exception);
            logger.fine("Stream negotiated until SASL, now ready to login.");
            this.updateStatus(Status.CONNECTED);
            if (this.wasLoggedIn) {
                logger.fine("Was already logged in. Re-login automatically with known credentials.");
                this.loginInternal(this.lastMechanisms, this.lastAuthorizationId, this.lastCallbackHandler, this.resource);
            }
        }
        catch (Throwable e) {
            try {
                if (this.activeConnection != null) {
                    this.activeConnection.close();
                    this.activeConnection = null;
                }
            }
            catch (Exception e1) {
                e.addSuppressed(e1);
            }
            this.updateStatus(previousStatus, e);
            XmppSession.throwAsXmppExceptionIfNotNull(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws XmppException {
        if (this.getStatus() == Status.CLOSED || !this.updateStatus(Status.CLOSING)) {
            return;
        }
        try {
            if (this.activeConnection != null) {
                this.activeConnection.close();
                this.activeConnection = null;
            }
        }
        catch (Exception e) {
            XmppSession.throwAsXmppExceptionIfNotNull(e);
        }
        finally {
            this.inboundMessageListeners.clear();
            this.outboundMessageListeners.clear();
            this.inboundPresenceListeners.clear();
            this.outboundPresenceListeners.clear();
            this.inboundIQListeners.clear();
            this.outboundIQListeners.clear();
            this.stanzaListenerExecutor.shutdown();
            this.iqHandlerExecutor.shutdown();
            if (this.shutdownHook != null) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            this.updateStatus(Status.CLOSED);
            this.sessionStatusListeners.clear();
        }
    }

    public void send(ClientStreamElement element) {
        if (!this.isConnected() && this.getStatus() != Status.CONNECTING) {
            throw new IllegalStateException(String.format("Session is not connected to server", new Object[0]));
        }
        if (element instanceof Stanza) {
            Stanza stanza = (Stanza)element;
            if (!(this.getStatus() == Status.AUTHENTICATED || stanza.getExtension(Bind.class) != null || stanza instanceof IQ && ((IQ)stanza).isResponse())) {
                throw new IllegalStateException("Cannot send stanzas before resource binding has completed.");
            }
            if (stanza instanceof Message) {
                this.notifyMessageListeners((Message)stanza, false);
            } else if (stanza instanceof Presence) {
                this.notifyPresenceListeners((Presence)stanza, false);
            } else if (stanza instanceof IQ) {
                this.notifyIQListeners((IQ)stanza, false);
            }
        }
        if (this.activeConnection == null) {
            throw new IllegalStateException("No connection established.");
        }
        this.activeConnection.send(element);
    }

    public final void login(String user, String password) throws XmppException {
        this.login(user, password, null);
    }

    public final void login(String user, String password, String resource) throws XmppException {
        this.login(null, user, password, resource);
    }

    public final void login(String authorizationId, final String user, final String password, String resource) throws XmppException {
        Objects.requireNonNull(user, "user must not be null.");
        Objects.requireNonNull(password, "password must not be null.");
        this.login(authorizationId, new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (Callback callback : callbacks) {
                    if (callback instanceof NameCallback) {
                        ((NameCallback)callback).setName(user);
                    }
                    if (callback instanceof PasswordCallback) {
                        ((PasswordCallback)callback).setPassword(password.toCharArray());
                    }
                    if (!(callback instanceof RealmCallback)) continue;
                    ((RealmCallback)callback).setText(((RealmCallback)callback).getDefaultText());
                }
            }
        }, resource);
    }

    public final void login(String authorizationId, CallbackHandler callbackHandler, String resource) throws XmppException {
        this.loginInternal(this.configuration.getAuthenticationMechanisms(), authorizationId, callbackHandler, resource);
    }

    public final void loginAnonymously() throws XmppException {
        this.loginInternal(Collections.singleton("ANONYMOUS"), null, null, null);
        this.anonymous = true;
    }

    private void loginInternal(Collection<String> mechanisms, String authorizationId, CallbackHandler callbackHandler, String resource) throws XmppException {
        Status previousStatus = this.getStatus();
        if (previousStatus == Status.AUTHENTICATED || !this.updateStatus(Status.AUTHENTICATING)) {
            throw new IllegalStateException("You are already logged in.");
        }
        if (previousStatus != Status.CONNECTED) {
            throw new IllegalStateException("You must be connected to the server before trying to login.");
        }
        if (this.getDomain() == null) {
            throw new IllegalStateException("The XMPP domain must not be null.");
        }
        this.exception = null;
        this.lastMechanisms = mechanisms;
        this.lastAuthorizationId = authorizationId;
        this.lastCallbackHandler = callbackHandler;
        try {
            logger.fine("Starting SASL negotiation (authentication).");
            if (callbackHandler == null) {
                this.authenticationManager.startAuthentication(mechanisms, null, null);
            } else {
                this.authenticationManager.startAuthentication(mechanisms, authorizationId, callbackHandler);
            }
            StreamFeaturesManager streamFeaturesManager = this.getManager(StreamFeaturesManager.class);
            streamFeaturesManager.awaitNegotiation(Bind.class, this.configuration.getDefaultResponseTimeout());
            XmppSession.throwAsXmppExceptionIfNotNull(this.exception);
            this.bindResource(resource);
            streamFeaturesManager.completeNegotiation(this.configuration.getDefaultResponseTimeout());
            XmppSession.throwAsXmppExceptionIfNotNull(this.exception);
            logger.fine("Stream negotiation completed successfully.");
            RosterManager rosterManager = this.getManager(RosterManager.class);
            if (callbackHandler != null && rosterManager.isRetrieveRosterOnLogin()) {
                logger.fine("Retrieving roster on login (as per configuration).");
                rosterManager.requestRoster();
            }
            for (Presence presence : this.getManager(PresenceManager.class).getLastSentPresences()) {
                presence.getExtensions().clear();
                this.send((ClientStreamElement)presence);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.updateStatus(previousStatus, e);
            XmppSession.throwAsXmppExceptionIfNotNull(e);
        }
        catch (Throwable e) {
            this.updateStatus(previousStatus, e);
            XmppSession.throwAsXmppExceptionIfNotNull(e);
        }
        logger.fine("Login successful.");
    }

    private void bindResource(String resource) throws XmppException {
        this.resource = resource;
        logger.log(Level.FINE, "Negotiating resource binding, resource: {0}.", resource);
        IQ iq = new IQ(AbstractIQ.Type.SET, (Object)new Bind(this.resource));
        IQ result = this.query(iq);
        Bind bindResult = (Bind)result.getExtension(Bind.class);
        this.connectedResource = bindResult.getJid();
        logger.log(Level.FINE, "Resource binding completed, connected resource: {0}.", this.connectedResource);
        this.updateStatus(Status.AUTHENTICATED);
        this.wasLoggedIn = true;
        Session session = (Session)this.getManager(StreamFeaturesManager.class).getFeatures().get(Session.class);
        if (session != null && session.isMandatory()) {
            logger.fine("Establishing session.");
            this.query(new IQ(AbstractIQ.Type.SET, (Object)new Session()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean handleElement(final Object element) throws XmppException {
        if (element instanceof IQ) {
            final IQ iq = (IQ)element;
            if (iq.getType() == null) {
                this.send((ClientStreamElement)iq.createError(Condition.BAD_REQUEST));
            } else if (iq.isRequest()) {
                Object payload = iq.getExtension(Object.class);
                if (payload == null) {
                    this.send((ClientStreamElement)iq.createError(Condition.BAD_REQUEST));
                } else {
                    ExecutorService executor;
                    IQHandler iqHandler;
                    Map<Class<?>, IQHandler> map = this.iqHandlerMap;
                    synchronized (map) {
                        iqHandler = this.iqHandlerMap.get(payload.getClass());
                        executor = this.iqHandlerInvocationModes.get(payload.getClass()) != false ? this.iqHandlerExecutor : this.stanzaListenerExecutor;
                    }
                    if (iqHandler != null) {
                        executor.execute(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    IQ response = iqHandler.handleRequest(iq);
                                    if (response != null) {
                                        XmppSession.this.send((ClientStreamElement)response);
                                    }
                                }
                                catch (Exception e) {
                                    logger.log(Level.WARNING, "Failed to handle IQ request: " + e.getMessage(), e);
                                    XmppSession.this.send((ClientStreamElement)iq.createError(Condition.SERVICE_UNAVAILABLE));
                                }
                            }
                        });
                    } else {
                        this.send((ClientStreamElement)iq.createError(Condition.SERVICE_UNAVAILABLE));
                    }
                }
            }
            this.stanzaListenerExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    XmppSession.this.notifyIQListeners(iq, true);
                }
            });
        } else if (element instanceof Message) {
            this.stanzaListenerExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    XmppSession.this.notifyMessageListeners((Message)element, true);
                }
            });
        } else if (element instanceof Presence) {
            this.stanzaListenerExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    XmppSession.this.notifyPresenceListeners((Presence)element, true);
                }
            });
        } else if (element instanceof StreamFeatures) {
            this.getManager(StreamFeaturesManager.class).processFeatures((StreamFeatures)element);
        } else {
            if (element instanceof StreamError) {
                throw new StreamErrorException((StreamError)element);
            }
            return this.getManager(StreamFeaturesManager.class).processElement(element);
        }
        return false;
    }

    private void notifyIQListeners(IQ iq, boolean inbound) {
        IQEvent iqEvent = new IQEvent((Object)this, iq, inbound);
        Set<IQListener> listeners = inbound ? this.inboundIQListeners : this.outboundIQListeners;
        for (IQListener iqListener : listeners) {
            try {
                iqListener.handleIQ(iqEvent);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    private void notifyMessageListeners(Message message, boolean inbound) {
        MessageEvent messageEvent = new MessageEvent((Object)this, message, inbound);
        Set<MessageListener> listeners = inbound ? this.inboundMessageListeners : this.outboundMessageListeners;
        for (MessageListener messageListener : listeners) {
            try {
                messageListener.handleMessage(messageEvent);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    private void notifyPresenceListeners(Presence presence, boolean inbound) {
        PresenceEvent presenceEvent = new PresenceEvent((Object)this, presence, inbound);
        Set<PresenceListener> listeners = inbound ? this.inboundPresenceListeners : this.outboundPresenceListeners;
        for (PresenceListener presenceListener : listeners) {
            try {
                presenceListener.handlePresence(presenceEvent);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    public final void notifyException(Exception e) {
        this.exception = Objects.requireNonNull(e, "exception must not be null");
        this.getManager(StreamFeaturesManager.class).cancelNegotiation();
        if (EnumSet.of(Status.AUTHENTICATED, Status.AUTHENTICATING, Status.CONNECTED, Status.CONNECTING).contains((Object)this.getStatus())) {
            try {
                this.activeConnection.close();
            }
            catch (Exception e1) {
                e.addSuppressed(e1);
            }
            if (this.updateStatus(Status.DISCONNECTED, e)) {
                logger.log(Level.FINE, "Session disconnected due to exception: ", e);
            }
        }
    }

    @Deprecated
    public final <T extends ExtensionManager> T getExtensionManager(Class<T> clazz) {
        return (T)((ExtensionManager)this.getManager(clazz));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T extends Manager> T getManager(Class<T> clazz) {
        Manager instance = this.instances.get(clazz);
        if (instance == null) {
            Map<Class<? extends Manager>, Manager> map = this.instances;
            synchronized (map) {
                instance = this.instances.get(clazz);
                if (instance == null) {
                    try {
                        Constructor<T> constructor = clazz.getDeclaredConstructor(XmppSession.class);
                        constructor.setAccessible(true);
                        instance = (Manager)constructor.newInstance(this);
                        instance.initialize();
                        this.instances.put(clazz, instance);
                    }
                    catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                        throw new IllegalArgumentException("Can't instantiate the provided class.", e);
                    }
                }
            }
        }
        return (T)instance;
    }

    @Deprecated
    public final RosterManager getRosterManager() {
        return this.getManager(RosterManager.class);
    }

    @Deprecated
    public final PresenceManager getPresenceManager() {
        return this.getManager(PresenceManager.class);
    }

    @Deprecated
    public final ReconnectionManager getReconnectionManager() {
        return this.getManager(ReconnectionManager.class);
    }

    @Deprecated
    public final StreamFeaturesManager getStreamFeaturesManager() {
        return this.getManager(StreamFeaturesManager.class);
    }

    @Deprecated
    public final ChatManager getChatManager() {
        return this.getManager(ChatManager.class);
    }

    public final Jid getConnectedResource() {
        return this.connectedResource;
    }

    public final String getDomain() {
        return this.xmppServiceDomain;
    }

    public final synchronized Status getStatus() {
        return this.status;
    }

    final boolean updateStatus(Status status) {
        return this.updateStatus(status, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean updateStatus(Status status, Throwable e) {
        Status oldStatus;
        XmppSession xmppSession = this;
        synchronized (xmppSession) {
            oldStatus = this.status;
            this.status = status;
        }
        if (status != oldStatus) {
            this.notifySessionStatusListeners(status, oldStatus, e);
        }
        return status != oldStatus;
    }

    private void notifySessionStatusListeners(Status status, Status oldStatus, Throwable throwable) {
        SessionStatusEvent sessionStatusEvent = new SessionStatusEvent(this, status, oldStatus, throwable);
        for (SessionStatusListener sessionStatusListener : this.sessionStatusListeners) {
            try {
                sessionStatusListener.sessionStatusChanged(sessionStatusEvent);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    public final List<Connection> getConnections() {
        return Collections.unmodifiableList(this.connections);
    }

    public final Unmarshaller createUnmarshaller() {
        try {
            return this.configuration.getJAXBContext().createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public final Marshaller createMarshaller() {
        try {
            Marshaller marshaller = this.configuration.getJAXBContext().createMarshaller();
            marshaller.setProperty("jaxb.fragment", (Object)true);
            return marshaller;
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public final int getDefaultTimeout() {
        return this.configuration.getDefaultResponseTimeout();
    }

    public final boolean isConnected() {
        return EnumSet.of(Status.CONNECTED, Status.AUTHENTICATED, Status.AUTHENTICATING).contains((Object)this.getStatus());
    }

    public final boolean isAnonymous() {
        return this.anonymous;
    }

    public final XmppSessionConfiguration getConfiguration() {
        return this.configuration;
    }

    public final XmppDebugger getDebugger() {
        return this.debugger;
    }

    public static enum Status {
        INITIAL,
        CONNECTING,
        CONNECTED,
        AUTHENTICATING,
        AUTHENTICATED,
        DISCONNECTED,
        CLOSING,
        CLOSED;

    }
}

