/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.session;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.EnumSet;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.Marshaller;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.XmppUtils;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.session.debug.XmppDebugger;
import rocks.xmpp.core.stanza.model.Stanza;
import rocks.xmpp.core.stream.model.ClientStreamElement;

final class XmppStreamWriter {
    private final XmppSession xmppSession;
    private final ExecutorService executor;
    private final XMLOutputFactory xmlOutputFactory;
    private final Marshaller marshaller;
    private final XmppDebugger debugger;
    private ScheduledExecutorService keepAliveExecutor;
    private XMLStreamWriter prefixFreeCanonicalizationWriter;
    private XMLStreamWriter xmlStreamWriter;
    private ByteArrayOutputStream byteArrayOutputStream;
    private boolean streamOpened;

    XmppStreamWriter(XmppSession xmppSession, XMLOutputFactory xmlOutputFactory) {
        this.xmppSession = xmppSession;
        this.xmlOutputFactory = xmlOutputFactory;
        this.marshaller = xmppSession.createMarshaller();
        this.debugger = xmppSession.getDebugger();
        this.executor = Executors.newSingleThreadExecutor(XmppUtils.createNamedThreadFactory((String)"XMPP Writer Thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initialize(int keepAliveInterval) {
        if (keepAliveInterval > 0) {
            XmppStreamWriter xmppStreamWriter = this;
            synchronized (xmppStreamWriter) {
                this.keepAliveExecutor = Executors.newSingleThreadScheduledExecutor(XmppUtils.createNamedThreadFactory((String)"XMPP KeepAlive Thread"));
                this.keepAliveExecutor.scheduleAtFixedRate(new Runnable(){

                    @Override
                    public void run() {
                        if (EnumSet.of(XmppSession.Status.CONNECTED, XmppSession.Status.AUTHENTICATED).contains((Object)XmppStreamWriter.this.xmppSession.getStatus())) {
                            XmppStreamWriter.this.executor.execute(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        XmppStreamWriter.this.xmlStreamWriter.writeCharacters(" ");
                                        XmppStreamWriter.this.xmlStreamWriter.flush();
                                    }
                                    catch (Exception e) {
                                        XmppStreamWriter.this.notifyException(e);
                                    }
                                }
                            });
                        }
                    }
                }, 0L, keepAliveInterval, TimeUnit.SECONDS);
            }
        }
    }

    synchronized void send(final ClientStreamElement clientStreamElement) {
        if (!this.executor.isShutdown() && clientStreamElement != null) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        XmppStreamWriter.this.marshaller.marshal((Object)clientStreamElement, XmppStreamWriter.this.prefixFreeCanonicalizationWriter);
                        XmppStreamWriter.this.prefixFreeCanonicalizationWriter.flush();
                        if (clientStreamElement instanceof Stanza) {
                            XmppStreamWriter.this.prefixFreeCanonicalizationWriter.writeCharacters(" ");
                            XmppStreamWriter.this.prefixFreeCanonicalizationWriter.flush();
                        }
                        if (XmppStreamWriter.this.debugger != null) {
                            XmppStreamWriter.this.debugger.writeStanza(new String(XmppStreamWriter.this.byteArrayOutputStream.toByteArray()).trim(), clientStreamElement);
                            XmppStreamWriter.this.byteArrayOutputStream.reset();
                        }
                    }
                    catch (Exception e) {
                        XmppStreamWriter.this.notifyException(e);
                    }
                }
            });
        }
    }

    synchronized void openStream(final OutputStream outputStream, final Jid from) {
        if (!this.executor.isShutdown()) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        OutputStream xmppOutputStream;
                        if (XmppStreamWriter.this.debugger != null) {
                            XmppStreamWriter.this.byteArrayOutputStream = new ByteArrayOutputStream();
                            xmppOutputStream = XmppStreamWriter.this.debugger.createOutputStream(XmppUtils.createBranchedOutputStream((OutputStream)outputStream, (OutputStream)XmppStreamWriter.this.byteArrayOutputStream));
                        } else {
                            xmppOutputStream = outputStream;
                        }
                        XmppStreamWriter.this.xmlStreamWriter = XmppStreamWriter.this.xmlOutputFactory.createXMLStreamWriter(xmppOutputStream, "UTF-8");
                        XmppStreamWriter.this.prefixFreeCanonicalizationWriter = XmppUtils.createXmppStreamWriter((XMLStreamWriter)XmppStreamWriter.this.xmlStreamWriter, (boolean)true);
                        XmppStreamWriter.this.streamOpened = false;
                        XmppStreamWriter.this.xmlStreamWriter.writeStartDocument("UTF-8", "1.0");
                        XmppStreamWriter.this.xmlStreamWriter.writeStartElement("stream", "stream", "http://etherx.jabber.org/streams");
                        XmppStreamWriter.this.xmlStreamWriter.writeAttribute("xml", "http://www.w3.org/XML/1998/namespace", "lang", Locale.getDefault().getLanguage());
                        if (XmppStreamWriter.this.xmppSession.getDomain() != null && !XmppStreamWriter.this.xmppSession.getDomain().isEmpty()) {
                            XmppStreamWriter.this.xmlStreamWriter.writeAttribute("to", XmppStreamWriter.this.xmppSession.getDomain());
                        }
                        if (from != null) {
                            XmppStreamWriter.this.xmlStreamWriter.writeAttribute("from", from.toString());
                        }
                        XmppStreamWriter.this.xmlStreamWriter.writeAttribute("version", "1.0");
                        XmppStreamWriter.this.xmlStreamWriter.writeNamespace("", "jabber:client");
                        XmppStreamWriter.this.xmlStreamWriter.writeNamespace("stream", "http://etherx.jabber.org/streams");
                        XmppStreamWriter.this.xmlStreamWriter.writeCharacters("");
                        XmppStreamWriter.this.xmlStreamWriter.flush();
                        if (XmppStreamWriter.this.debugger != null) {
                            XmppStreamWriter.this.debugger.writeStanza(new String(XmppStreamWriter.this.byteArrayOutputStream.toByteArray()).trim(), null);
                            XmppStreamWriter.this.byteArrayOutputStream.reset();
                        }
                        XmppStreamWriter.this.streamOpened = true;
                    }
                    catch (Exception e) {
                        XmppStreamWriter.this.notifyException(e);
                    }
                }
            });
        }
    }

    private void closeStream() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                if (XmppStreamWriter.this.streamOpened) {
                    try {
                        XmppStreamWriter.this.xmlStreamWriter.writeEndElement();
                        XmppStreamWriter.this.xmlStreamWriter.flush();
                        if (XmppStreamWriter.this.debugger != null) {
                            XmppStreamWriter.this.debugger.writeStanza(new String(XmppStreamWriter.this.byteArrayOutputStream.toByteArray()).trim(), null);
                            XmppStreamWriter.this.byteArrayOutputStream.reset();
                        }
                        XmppStreamWriter.this.xmlStreamWriter.close();
                        XmppStreamWriter.this.streamOpened = false;
                    }
                    catch (Exception e) {
                        XmppStreamWriter.this.notifyException(e);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyException(Exception exception) {
        XmppStreamWriter xmppStreamWriter = this;
        synchronized (xmppStreamWriter) {
            if (this.keepAliveExecutor != null) {
                this.keepAliveExecutor.shutdown();
                this.keepAliveExecutor = null;
            }
            this.executor.shutdown();
            if (this.prefixFreeCanonicalizationWriter != null) {
                try {
                    this.prefixFreeCanonicalizationWriter.close();
                    this.prefixFreeCanonicalizationWriter = null;
                }
                catch (Exception e) {
                    exception.addSuppressed(e);
                }
            }
            this.byteArrayOutputStream = null;
        }
        this.xmppSession.notifyException(exception);
    }

    synchronized void shutdown() {
        if (!this.executor.isShutdown()) {
            this.closeStream();
            if (this.keepAliveExecutor != null) {
                this.keepAliveExecutor.shutdown();
            }
            this.executor.shutdown();
            try {
                if (this.keepAliveExecutor != null) {
                    this.keepAliveExecutor.awaitTermination(100L, TimeUnit.MILLISECONDS);
                }
                this.executor.awaitTermination(250L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

