/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.stanza;

import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.stanza.IQHandler;
import rocks.xmpp.core.stanza.model.AbstractIQ;
import rocks.xmpp.core.stanza.model.StanzaError;
import rocks.xmpp.core.stanza.model.client.IQ;
import rocks.xmpp.core.stanza.model.errors.Condition;

public abstract class AbstractIQHandler
implements IQHandler {
    private final AbstractIQ.Type type;
    private final Manager manager;

    protected AbstractIQHandler(Manager manager, AbstractIQ.Type type) {
        if (type != AbstractIQ.Type.GET && type != AbstractIQ.Type.SET) {
            throw new IllegalArgumentException("type must be 'get' or 'set'");
        }
        this.type = type;
        this.manager = manager;
    }

    @Override
    public final IQ handleRequest(IQ iq) {
        if (this.manager.isEnabled()) {
            if (iq.getType() == this.type) {
                return this.processRequest(iq);
            }
            return iq.createError(new StanzaError(Condition.BAD_REQUEST, String.format("Type was '%s', but expected '%s'.", iq.getType().toString().toLowerCase(), this.type.toString().toLowerCase())));
        }
        return iq.createError(Condition.SERVICE_UNAVAILABLE);
    }

    protected abstract IQ processRequest(IQ var1);
}

