/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.disco;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import rocks.xmpp.extensions.disco.model.items.Item;
import rocks.xmpp.extensions.rsm.ResultSetProvider;

public final class DefaultItemProvider
implements ResultSetProvider<Item> {
    private final Collection<Item> items;

    public DefaultItemProvider(Collection<Item> items) {
        this.items = items;
    }

    @Override
    public List<Item> getItems() {
        return Collections.unmodifiableList(new ArrayList<Item>(this.items));
    }

    @Override
    public int getItemCount() {
        return this.items.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Item> getItems(int index, int maxSize) {
        int toIndex = index + maxSize;
        Collection<Item> collection = this.items;
        synchronized (collection) {
            if (index < 0 || toIndex > this.items.size() || index > toIndex) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(new ArrayList<Item>(this.items).subList(index, toIndex));
        }
    }

    @Override
    public List<Item> getItemsAfter(String itemId, int maxSize) {
        return this.getItems(this.indexOf(itemId) + 1, maxSize);
    }

    @Override
    public List<Item> getItemsBefore(String itemId, int maxSize) {
        return this.getItems(this.indexOf(itemId) - maxSize, maxSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int indexOf(String itemId) {
        Collection<Item> collection = this.items;
        synchronized (collection) {
            for (int i = 0; i < this.items.size(); ++i) {
                Item item = new ArrayList<Item>(this.items).get(i);
                if (item.getId() == null || !item.getId().equals(itemId)) continue;
                return i;
            }
        }
        return -1;
    }
}

